/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.byteCode.Access;
import com.facebook.presto.byteCode.Block;
import com.facebook.presto.byteCode.ClassDefinition;
import com.facebook.presto.byteCode.CompilerContext;
import com.facebook.presto.byteCode.DynamicClassLoader;
import com.facebook.presto.byteCode.NamedParameterDefinition;
import com.facebook.presto.byteCode.ParameterizedType;
import com.facebook.presto.byteCode.Variable;
import com.facebook.presto.metadata.FunctionInfo;
import com.facebook.presto.metadata.ParametricScalar;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.TypeParameter;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.sql.gen.ByteCodeUtils;
import com.facebook.presto.sql.gen.CompilerUtils;
import com.facebook.presto.type.MapParametricType;
import com.facebook.presto.type.MapType;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Primitives;
import io.airlift.slice.Slice;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class MapConstructor
extends ParametricScalar {
    private final Signature signature;
    private final TypeManager typeManager;

    public MapConstructor(int pairs, TypeManager typeManager) {
        this.typeManager = (TypeManager)Preconditions.checkNotNull((Object)typeManager, (Object)"typeManager is null");
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < pairs; ++i) {
            builder.add((Object)"K");
            builder.add((Object)"V");
        }
        this.signature = new Signature("map", (List<TypeParameter>)ImmutableList.of((Object)Signature.typeParameter("K"), (Object)Signature.typeParameter("V")), "map<K,V>", (List<String>)builder.build(), false, true);
    }

    @Override
    public Signature getSignature() {
        return this.signature;
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public boolean isDeterministic() {
        return true;
    }

    @Override
    public String getDescription() {
        return "Map constructor";
    }

    @Override
    public FunctionInfo specialize(Map<String, Type> types, int arity) {
        MethodHandle methodHandle;
        Type keyType = types.get("K");
        Type valueType = types.get("V");
        ImmutableList.Builder builder = ImmutableList.builder();
        ImmutableList.Builder actualArgumentNames = ImmutableList.builder();
        for (int i = 0; i < arity; ++i) {
            Type type = i % 2 == 0 ? keyType : valueType;
            actualArgumentNames.add((Object)type.getName());
            if (type.getJavaType().isPrimitive()) {
                builder.add((Object)Primitives.wrap((Class)type.getJavaType()));
                continue;
            }
            builder.add((Object)type.getJavaType());
        }
        ImmutableList stackTypes = builder.build();
        Class<?> clazz = MapConstructor.generateMapConstructor(stackTypes);
        try {
            Method method = clazz.getMethod("mapConstructor", (Class[])stackTypes.toArray((Object[])new Class[stackTypes.size()]));
            methodHandle = MethodHandles.lookup().unreflect(method);
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw Throwables.propagate((Throwable)e);
        }
        Type mapType = this.typeManager.getParameterizedType(MapParametricType.MAP.getName(), (List)ImmutableList.of((Object)keyType.getName(), (Object)valueType.getName()));
        Signature signature = new Signature("map", (List<TypeParameter>)ImmutableList.of(), mapType.getName(), (List<String>)actualArgumentNames.build(), false, true);
        ImmutableList nullableParameters = ImmutableList.copyOf(Collections.nCopies(stackTypes.size(), true));
        return new FunctionInfo(signature, "Constructs a map of the given entries", true, methodHandle, true, false, (List<Boolean>)nullableParameters);
    }

    private static Class<?> generateMapConstructor(List<Class<?>> stackTypes) {
        ImmutableList stackTypeNames = FluentIterable.from(stackTypes).transform(new Function<Class<?>, String>(){

            public String apply(Class<?> input) {
                return input.getSimpleName();
            }
        }).toList();
        ClassDefinition definition = new ClassDefinition(new CompilerContext(null), Access.a(Access.PUBLIC, Access.FINAL), CompilerUtils.makeClassName(Joiner.on((String)"").join((Iterable)stackTypeNames) + "MapConstructor"), ParameterizedType.type(Object.class), new ParameterizedType[0]);
        definition.declareDefaultConstructor(Access.a(Access.PRIVATE));
        ImmutableList.Builder parameters = ImmutableList.builder();
        for (int i = 0; i < stackTypes.size(); ++i) {
            Class<?> stackType = stackTypes.get(i);
            parameters.add((Object)NamedParameterDefinition.arg("arg" + i, stackType));
        }
        CompilerContext context = new CompilerContext(null);
        Block body = definition.declareMethod(context, Access.a(Access.PUBLIC, Access.STATIC), "mapConstructor", ParameterizedType.type(Slice.class), (Iterable<NamedParameterDefinition>)parameters.build()).getBody();
        Variable valuesVariable = context.declareVariable(Map.class, "values");
        body.comment("Map<Object, Object> values = new HashMap();").newObject(HashMap.class).dup().invokeConstructor(HashMap.class, new Class[0]).putVariable(valuesVariable);
        for (int i = 0; i < stackTypes.size(); i += 2) {
            body.comment("values.put(arg%d, arg%d)", i, i + 1).getVariable(valuesVariable).getVariable("arg" + i);
            Class<?> stackType = stackTypes.get(i);
            if (stackType.isPrimitive()) {
                body.append(ByteCodeUtils.boxPrimitiveIfNecessary(context, stackType));
            }
            body.getVariable("arg" + (i + 1));
            stackType = stackTypes.get(i + 1);
            if (stackType.isPrimitive()) {
                body.append(ByteCodeUtils.boxPrimitiveIfNecessary(context, stackType));
            }
            body.invokeInterface(Map.class, "put", Object.class, Object.class, Object.class);
        }
        body.comment("return toStackRepresentation(values);").getVariable(valuesVariable).invokeStatic(MapType.class, "toStackRepresentation", Slice.class, Map.class).retObject();
        return CompilerUtils.defineClass(definition, Object.class, new DynamicClassLoader());
    }
}

