/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.operator.scalar.ScalarFunction;
import com.facebook.presto.operator.scalar.StringFunctions;
import com.facebook.presto.type.SqlType;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.awt.Color;
import java.nio.charset.Charset;

public final class ColorFunctions {
    private static final String ANSI_RESET = "\u001b[0m";
    private static final Slice RENDERED_TRUE = ColorFunctions.render(Slices.copiedBuffer((String)"\u2713", (Charset)Charsets.UTF_8), ColorFunctions.color(Slices.copiedBuffer((String)"green", (Charset)Charsets.UTF_8)));
    private static final Slice RENDERED_FALSE = ColorFunctions.render(Slices.copiedBuffer((String)"\u2717", (Charset)Charsets.UTF_8), ColorFunctions.color(Slices.copiedBuffer((String)"red", (Charset)Charsets.UTF_8)));

    private ColorFunctions() {
    }

    @ScalarFunction
    @SqlType(value="color")
    public static long color(@SqlType(value="varchar") Slice color) {
        int rgb = ColorFunctions.parseRgb(color);
        if (rgb != -1) {
            return rgb;
        }
        try {
            SystemColor systemColor = SystemColor.valueOf(StringFunctions.upper(color).toString(Charsets.UTF_8));
            int index = systemColor.getIndex();
            return -(index + 1);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(String.format("Invalid color: '%s'", color.toString(Charsets.UTF_8)), e);
        }
    }

    @ScalarFunction
    @SqlType(value="color")
    public static long rgb(@SqlType(value="bigint") long red, @SqlType(value="bigint") long green, @SqlType(value="bigint") long blue) {
        Preconditions.checkArgument((red >= 0L && red <= 255L ? 1 : 0) != 0, (Object)"red must be between 0 and 255");
        Preconditions.checkArgument((green >= 0L && green <= 255L ? 1 : 0) != 0, (Object)"green must be between 0 and 255");
        Preconditions.checkArgument((blue >= 0L && blue <= 255L ? 1 : 0) != 0, (Object)"blue must be between 0 and 255");
        return red << 16 | green << 8 | blue;
    }

    @ScalarFunction
    @SqlType(value="color")
    public static long color(@SqlType(value="double") double value, @SqlType(value="double") double low, @SqlType(value="double") double high, @SqlType(value="color") long lowColor, @SqlType(value="color") long highColor) {
        return ColorFunctions.color((value - low) * 1.0 / (high - low), lowColor, highColor);
    }

    @ScalarFunction
    @SqlType(value="color")
    public static long color(@SqlType(value="double") double fraction, @SqlType(value="color") long lowColor, @SqlType(value="color") long highColor) {
        Preconditions.checkArgument((lowColor >= 0L ? 1 : 0) != 0, (Object)"lowColor not a valid RGB color");
        Preconditions.checkArgument((highColor >= 0L ? 1 : 0) != 0, (Object)"highColor not a valid RGB color");
        fraction = Math.min(1.0, fraction);
        fraction = Math.max(0.0, fraction);
        return ColorFunctions.interpolate((float)fraction, lowColor, highColor);
    }

    @ScalarFunction
    @SqlType(value="varchar")
    public static Slice render(@SqlType(value="varchar") Slice value, @SqlType(value="color") long color) {
        StringBuilder builder = new StringBuilder(value.length());
        builder.append(ColorFunctions.ansiColorEscape(color)).append(value.toString(Charsets.UTF_8)).append(ANSI_RESET);
        return Slices.copiedBuffer((String)builder.toString(), (Charset)Charsets.UTF_8);
    }

    @ScalarFunction
    @SqlType(value="varchar")
    public static Slice render(@SqlType(value="bigint") long value, @SqlType(value="color") long color) {
        return ColorFunctions.render(Slices.copiedBuffer((String)Long.toString(value), (Charset)Charsets.UTF_8), color);
    }

    @ScalarFunction
    @SqlType(value="varchar")
    public static Slice render(@SqlType(value="double") double value, @SqlType(value="color") long color) {
        return ColorFunctions.render(Slices.copiedBuffer((String)Double.toString(value), (Charset)Charsets.UTF_8), color);
    }

    @ScalarFunction
    @SqlType(value="varchar")
    public static Slice render(@SqlType(value="boolean") boolean value) {
        return value ? RENDERED_TRUE : RENDERED_FALSE;
    }

    @ScalarFunction
    @SqlType(value="varchar")
    public static Slice bar(@SqlType(value="double") double percent, @SqlType(value="bigint") long width) {
        return ColorFunctions.bar(percent, width, ColorFunctions.rgb(255L, 0L, 0L), ColorFunctions.rgb(0L, 255L, 0L));
    }

    @ScalarFunction
    @SqlType(value="varchar")
    public static Slice bar(@SqlType(value="double") double percent, @SqlType(value="bigint") long width, @SqlType(value="color") long lowColor, @SqlType(value="color") long highColor) {
        long count = (int)(percent * (double)width);
        count = Math.min(width, count);
        count = Math.max(0L, count);
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while ((long)i < count) {
            float fraction = (float)((double)i * 1.0 / (double)(width - 1L));
            int color = ColorFunctions.interpolate(fraction, lowColor, highColor);
            builder.append(ColorFunctions.ansiColorEscape(color)).append('\u2588');
            ++i;
        }
        builder.append(ANSI_RESET);
        for (long i2 = count; i2 < width; ++i2) {
            builder.append(' ');
        }
        return Slices.copiedBuffer((String)builder.toString(), (Charset)Charsets.UTF_8);
    }

    private static int interpolate(float fraction, long lowRgb, long highRgb) {
        float[] lowHsv = Color.RGBtoHSB(ColorFunctions.getRed(lowRgb), ColorFunctions.getGreen(lowRgb), ColorFunctions.getBlue(lowRgb), null);
        float[] highHsv = Color.RGBtoHSB(ColorFunctions.getRed(highRgb), ColorFunctions.getGreen(highRgb), ColorFunctions.getBlue(highRgb), null);
        float h = fraction * (highHsv[0] - lowHsv[0]) + lowHsv[0];
        float s = fraction * (highHsv[1] - lowHsv[1]) + lowHsv[1];
        float v = fraction * (highHsv[2] - lowHsv[2]) + lowHsv[2];
        return Color.HSBtoRGB(h, s, v) & 0xFFFFFF;
    }

    private static int toAnsi(int red, int green, int blue) {
        red = red * 6 / 256;
        green = green * 6 / 256;
        blue = blue * 6 / 256;
        return 16 + red * 36 + green * 6 + blue;
    }

    private static String ansiColorEscape(long color) {
        return "\u001b[38;5;" + ColorFunctions.toAnsi(color) + 'm';
    }

    private static int toAnsi(long color) {
        if (color >= 0L) {
            return ColorFunctions.toAnsi(ColorFunctions.getRed(color), ColorFunctions.getGreen(color), ColorFunctions.getBlue(color));
        }
        return (int)(-color - 1L);
    }

    @VisibleForTesting
    static int parseRgb(Slice color) {
        if (color.length() != 4 || color.getByte(0) != 35) {
            return -1;
        }
        int red = Character.digit((char)color.getByte(1), 16);
        int green = Character.digit((char)color.getByte(2), 16);
        int blue = Character.digit((char)color.getByte(3), 16);
        if (red == -1 || green == -1 || blue == -1) {
            return -1;
        }
        red = red << 4 | red;
        green = green << 4 | green;
        blue = blue << 4 | blue;
        return (int)ColorFunctions.rgb(red, green, blue);
    }

    @VisibleForTesting
    static int getRed(long color) {
        Preconditions.checkArgument((color >= 0L ? 1 : 0) != 0, (Object)"color is not a valid rgb value");
        return (int)(color >>> 16 & 0xFFL);
    }

    @VisibleForTesting
    static int getGreen(long color) {
        Preconditions.checkArgument((color >= 0L ? 1 : 0) != 0, (Object)"color is not a valid rgb value");
        return (int)(color >>> 8 & 0xFFL);
    }

    @VisibleForTesting
    static int getBlue(long color) {
        Preconditions.checkArgument((color >= 0L ? 1 : 0) != 0, (Object)"color is not a valid rgb value");
        return (int)(color & 0xFFL);
    }

    public static enum SystemColor {
        BLACK(0, "black"),
        RED(1, "red"),
        GREEN(2, "green"),
        YELLOW(3, "yellow"),
        BLUE(4, "blue"),
        MAGENTA(5, "magenta"),
        CYAN(6, "cyan"),
        WHITE(7, "white");

        private final int index;
        private final String name;

        private SystemColor(int index, String name) {
            this.index = index;
            this.name = name;
        }

        private int getIndex() {
            return this.index;
        }

        public String getName() {
            return this.name;
        }

        public static SystemColor valueOf(int index) {
            for (SystemColor color : SystemColor.values()) {
                if (index != color.getIndex()) continue;
                return color;
            }
            throw new IllegalArgumentException(String.format("invalid index: %s", index));
        }
    }
}

