/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.metadata.FunctionInfo;
import com.facebook.presto.metadata.OperatorType;
import com.facebook.presto.metadata.ParametricOperator;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.TypeParameter;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.type.TypeUtils;
import com.facebook.presto.util.Failures;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Map;

public class ArraySubscriptOperator
extends ParametricOperator {
    public static final ArraySubscriptOperator ARRAY_SUBSCRIPT = new ArraySubscriptOperator();
    private static final JsonFactory JSON_FACTORY = new JsonFactory().disable(JsonFactory.Feature.CANONICALIZE_FIELD_NAMES);
    private static final Map<Class<?>, MethodHandle> METHOD_HANDLES;

    protected ArraySubscriptOperator() {
        super(OperatorType.SUBSCRIPT, (List<TypeParameter>)ImmutableList.of((Object)Signature.typeParameter("E")), "E", (List<String>)ImmutableList.of((Object)"array<E>", (Object)"bigint"));
    }

    @Override
    public String getDescription() {
        return "Array subscript";
    }

    @Override
    public FunctionInfo specialize(Map<String, Type> types, int arity) {
        Preconditions.checkArgument((types.size() == 1 ? 1 : 0) != 0, (String)"Expected one type, got %s", (Object[])new Object[]{types});
        Type elementType = types.get("E");
        MethodHandle methodHandle = METHOD_HANDLES.get(elementType.getJavaType());
        Preconditions.checkNotNull((Object)methodHandle, (Object)"methodHandle is null");
        return new FunctionInfo(Signature.internalOperator(OperatorType.SUBSCRIPT.name(), elementType.getName(), TypeUtils.parameterizedTypeName("array", elementType.getName()), "bigint"), "Array subscript", true, methodHandle, true, true, (List<Boolean>)ImmutableList.of((Object)false, (Object)false));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Boolean booleanElementAccessor(Slice array, long index) {
        Failures.checkCondition(index > 0L, StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Array index must be greater than zero. Got %d", index);
        try (JsonParser jsonParser = JSON_FACTORY.createJsonParser((InputStream)array.getInput());){
            Preconditions.checkState((jsonParser.nextToken() == JsonToken.START_ARRAY ? 1 : 0) != 0, (String)"Expected start of array in input: \"%s\"", (Object[])new Object[]{array.toStringUtf8()});
            jsonParser.nextToken();
            ArraySubscriptOperator.seekTo(jsonParser, index);
            if (jsonParser.getCurrentToken() == JsonToken.VALUE_NULL) {
                Boolean bl = null;
                return bl;
            }
            Boolean bl = jsonParser.getBooleanValue();
            return bl;
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Long longElementAccessor(Slice array, long index) {
        Failures.checkCondition(index > 0L, StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Array index must be greater than zero. Got %d", index);
        try (JsonParser jsonParser = JSON_FACTORY.createJsonParser((InputStream)array.getInput());){
            Preconditions.checkState((jsonParser.nextToken() == JsonToken.START_ARRAY ? 1 : 0) != 0, (String)"Expected start of array in input: \"%s\"", (Object[])new Object[]{array.toStringUtf8()});
            jsonParser.nextToken();
            ArraySubscriptOperator.seekTo(jsonParser, index);
            if (jsonParser.getCurrentToken() == JsonToken.VALUE_NULL) {
                Long l = null;
                return l;
            }
            Long l = jsonParser.getLongValue();
            return l;
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Double doubleElementAccessor(Slice array, long index) {
        Failures.checkCondition(index > 0L, StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Array index must be greater than zero. Got %d", index);
        try (JsonParser jsonParser = JSON_FACTORY.createJsonParser((InputStream)array.getInput());){
            Preconditions.checkState((jsonParser.nextToken() == JsonToken.START_ARRAY ? 1 : 0) != 0, (String)"Expected start of array in input: \"%s\"", (Object[])new Object[]{array.toStringUtf8()});
            jsonParser.nextToken();
            ArraySubscriptOperator.seekTo(jsonParser, index);
            if (jsonParser.getCurrentToken() == JsonToken.VALUE_NULL) {
                Double d = null;
                return d;
            }
            Double d = jsonParser.getDoubleValue();
            return d;
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Slice sliceElementAccessor(Slice array, long index) {
        Failures.checkCondition(index > 0L, StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Array index must be greater than zero. Got %d", index);
        try (JsonParser jsonParser = JSON_FACTORY.createJsonParser((InputStream)array.getInput());){
            Preconditions.checkState((jsonParser.nextToken() == JsonToken.START_ARRAY ? 1 : 0) != 0, (String)"Expected start of array in input: \"%s\"", (Object[])new Object[]{array.toStringUtf8()});
            jsonParser.nextToken();
            ArraySubscriptOperator.seekTo(jsonParser, index);
            String stringValue = jsonParser.getValueAsString();
            if (stringValue == null) {
                Slice slice = null;
                return slice;
            }
            Slice slice = Slices.utf8Slice((String)stringValue);
            return slice;
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private static void seekTo(JsonParser jsonParser, long position) throws IOException {
        for (long i = 1L; i < position; ++i) {
            JsonToken token = jsonParser.nextToken();
            if (token != null && token != JsonToken.END_ARRAY) continue;
            throw new PrestoException(StandardErrorCode.INVALID_FUNCTION_ARGUMENT.toErrorCode(), "Index out of bounds");
        }
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        try {
            builder.put(Boolean.TYPE, (Object)MethodHandles.lookup().unreflect(ArraySubscriptOperator.class.getMethod("booleanElementAccessor", Slice.class, Long.TYPE)));
            builder.put(Long.TYPE, (Object)MethodHandles.lookup().unreflect(ArraySubscriptOperator.class.getMethod("longElementAccessor", Slice.class, Long.TYPE)));
            builder.put(Double.TYPE, (Object)MethodHandles.lookup().unreflect(ArraySubscriptOperator.class.getMethod("doubleElementAccessor", Slice.class, Long.TYPE)));
            builder.put(Slice.class, (Object)MethodHandles.lookup().unreflect(ArraySubscriptOperator.class.getMethod("sliceElementAccessor", Slice.class, Long.TYPE)));
        }
        catch (ReflectiveOperationException e) {
            throw Throwables.propagate((Throwable)e);
        }
        METHOD_HANDLES = builder.build();
    }
}

