/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.index;

import com.facebook.presto.operator.GroupByHash;
import com.facebook.presto.operator.index.IndexSnapshot;
import com.facebook.presto.operator.index.UpdateRequest;
import com.facebook.presto.spi.RecordCursor;
import com.facebook.presto.spi.RecordSet;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class UnloadedIndexKeyRecordSet
implements RecordSet {
    private final List<Type> types;
    private final List<PageAndPositions> pageAndPositions;

    public UnloadedIndexKeyRecordSet(IndexSnapshot existingSnapshot, List<Type> types, List<UpdateRequest> requests) {
        Preconditions.checkNotNull((Object)existingSnapshot, (Object)"existingSnapshot is null");
        this.types = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(types, (Object)"types is null")));
        Preconditions.checkNotNull(requests, (Object)"requests is null");
        int[] allChannels = new int[types.size()];
        for (int i = 0; i < allChannels.length; ++i) {
            allChannels[i] = i;
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        long nextDistinctId = 0L;
        GroupByHash groupByHash = new GroupByHash(types, allChannels, 10000);
        for (UpdateRequest request : requests) {
            IntArrayList positions = new IntArrayList();
            Block[] blocks = request.getBlocks();
            int positionCount = blocks[0].getPositionCount();
            for (int position = 0; position < positionCount; ++position) {
                if (UnloadedIndexKeyRecordSet.containsNullValue(position, blocks) || (long)groupByHash.putIfAbsent(position, blocks) != nextDistinctId) continue;
                ++nextDistinctId;
                if (existingSnapshot.getJoinPosition(position, blocks) != -2L) continue;
                positions.add(position);
            }
            if (positions.isEmpty()) continue;
            builder.add((Object)new PageAndPositions(request, (IntList)positions));
        }
        this.pageAndPositions = builder.build();
    }

    public List<Type> getColumnTypes() {
        return this.types;
    }

    public UnloadedIndexKeyRecordCursor cursor() {
        return new UnloadedIndexKeyRecordCursor(this.types, this.pageAndPositions);
    }

    private static boolean containsNullValue(int position, Block ... blocks) {
        for (Block block : blocks) {
            if (!block.isNull(position)) continue;
            return true;
        }
        return false;
    }

    private static class PageAndPositions {
        private final UpdateRequest updateRequest;
        private final IntList positions;

        private PageAndPositions(UpdateRequest updateRequest, IntList positions) {
            this.updateRequest = (UpdateRequest)Preconditions.checkNotNull((Object)updateRequest, (Object)"updateRequest is null");
            this.positions = (IntList)Preconditions.checkNotNull((Object)positions, (Object)"positions is null");
        }

        private UpdateRequest getUpdateRequest() {
            return this.updateRequest;
        }

        private IntList getPositions() {
            return this.positions;
        }
    }

    public static class UnloadedIndexKeyRecordCursor
    implements RecordCursor {
        private final List<Type> types;
        private final Iterator<PageAndPositions> pageAndPositionsIterator;
        private Block[] blocks;
        private IntListIterator positionIterator;
        private int position;

        public UnloadedIndexKeyRecordCursor(List<Type> types, List<PageAndPositions> pageAndPositions) {
            this.types = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(types, (Object)"types is null")));
            this.pageAndPositionsIterator = ((List)Preconditions.checkNotNull(pageAndPositions, (Object)"pageAndPositions is null")).iterator();
            this.blocks = new Block[types.size()];
        }

        public long getTotalBytes() {
            return 0L;
        }

        public long getCompletedBytes() {
            return 0L;
        }

        public long getReadTimeNanos() {
            return 0L;
        }

        public Type getType(int field) {
            return this.types.get(field);
        }

        public boolean advanceNextPosition() {
            while (this.positionIterator == null || !this.positionIterator.hasNext()) {
                if (!this.pageAndPositionsIterator.hasNext()) {
                    return false;
                }
                PageAndPositions pageAndPositions = this.pageAndPositionsIterator.next();
                this.blocks = pageAndPositions.getUpdateRequest().getBlocks();
                Preconditions.checkState((this.types.size() == this.blocks.length ? 1 : 0) != 0);
                this.positionIterator = pageAndPositions.getPositions().iterator();
            }
            this.position = this.positionIterator.nextInt();
            return true;
        }

        public Block[] getBlocks() {
            return this.blocks;
        }

        public int getPosition() {
            return this.position;
        }

        public boolean getBoolean(int field) {
            return this.types.get(field).getBoolean(this.blocks[field], this.position);
        }

        public long getLong(int field) {
            return this.types.get(field).getLong(this.blocks[field], this.position);
        }

        public double getDouble(int field) {
            return this.types.get(field).getDouble(this.blocks[field], this.position);
        }

        public Slice getSlice(int field) {
            return this.types.get(field).getSlice(this.blocks[field], this.position);
        }

        public boolean isNull(int field) {
            return this.blocks[field].isNull(this.position);
        }

        public void close() {
        }
    }
}

