/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.index;

import com.facebook.presto.operator.LookupSource;
import com.facebook.presto.operator.index.IndexedData;
import com.facebook.presto.spi.PageBuilder;
import com.facebook.presto.spi.block.Block;
import com.google.common.base.Preconditions;
import javax.annotation.concurrent.Immutable;

@Immutable
public class IndexSnapshot
implements IndexedData {
    private final LookupSource values;
    private final LookupSource missingKeys;

    public IndexSnapshot(LookupSource values, LookupSource missingKeys) {
        this.values = (LookupSource)Preconditions.checkNotNull((Object)values, (Object)"values is null");
        this.missingKeys = (LookupSource)Preconditions.checkNotNull((Object)missingKeys, (Object)"missingKeys is null");
    }

    @Override
    public long getJoinPosition(int position, Block ... blocks) {
        long joinPosition = this.values.getJoinPosition(position, blocks);
        if (joinPosition < 0L) {
            if (this.missingKeys.getJoinPosition(position, blocks) < 0L) {
                return -2L;
            }
            return -1L;
        }
        return joinPosition;
    }

    @Override
    public long getNextJoinPosition(long currentPosition) {
        return this.values.getNextJoinPosition(currentPosition);
    }

    @Override
    public void appendTo(long position, PageBuilder pageBuilder, int outputChannelOffset) {
        this.values.appendTo(position, pageBuilder, outputChannelOffset);
    }

    @Override
    public void close() {
    }
}

