/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.index;

import com.facebook.presto.ScheduledSplit;
import com.facebook.presto.TaskSource;
import com.facebook.presto.metadata.Split;
import com.facebook.presto.operator.Driver;
import com.facebook.presto.operator.DriverFactory;
import com.facebook.presto.operator.LookupSource;
import com.facebook.presto.operator.PipelineContext;
import com.facebook.presto.operator.TaskContext;
import com.facebook.presto.operator.index.IndexBuildDriverFactoryProvider;
import com.facebook.presto.operator.index.IndexJoinLookupStats;
import com.facebook.presto.operator.index.IndexSnapshot;
import com.facebook.presto.operator.index.IndexSnapshotBuilder;
import com.facebook.presto.operator.index.IndexSplit;
import com.facebook.presto.operator.index.IndexedData;
import com.facebook.presto.operator.index.PageBuffer;
import com.facebook.presto.operator.index.PageRecordSet;
import com.facebook.presto.operator.index.StreamingIndexedData;
import com.facebook.presto.operator.index.UnloadedIndexKeyRecordSet;
import com.facebook.presto.operator.index.UpdateRequest;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PageBuilder;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.units.DataSize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.NotThreadSafe;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class IndexLoader {
    private final BlockingQueue<UpdateRequest> updateRequests = new LinkedBlockingQueue<UpdateRequest>();
    private final List<Type> outputTypes;
    private final IndexBuildDriverFactoryProvider indexBuildDriverFactoryProvider;
    private final int expectedPositions;
    private final DataSize maxIndexMemorySize;
    private final IndexJoinLookupStats stats;
    private final AtomicReference<TaskContext> taskContextReference = new AtomicReference();
    private final List<Integer> indexChannels;
    private final List<Type> indexTypes;
    @GuardedBy(value="this")
    private IndexSnapshotLoader indexSnapshotLoader;
    @GuardedBy(value="this")
    private PipelineContext pipelineContext;
    @GuardedBy(value="this")
    private final AtomicReference<IndexSnapshot> indexSnapshotReference;

    public IndexLoader(List<Integer> indexChannels, List<Type> types, IndexBuildDriverFactoryProvider indexBuildDriverFactoryProvider, int expectedPositions, DataSize maxIndexMemorySize, IndexJoinLookupStats stats) {
        Preconditions.checkArgument((!indexChannels.isEmpty() ? 1 : 0) != 0, (Object)"indexChannels must not be empty");
        this.indexChannels = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(indexChannels, (Object)"indexChannels is null")));
        this.outputTypes = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(types, (Object)"types is null")));
        this.indexBuildDriverFactoryProvider = (IndexBuildDriverFactoryProvider)Preconditions.checkNotNull((Object)indexBuildDriverFactoryProvider, (Object)"indexBuildDriverFactoryProvider is null");
        this.expectedPositions = (Integer)Preconditions.checkNotNull((Object)expectedPositions, (Object)"expectedPositions is null");
        this.maxIndexMemorySize = (DataSize)Preconditions.checkNotNull((Object)maxIndexMemorySize, (Object)"maxIndexMemorySize is null");
        this.stats = (IndexJoinLookupStats)Preconditions.checkNotNull((Object)stats, (Object)"stats is null");
        ImmutableList.Builder typeBuilder = ImmutableList.builder();
        for (int outputIndexChannel : indexChannels) {
            typeBuilder.add((Object)types.get(outputIndexChannel));
        }
        this.indexTypes = typeBuilder.build();
        this.indexSnapshotReference = new AtomicReference<IndexSnapshot>(new IndexSnapshot(new EmptyLookupSource(types.size()), new EmptyLookupSource(indexChannels.size())));
    }

    public void setContext(TaskContext taskContext) {
        this.taskContextReference.compareAndSet(null, taskContext);
    }

    public int getChannelCount() {
        return this.outputTypes.size();
    }

    public List<Type> getOutputTypes() {
        return this.outputTypes;
    }

    public IndexSnapshot getIndexSnapshot() {
        return this.indexSnapshotReference.get();
    }

    private static Block[] sliceBlocks(Block[] indexBlocks, int startPosition, int length) {
        Block[] slicedIndexBlocks = new Block[indexBlocks.length];
        for (int i = 0; i < indexBlocks.length; ++i) {
            slicedIndexBlocks[i] = indexBlocks[i].getRegion(startPosition, length);
        }
        return slicedIndexBlocks;
    }

    public IndexedData getIndexedDataForKeys(int position, Block[] indexBlocks) {
        int totalPositions = indexBlocks[0].getPositionCount();
        int remainingPositions = totalPositions - position;
        return this.getIndexedDataForKeys(IndexLoader.sliceBlocks(indexBlocks, position, remainingPositions));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IndexedData getIndexedDataForKeys(Block[] indexBlocks) {
        UpdateRequest myUpdateRequest = new UpdateRequest(indexBlocks);
        this.updateRequests.add(myUpdateRequest);
        IndexLoader indexLoader = this;
        synchronized (indexLoader) {
            if (!myUpdateRequest.isFinished()) {
                this.stats.recordIndexJoinLookup();
                this.initializeStateIfNecessary();
                ArrayList<UpdateRequest> requests = new ArrayList<UpdateRequest>();
                this.updateRequests.drainTo(requests);
                long initialCacheSizeInBytes = this.indexSnapshotLoader.getCacheSizeInBytes();
                if (this.indexSnapshotLoader.load(requests)) {
                    return myUpdateRequest.getFinishedIndexSnapshot();
                }
                if (initialCacheSizeInBytes > 0L && this.indexSnapshotLoader.load(requests)) {
                    this.stats.recordSuccessfulIndexJoinLookupByCacheReset();
                    return myUpdateRequest.getFinishedIndexSnapshot();
                }
                if (requests.size() > 1) {
                    Iterables.addAll(this.updateRequests, (Iterable)Iterables.filter(requests, (Predicate)Predicates.not((Predicate)Predicates.equalTo((Object)myUpdateRequest))));
                    if (this.indexSnapshotLoader.load((List<UpdateRequest>)ImmutableList.of((Object)myUpdateRequest))) {
                        this.stats.recordSuccessfulIndexJoinLookupBySingleRequest();
                        return myUpdateRequest.getFinishedIndexSnapshot();
                    }
                }
                int totalPositions = indexBlocks[0].getPositionCount();
                for (int attemptedPositions = totalPositions / 10; attemptedPositions > 1; attemptedPositions /= 10) {
                    myUpdateRequest = new UpdateRequest(IndexLoader.sliceBlocks(indexBlocks, 0, attemptedPositions));
                    if (!this.indexSnapshotLoader.load((List<UpdateRequest>)ImmutableList.of((Object)myUpdateRequest))) continue;
                    this.stats.recordSuccessfulIndexJoinLookupByLimitedRequest();
                    return myUpdateRequest.getFinishedIndexSnapshot();
                }
                this.stats.recordStreamedIndexJoinLookup();
                return this.streamIndexDataForSingleKey(myUpdateRequest);
            }
        }
        return myUpdateRequest.getFinishedIndexSnapshot();
    }

    public IndexedData streamIndexDataForSingleKey(UpdateRequest updateRequest) {
        PageBuffer pageBuffer = new PageBuffer(100);
        DriverFactory driverFactory = this.indexBuildDriverFactoryProvider.create(pageBuffer);
        Driver driver = driverFactory.createDriver(this.pipelineContext.addDriverContext());
        Page indedKeyTuple = new Page(IndexLoader.sliceBlocks(updateRequest.getBlocks(), 0, 1));
        PageRecordSet pageRecordSet = new PageRecordSet(this.indexTypes, indedKeyTuple);
        PlanNodeId planNodeId = (PlanNodeId)Iterables.getOnlyElement(driverFactory.getSourceIds());
        driver.updateSource(new TaskSource(planNodeId, (Set<ScheduledSplit>)ImmutableSet.of((Object)new ScheduledSplit(0L, new Split("index", new IndexSplit(pageRecordSet)))), true));
        return new StreamingIndexedData(this.outputTypes, this.indexTypes, indedKeyTuple, pageBuffer, driver);
    }

    private synchronized void initializeStateIfNecessary() {
        if (this.pipelineContext == null) {
            TaskContext taskContext = this.taskContextReference.get();
            Preconditions.checkState((taskContext != null ? 1 : 0) != 0, (Object)"Task context must be set before index can be built");
            this.pipelineContext = taskContext.addPipelineContext(false, false);
        }
        if (this.indexSnapshotLoader == null) {
            this.indexSnapshotLoader = new IndexSnapshotLoader(this.indexBuildDriverFactoryProvider, this.pipelineContext, this.indexSnapshotReference, this.indexTypes, this.indexChannels, this.expectedPositions, this.maxIndexMemorySize);
        }
    }

    private static class EmptyLookupSource
    implements LookupSource {
        private final int channelCount;

        public EmptyLookupSource(int channelCount) {
            this.channelCount = channelCount;
        }

        @Override
        public int getChannelCount() {
            return this.channelCount;
        }

        @Override
        public long getJoinPosition(int position, Block ... blocks) {
            return -2L;
        }

        @Override
        public long getNextJoinPosition(long currentPosition) {
            return -2L;
        }

        @Override
        public void appendTo(long position, PageBuilder pageBuilder, int outputChannelOffset) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void close() {
        }
    }

    @NotThreadSafe
    private static class IndexSnapshotLoader {
        private final DriverFactory driverFactory;
        private final PipelineContext pipelineContext;
        private final List<Type> types;
        private final List<Type> indexTypes;
        private final AtomicReference<IndexSnapshot> indexSnapshotReference;
        private final IndexSnapshotBuilder indexSnapshotBuilder;

        private IndexSnapshotLoader(IndexBuildDriverFactoryProvider indexBuildDriverFactoryProvider, PipelineContext pipelineContext, AtomicReference<IndexSnapshot> indexSnapshotReference, List<Type> indexTypes, List<Integer> indexChannels, int expectedPositions, DataSize maxIndexMemorySize) {
            this.pipelineContext = pipelineContext;
            this.indexSnapshotReference = indexSnapshotReference;
            this.types = indexBuildDriverFactoryProvider.getOutputTypes();
            this.indexTypes = indexTypes;
            this.indexSnapshotBuilder = new IndexSnapshotBuilder(this.types, indexChannels, pipelineContext.addDriverContext(), maxIndexMemorySize, expectedPositions);
            this.driverFactory = indexBuildDriverFactoryProvider.create(this.indexSnapshotBuilder);
        }

        public long getCacheSizeInBytes() {
            return this.indexSnapshotBuilder.getMemoryInBytes();
        }

        public boolean load(List<UpdateRequest> requests) {
            UnloadedIndexKeyRecordSet unloadedKeysRecordSet = new UnloadedIndexKeyRecordSet(this.indexSnapshotReference.get(), this.indexTypes, requests);
            Driver driver = this.driverFactory.createDriver(this.pipelineContext.addDriverContext());
            PlanNodeId sourcePlanNodeId = (PlanNodeId)Iterables.getOnlyElement(this.driverFactory.getSourceIds());
            driver.updateSource(new TaskSource(sourcePlanNodeId, (Set<ScheduledSplit>)ImmutableSet.of((Object)new ScheduledSplit(0L, new Split("index", new IndexSplit(unloadedKeysRecordSet)))), true));
            while (!driver.isFinished()) {
                ListenableFuture<?> process = driver.process();
                Preconditions.checkState((boolean)process.isDone(), (Object)"Driver should never block");
            }
            if (this.indexSnapshotBuilder.isMemoryExceeded()) {
                this.clearCachedData();
                return false;
            }
            IndexSnapshot newValue = this.indexSnapshotBuilder.createIndexSnapshot(unloadedKeysRecordSet);
            if (newValue == null) {
                this.clearCachedData();
                return false;
            }
            this.indexSnapshotReference.set(newValue);
            for (UpdateRequest request : requests) {
                request.finished(newValue);
            }
            return true;
        }

        private void clearCachedData() {
            this.indexSnapshotReference.set(new IndexSnapshot(new EmptyLookupSource(this.types.size()), new EmptyLookupSource(this.indexTypes.size())));
            this.indexSnapshotBuilder.reset();
        }
    }
}

