/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.index;

import com.facebook.presto.operator.DriverFactory;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.index.IndexSnapshotBuilder;
import com.facebook.presto.operator.index.PageBuffer;
import com.facebook.presto.operator.index.PageBufferOperator;
import com.facebook.presto.operator.index.PagesIndexBuilderOperator;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;

public class IndexBuildDriverFactoryProvider {
    private final int outputOperatorId;
    private final boolean inputDriver;
    private final List<OperatorFactory> coreOperatorFactories;
    private final List<Type> outputTypes;

    public IndexBuildDriverFactoryProvider(int outputOperatorId, boolean inputDriver, List<OperatorFactory> coreOperatorFactories) {
        this.outputOperatorId = outputOperatorId;
        this.inputDriver = inputDriver;
        Preconditions.checkNotNull(coreOperatorFactories, (Object)"coreOperatorFactories is null");
        Preconditions.checkArgument((!coreOperatorFactories.isEmpty() ? 1 : 0) != 0, (Object)"coreOperatorFactories is empty");
        this.coreOperatorFactories = ImmutableList.copyOf(coreOperatorFactories);
        this.outputTypes = ImmutableList.copyOf(this.coreOperatorFactories.get(this.coreOperatorFactories.size() - 1).getTypes());
    }

    public List<Type> getOutputTypes() {
        return this.outputTypes;
    }

    public DriverFactory create(IndexSnapshotBuilder indexSnapshotBuilder) {
        Preconditions.checkArgument((boolean)indexSnapshotBuilder.getOutputTypes().equals(this.outputTypes));
        return new DriverFactory(this.inputDriver, false, (List<OperatorFactory>)ImmutableList.builder().addAll(this.coreOperatorFactories).add((Object)new PagesIndexBuilderOperator.PagesIndexBuilderOperatorFactory(this.outputOperatorId, indexSnapshotBuilder)).build());
    }

    public DriverFactory create(PageBuffer pageBuffer) {
        return new DriverFactory(this.inputDriver, false, (List<OperatorFactory>)ImmutableList.builder().addAll(this.coreOperatorFactories).add((Object)new PageBufferOperator.PageBufferOperatorFactory(this.outputOperatorId, pageBuffer)).build());
    }
}

