/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.operator.aggregation.AggregationFunction;
import com.facebook.presto.operator.aggregation.InputFunction;
import com.facebook.presto.operator.aggregation.IntermediateInputFunction;
import com.facebook.presto.operator.aggregation.state.InitialLongValue;
import com.facebook.presto.operator.aggregation.state.NullableBigintState;
import com.facebook.presto.type.SqlType;

@AggregationFunction(value="min")
public final class LongMinAggregation {
    private LongMinAggregation() {
    }

    @InputFunction
    @IntermediateInputFunction
    public static void min(BigintMinState state, @SqlType(value="bigint") long value) {
        state.setNull(false);
        state.setLong(Math.min(state.getLong(), value));
    }

    public static interface BigintMinState
    extends NullableBigintState {
        @Override
        @InitialLongValue(value=0x7FFFFFFFFFFFFFFFL)
        public long getLong();
    }
}

