/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.operator.aggregation.AccumulatorFactory;
import com.facebook.presto.operator.aggregation.GenericAccumulatorFactoryBinder;
import com.facebook.presto.operator.aggregation.InternalAggregationFunction;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;

public final class GenericAggregationFunction
implements InternalAggregationFunction {
    private final String name;
    private final List<Type> parameterTypes;
    private final Type intermediateType;
    private final Type finalType;
    private final boolean decomposable;
    private final boolean approximate;
    private final GenericAccumulatorFactoryBinder factory;

    public GenericAggregationFunction(String name, List<Type> parameterTypes, Type intermediateType, Type finalType, boolean decomposable, boolean approximate, GenericAccumulatorFactoryBinder factory) {
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name is null");
        Preconditions.checkArgument((!name.isEmpty() ? 1 : 0) != 0, (Object)"name is empty");
        this.parameterTypes = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(parameterTypes, (Object)"parameterTypes is null")));
        this.intermediateType = (Type)Preconditions.checkNotNull((Object)intermediateType, (Object)"intermediateType is null");
        this.finalType = (Type)Preconditions.checkNotNull((Object)finalType, (Object)"finalType is null");
        this.decomposable = decomposable;
        this.approximate = approximate;
        this.factory = (GenericAccumulatorFactoryBinder)Preconditions.checkNotNull((Object)factory, (Object)"factory is null");
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public List<Type> getParameterTypes() {
        return this.parameterTypes;
    }

    @Override
    public Type getFinalType() {
        return this.finalType;
    }

    @Override
    public Type getIntermediateType() {
        return this.intermediateType;
    }

    @Override
    public boolean isDecomposable() {
        return this.decomposable;
    }

    @Override
    public boolean isApproximate() {
        return this.approximate;
    }

    @Override
    public AccumulatorFactory bind(List<Integer> inputChannels, Optional<Integer> maskChannel, Optional<Integer> sampleWeightChannel, double confidence) {
        return this.factory.bind(inputChannels, maskChannel, sampleWeightChannel, confidence);
    }
}

