/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.operator.aggregation.AggregationFunction;
import com.facebook.presto.operator.aggregation.AggregationUtils;
import com.facebook.presto.operator.aggregation.ApproximateUtils;
import com.facebook.presto.operator.aggregation.CombineFunction;
import com.facebook.presto.operator.aggregation.InputFunction;
import com.facebook.presto.operator.aggregation.OutputFunction;
import com.facebook.presto.operator.aggregation.SampleWeight;
import com.facebook.presto.operator.aggregation.state.VarianceState;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.type.SqlType;
import io.airlift.slice.Slices;

@AggregationFunction(value="sum", approximate=true)
public final class ApproximateSumAggregations {
    private ApproximateSumAggregations() {
    }

    @InputFunction
    public static void input(ApproximateDoubleSumState state, @SqlType(value="double") double value, @SampleWeight long sampleWeight) {
        state.setWeightedCount(state.getWeightedCount() + sampleWeight);
        state.setSum(state.getSum() + value * (double)sampleWeight);
        AggregationUtils.updateVarianceState(state, value);
    }

    @CombineFunction
    public static void combine(ApproximateDoubleSumState state, ApproximateDoubleSumState otherState) {
        state.setSum(state.getSum() + otherState.getSum());
        state.setWeightedCount(state.getWeightedCount() + otherState.getWeightedCount());
        AggregationUtils.mergeVarianceState(state, otherState);
    }

    @OutputFunction(value="varchar")
    public static void output(ApproximateDoubleSumState state, double confidence, BlockBuilder out) {
        if (state.getWeightedCount() == 0L) {
            out.appendNull();
            return;
        }
        String result = ApproximateUtils.formatApproximateResult(state.getSum(), ApproximateUtils.sumError(state.getCount(), state.getWeightedCount(), state.getM2(), state.getMean()), confidence, false);
        VarcharType.VARCHAR.writeSlice(out, Slices.utf8Slice((String)result));
    }

    @InputFunction
    public static void input(ApproximateLongSumState state, @SqlType(value="bigint") long value, @SampleWeight long sampleWeight) {
        state.setWeightedCount(state.getWeightedCount() + sampleWeight);
        state.setSum(state.getSum() + value * sampleWeight);
        AggregationUtils.updateVarianceState(state, value);
    }

    @CombineFunction
    public static void combine(ApproximateLongSumState state, ApproximateLongSumState otherState) {
        state.setSum(state.getSum() + otherState.getSum());
        state.setWeightedCount(state.getWeightedCount() + otherState.getWeightedCount());
        AggregationUtils.mergeVarianceState(state, otherState);
    }

    @OutputFunction(value="varchar")
    public static void evaluateFinal(ApproximateLongSumState state, double confidence, BlockBuilder out) {
        if (state.getWeightedCount() == 0L) {
            out.appendNull();
            return;
        }
        String result = ApproximateUtils.formatApproximateResult(state.getSum(), ApproximateUtils.sumError(state.getCount(), state.getWeightedCount(), state.getM2(), state.getMean()), confidence, true);
        VarcharType.VARCHAR.writeSlice(out, Slices.utf8Slice((String)result));
    }

    public static interface ApproximateLongSumState
    extends VarianceState {
        public long getSum();

        public void setSum(long var1);

        public long getWeightedCount();

        public void setWeightedCount(long var1);
    }

    public static interface ApproximateDoubleSumState
    extends VarianceState {
        public double getSum();

        public void setSum(double var1);

        public long getWeightedCount();

        public void setWeightedCount(long var1);
    }
}

