/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.operator.aggregation.AggregationCompiler;
import com.facebook.presto.operator.aggregation.AggregationFunction;
import com.facebook.presto.operator.aggregation.CombineFunction;
import com.facebook.presto.operator.aggregation.HyperLogLog;
import com.facebook.presto.operator.aggregation.InputFunction;
import com.facebook.presto.operator.aggregation.InternalAggregationFunction;
import com.facebook.presto.operator.aggregation.OutputFunction;
import com.facebook.presto.operator.aggregation.state.SliceState;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.type.SqlType;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Murmur3;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.util.List;

@AggregationFunction(value="approx_distinct")
public final class ApproximateCountDistinctAggregations {
    public static final InternalAggregationFunction LONG_APPROXIMATE_COUNT_DISTINCT_AGGREGATIONS = new AggregationCompiler().generateAggregationFunction(ApproximateCountDistinctAggregations.class, (Type)BigintType.BIGINT, (List<Type>)ImmutableList.of((Object)BigintType.BIGINT));
    public static final InternalAggregationFunction DOUBLE_APPROXIMATE_COUNT_DISTINCT_AGGREGATIONS = new AggregationCompiler().generateAggregationFunction(ApproximateCountDistinctAggregations.class, (Type)BigintType.BIGINT, (List<Type>)ImmutableList.of((Object)DoubleType.DOUBLE));
    public static final InternalAggregationFunction VARBINARY_APPROXIMATE_COUNT_DISTINCT_AGGREGATIONS = new AggregationCompiler().generateAggregationFunction(ApproximateCountDistinctAggregations.class, (Type)BigintType.BIGINT, (List<Type>)ImmutableList.of((Object)VarcharType.VARCHAR));
    private static final HyperLogLog ESTIMATOR = new HyperLogLog(2048);

    private ApproximateCountDistinctAggregations() {
    }

    @InputFunction
    public static void input(SliceState state, @SqlType(value="varchar") Slice value) {
        ApproximateCountDistinctAggregations.update(state, Murmur3.hash64((Slice)value));
    }

    @InputFunction
    public static void input(SliceState state, @SqlType(value="double") double value) {
        ApproximateCountDistinctAggregations.update(state, Murmur3.hash64((long)Double.doubleToLongBits(value)));
    }

    @InputFunction
    public static void input(SliceState state, @SqlType(value="bigint") long value) {
        ApproximateCountDistinctAggregations.update(state, Murmur3.hash64((long)value));
    }

    private static void update(SliceState state, long hash) {
        if (state.getSlice() == null) {
            state.setSlice(Slices.allocate((int)ESTIMATOR.getSizeInBytes()));
        }
        ESTIMATOR.update(hash, state.getSlice(), 0);
    }

    @CombineFunction
    public static void combine(SliceState state, SliceState otherState) {
        if (state.getSlice() == null) {
            state.setSlice(otherState.getSlice());
        } else {
            ESTIMATOR.mergeInto(state.getSlice(), 0, otherState.getSlice(), 0);
        }
    }

    @OutputFunction(value="bigint")
    public static void output(SliceState state, BlockBuilder out) {
        if (state.getSlice() != null) {
            BigintType.BIGINT.writeLong(out, ESTIMATOR.estimate(state.getSlice(), 0));
        } else {
            BigintType.BIGINT.writeLong(out, 0L);
        }
    }

    @VisibleForTesting
    public static double getStandardError() {
        return ESTIMATOR.getStandardError();
    }
}

