/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.operator.aggregation.OutputFunction;
import com.facebook.presto.operator.aggregation.state.AccumulatorStateSerializer;
import com.facebook.presto.operator.aggregation.state.VarianceState;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.google.common.base.CaseFormat;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.lang.reflect.Method;
import java.util.List;
import javax.annotation.Nullable;

public final class AggregationUtils {
    private AggregationUtils() {
    }

    public static void updateVarianceState(VarianceState state, double value) {
        state.setCount(state.getCount() + 1L);
        double delta = value - state.getMean();
        state.setMean(state.getMean() + delta / (double)state.getCount());
        state.setM2(state.getM2() + delta * (value - state.getMean()));
    }

    public static void mergeVarianceState(VarianceState state, VarianceState otherState) {
        long count = otherState.getCount();
        double mean = otherState.getMean();
        double m2 = otherState.getM2();
        Preconditions.checkArgument((count >= 0L ? 1 : 0) != 0, (Object)"count is negative");
        if (count == 0L) {
            return;
        }
        long newCount = count + state.getCount();
        double newMean = ((double)count * mean + (double)state.getCount() * state.getMean()) / (double)newCount;
        double delta = mean - state.getMean();
        double m2Delta = m2 + delta * delta * (double)count * (double)state.getCount() / (double)newCount;
        state.setM2(state.getM2() + m2Delta);
        state.setCount(newCount);
        state.setMean(newMean);
    }

    public static Type getOutputType(@Nullable Method outputFunction, AccumulatorStateSerializer<?> serializer, TypeManager typeManager) {
        if (outputFunction == null) {
            return serializer.getSerializedType();
        }
        return typeManager.getType(outputFunction.getAnnotation(OutputFunction.class).value());
    }

    public static String generateAggregationName(String baseName, Type outputType, List<Type> inputTypes) {
        StringBuilder sb = new StringBuilder();
        sb.append(CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, outputType.getName()));
        for (Type inputType : inputTypes) {
            sb.append(CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, inputType.getName()));
        }
        sb.append(CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, baseName.toLowerCase()));
        return sb.toString();
    }

    public static Function<Integer, Block> pageBlockGetter(final Page page) {
        return new Function<Integer, Block>(){

            public Block apply(Integer input) {
                return page.getBlock(input.intValue());
            }
        };
    }
}

