/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.ChannelSet;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class SetBuilderOperator
implements Operator {
    private final OperatorContext operatorContext;
    private final SetSupplier setSupplier;
    private final int setChannel;
    private final ChannelSet.ChannelSetBuilder channelSetBuilder;
    private boolean finished;

    public SetBuilderOperator(OperatorContext operatorContext, SetSupplier setSupplier, int setChannel, int expectedPositions) {
        this.operatorContext = (OperatorContext)Preconditions.checkNotNull((Object)operatorContext, (Object)"operatorContext is null");
        this.setSupplier = (SetSupplier)Preconditions.checkNotNull((Object)setSupplier, (Object)"setProvider is null");
        this.setChannel = setChannel;
        this.channelSetBuilder = new ChannelSet.ChannelSetBuilder(setSupplier.getType(), expectedPositions, (OperatorContext)Preconditions.checkNotNull((Object)operatorContext, (Object)"operatorContext is null"));
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public List<Type> getTypes() {
        return ImmutableList.of();
    }

    @Override
    public void finish() {
        if (this.finished) {
            return;
        }
        ChannelSet channelSet = this.channelSetBuilder.build();
        this.setSupplier.setChannelSet(channelSet);
        this.operatorContext.recordGeneratedOutput(channelSet.getEstimatedSizeInBytes(), channelSet.size());
        this.finished = true;
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        return NOT_BLOCKED;
    }

    @Override
    public boolean needsInput() {
        return !this.finished;
    }

    @Override
    public void addInput(Page page) {
        Preconditions.checkNotNull((Object)page, (Object)"page is null");
        Preconditions.checkState((!this.isFinished() ? 1 : 0) != 0, (Object)"Operator is already finished");
        Block sourceBlock = page.getBlock(this.setChannel);
        this.channelSetBuilder.addBlock(sourceBlock);
    }

    @Override
    public Page getOutput() {
        return null;
    }

    public static class SetBuilderOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final SetSupplier setProvider;
        private final int setChannel;
        private final int expectedPositions;
        private boolean closed;

        public SetBuilderOperatorFactory(int operatorId, List<Type> types, int setChannel, int expectedPositions) {
            this.operatorId = operatorId;
            Preconditions.checkArgument((setChannel >= 0 ? 1 : 0) != 0, (Object)"setChannel is negative");
            this.setProvider = new SetSupplier((Type)((List)Preconditions.checkNotNull(types, (Object)"types is null")).get(setChannel));
            this.setChannel = setChannel;
            this.expectedPositions = (Integer)Preconditions.checkNotNull((Object)expectedPositions, (Object)"expectedPositions is null");
        }

        public SetSupplier getSetProvider() {
            return this.setProvider;
        }

        @Override
        public List<Type> getTypes() {
            return ImmutableList.of();
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, SetBuilderOperator.class.getSimpleName());
            return new SetBuilderOperator(operatorContext, this.setProvider, this.setChannel, this.expectedPositions);
        }

        @Override
        public void close() {
            this.closed = true;
        }
    }

    public static class SetSupplier {
        private final Type type;
        private final SettableFuture<ChannelSet> channelSetFuture = SettableFuture.create();

        public SetSupplier(Type type) {
            this.type = (Type)Preconditions.checkNotNull((Object)type, (Object)"type is null");
        }

        public Type getType() {
            return this.type;
        }

        public ListenableFuture<ChannelSet> getChannelSet() {
            return this.channelSetFuture;
        }

        void setChannelSet(ChannelSet channelSet) {
            boolean wasSet = this.channelSetFuture.set(Preconditions.checkNotNull((Object)channelSet, (Object)"channelSet is null"));
            Preconditions.checkState((boolean)wasSet, (Object)"ChannelSet already set");
        }
    }
}

