/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.Session;
import com.facebook.presto.execution.TaskId;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.DriverStats;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OperatorStats;
import com.facebook.presto.operator.PipelineStats;
import com.facebook.presto.operator.TaskContext;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.airlift.stats.CounterStat;
import io.airlift.stats.Distribution;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class PipelineContext {
    private final TaskContext taskContext;
    private final Executor executor;
    private final boolean inputPipeline;
    private final boolean outputPipeline;
    private final List<DriverContext> drivers = new CopyOnWriteArrayList<DriverContext>();
    private final AtomicInteger completedDrivers = new AtomicInteger();
    private final AtomicLong memoryReservation = new AtomicLong();
    private final Distribution queuedTime = new Distribution();
    private final Distribution elapsedTime = new Distribution();
    private final AtomicLong totalScheduledTime = new AtomicLong();
    private final AtomicLong totalCpuTime = new AtomicLong();
    private final AtomicLong totalUserTime = new AtomicLong();
    private final AtomicLong totalBlockedTime = new AtomicLong();
    private final CounterStat rawInputDataSize = new CounterStat();
    private final CounterStat rawInputPositions = new CounterStat();
    private final CounterStat processedInputDataSize = new CounterStat();
    private final CounterStat processedInputPositions = new CounterStat();
    private final CounterStat outputDataSize = new CounterStat();
    private final CounterStat outputPositions = new CounterStat();
    private final ConcurrentMap<Integer, OperatorStats> operatorSummaries = new ConcurrentHashMap<Integer, OperatorStats>();

    public PipelineContext(TaskContext taskContext, Executor executor, boolean inputPipeline, boolean outputPipeline) {
        this.inputPipeline = inputPipeline;
        this.outputPipeline = outputPipeline;
        this.taskContext = (TaskContext)Preconditions.checkNotNull((Object)taskContext, (Object)"taskContext is null");
        this.executor = (Executor)Preconditions.checkNotNull((Object)executor, (Object)"executor is null");
    }

    public TaskContext getTaskContext() {
        return this.taskContext;
    }

    public TaskId getTaskId() {
        return this.taskContext.getTaskId();
    }

    public boolean isInputPipeline() {
        return this.inputPipeline;
    }

    public boolean isOutputPipeline() {
        return this.outputPipeline;
    }

    public DriverContext addDriverContext() {
        return this.addDriverContext(false);
    }

    public DriverContext addDriverContext(boolean partitioned) {
        DriverContext driverContext = new DriverContext(this, this.executor, partitioned);
        this.drivers.add(driverContext);
        return driverContext;
    }

    public List<DriverContext> getDrivers() {
        return ImmutableList.copyOf(this.drivers);
    }

    public Session getSession() {
        return this.taskContext.getSession();
    }

    public void driverFinished(DriverContext driverContext) {
        Preconditions.checkNotNull((Object)driverContext, (Object)"driverContext is null");
        if (!this.drivers.remove(driverContext)) {
            throw new IllegalArgumentException("Unknown driver " + driverContext);
        }
        DriverStats driverStats = driverContext.getDriverStats();
        this.completedDrivers.getAndIncrement();
        this.freeMemory(driverStats.getMemoryReservation().toBytes());
        this.queuedTime.add(driverStats.getQueuedTime().roundTo(TimeUnit.NANOSECONDS));
        this.elapsedTime.add(driverStats.getElapsedTime().roundTo(TimeUnit.NANOSECONDS));
        this.totalScheduledTime.getAndAdd(driverStats.getTotalScheduledTime().roundTo(TimeUnit.NANOSECONDS));
        this.totalCpuTime.getAndAdd(driverStats.getTotalCpuTime().roundTo(TimeUnit.NANOSECONDS));
        this.totalUserTime.getAndAdd(driverStats.getTotalUserTime().roundTo(TimeUnit.NANOSECONDS));
        this.totalBlockedTime.getAndAdd(driverStats.getTotalBlockedTime().roundTo(TimeUnit.NANOSECONDS));
        List<OperatorStats> operators = driverStats.getOperatorStats();
        for (OperatorStats operator : operators) {
            OperatorStats updated;
            OperatorStats current;
            do {
                updated = (current = (OperatorStats)this.operatorSummaries.get(operator.getOperatorId())) != null ? current.add(operator) : operator;
            } while (!PipelineContext.compareAndSet(this.operatorSummaries, operator.getOperatorId(), current, updated));
        }
        this.rawInputDataSize.update(driverStats.getRawInputDataSize().toBytes());
        this.rawInputPositions.update(driverStats.getRawInputPositions());
        this.processedInputDataSize.update(driverStats.getProcessedInputDataSize().toBytes());
        this.processedInputPositions.update(driverStats.getProcessedInputPositions());
        this.outputDataSize.update(driverStats.getOutputDataSize().toBytes());
        this.outputPositions.update(driverStats.getOutputPositions());
    }

    public void start() {
        this.taskContext.start();
    }

    public void failed(Throwable cause) {
        this.taskContext.failed(cause);
    }

    public boolean isDone() {
        return this.taskContext.isDone();
    }

    public DataSize getMaxMemorySize() {
        return this.taskContext.getMaxMemorySize();
    }

    public DataSize getOperatorPreAllocatedMemory() {
        return this.taskContext.getOperatorPreAllocatedMemory();
    }

    public synchronized boolean reserveMemory(long bytes) {
        boolean result = this.taskContext.reserveMemory(bytes);
        if (result) {
            this.memoryReservation.getAndAdd(bytes);
        }
        return result;
    }

    public synchronized void freeMemory(long bytes) {
        Preconditions.checkArgument((bytes <= this.memoryReservation.get() ? 1 : 0) != 0, (Object)"tried to free more memory than is reserved");
        this.taskContext.freeMemory(bytes);
        this.memoryReservation.getAndAdd(-bytes);
    }

    public boolean isCpuTimerEnabled() {
        return this.taskContext.isCpuTimerEnabled();
    }

    public CounterStat getInputDataSize() {
        CounterStat stat = new CounterStat();
        stat.merge(this.rawInputDataSize);
        for (DriverContext driver : this.drivers) {
            stat.merge(driver.getInputDataSize());
        }
        return stat;
    }

    public CounterStat getInputPositions() {
        CounterStat stat = new CounterStat();
        stat.merge(this.rawInputPositions);
        for (DriverContext driver : this.drivers) {
            stat.merge(driver.getInputPositions());
        }
        return stat;
    }

    public CounterStat getOutputDataSize() {
        CounterStat stat = new CounterStat();
        stat.merge(this.outputDataSize);
        for (DriverContext driver : this.drivers) {
            stat.merge(driver.getOutputDataSize());
        }
        return stat;
    }

    public CounterStat getOutputPositions() {
        CounterStat stat = new CounterStat();
        stat.merge(this.outputPositions);
        for (DriverContext driver : this.drivers) {
            stat.merge(driver.getOutputPositions());
        }
        return stat;
    }

    public PipelineStats getPipelineStats() {
        ImmutableList driverContexts = ImmutableList.copyOf(this.drivers);
        int totalDriers = this.completedDrivers.get() + driverContexts.size();
        int queuedDrivers = 0;
        int queuedPartitionedDrivers = 0;
        int runningDrivers = 0;
        int runningPartitionedDrivers = 0;
        int completedDrivers = this.completedDrivers.get();
        Distribution queuedTime = new Distribution(this.queuedTime);
        Distribution elapsedTime = new Distribution(this.elapsedTime);
        long totalScheduledTime = this.totalScheduledTime.get();
        long totalCpuTime = this.totalCpuTime.get();
        long totalUserTime = this.totalUserTime.get();
        long totalBlockedTime = this.totalBlockedTime.get();
        long rawInputDataSize = this.rawInputDataSize.getTotalCount();
        long rawInputPositions = this.rawInputPositions.getTotalCount();
        long processedInputDataSize = this.processedInputDataSize.getTotalCount();
        long processedInputPositions = this.processedInputPositions.getTotalCount();
        long outputDataSize = this.outputDataSize.getTotalCount();
        long outputPositions = this.outputPositions.getTotalCount();
        ArrayList<DriverStats> drivers = new ArrayList<DriverStats>();
        ArrayListMultimap runningOperators = ArrayListMultimap.create();
        for (DriverContext driverContext : driverContexts) {
            DriverStats driverStats = driverContext.getDriverStats();
            drivers.add(driverStats);
            if (driverStats.getStartTime() == null) {
                ++queuedDrivers;
                if (driverContext.isPartitioned()) {
                    ++queuedPartitionedDrivers;
                }
            } else {
                ++runningDrivers;
                if (driverContext.isPartitioned()) {
                    ++runningPartitionedDrivers;
                }
            }
            queuedTime.add(driverStats.getQueuedTime().roundTo(TimeUnit.NANOSECONDS));
            elapsedTime.add(driverStats.getElapsedTime().roundTo(TimeUnit.NANOSECONDS));
            totalScheduledTime += driverStats.getTotalScheduledTime().roundTo(TimeUnit.NANOSECONDS);
            totalCpuTime += driverStats.getTotalCpuTime().roundTo(TimeUnit.NANOSECONDS);
            totalUserTime += driverStats.getTotalUserTime().roundTo(TimeUnit.NANOSECONDS);
            totalBlockedTime += driverStats.getTotalBlockedTime().roundTo(TimeUnit.NANOSECONDS);
            ImmutableList operators = ImmutableList.copyOf((Iterable)Iterables.transform(driverContext.getOperatorContexts(), OperatorContext.operatorStatsGetter()));
            for (OperatorStats operator : operators) {
                runningOperators.put((Object)operator.getOperatorId(), (Object)operator);
            }
            rawInputDataSize += driverStats.getRawInputDataSize().toBytes();
            rawInputPositions += driverStats.getRawInputPositions();
            processedInputDataSize += driverStats.getProcessedInputDataSize().toBytes();
            processedInputPositions += driverStats.getProcessedInputPositions();
            outputDataSize += driverStats.getOutputDataSize().toBytes();
            outputPositions += driverStats.getOutputPositions();
        }
        TreeMap operatorSummaries = new TreeMap();
        for (Map.Entry entry : this.operatorSummaries.entrySet()) {
            OperatorStats operator = (OperatorStats)entry.getValue();
            operator.add(runningOperators.get(entry.getKey()));
            operatorSummaries.put(entry.getKey(), operator);
        }
        return new PipelineStats(this.inputPipeline, this.outputPipeline, totalDriers, queuedDrivers, queuedPartitionedDrivers, runningDrivers, runningPartitionedDrivers, completedDrivers, new DataSize((double)this.memoryReservation.get(), DataSize.Unit.BYTE).convertToMostSuccinctDataSize(), queuedTime.snapshot(), elapsedTime.snapshot(), new Duration((double)totalScheduledTime, TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit(), new Duration((double)totalCpuTime, TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit(), new Duration((double)totalUserTime, TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit(), new Duration((double)totalBlockedTime, TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit(), new DataSize((double)rawInputDataSize, DataSize.Unit.BYTE).convertToMostSuccinctDataSize(), rawInputPositions, new DataSize((double)processedInputDataSize, DataSize.Unit.BYTE).convertToMostSuccinctDataSize(), processedInputPositions, new DataSize((double)outputDataSize, DataSize.Unit.BYTE).convertToMostSuccinctDataSize(), outputPositions, (List<OperatorStats>)ImmutableList.copyOf(operatorSummaries.values()), drivers);
    }

    public static Function<PipelineContext, PipelineStats> pipelineStatsGetter() {
        return new Function<PipelineContext, PipelineStats>(){

            public PipelineStats apply(PipelineContext pipelineContext) {
                return pipelineContext.getPipelineStats();
            }
        };
    }

    private static <K, V> boolean compareAndSet(ConcurrentMap<K, V> map, K key, V oldValue, V newValue) {
        if (oldValue == null) {
            return map.putIfAbsent(key, newValue) == null;
        }
        return map.replace(key, oldValue, newValue);
    }
}

