/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.ScheduledSplit;
import com.facebook.presto.TaskSource;
import com.facebook.presto.metadata.Split;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.SourceOperator;
import com.facebook.presto.spi.Page;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.log.Logger;
import io.airlift.units.Duration;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.concurrent.GuardedBy;

public class Driver {
    private static final Logger log = Logger.get(Driver.class);
    private final DriverContext driverContext;
    private final List<Operator> operators;
    private final Map<PlanNodeId, SourceOperator> sourceOperators;
    private final ConcurrentMap<PlanNodeId, TaskSource> newSources = new ConcurrentHashMap<PlanNodeId, TaskSource>();
    private final AtomicReference<State> state = new AtomicReference<State>(State.ALIVE);
    private final ReentrantLock exclusiveLock = new ReentrantLock();
    @GuardedBy(value="this")
    private Thread lockHolder;
    @GuardedBy(value="exclusiveLock")
    private Map<PlanNodeId, TaskSource> currentSources = new ConcurrentHashMap<PlanNodeId, TaskSource>();

    public Driver(DriverContext driverContext, Operator firstOperator, Operator ... otherOperators) {
        this((DriverContext)Preconditions.checkNotNull((Object)driverContext, (Object)"driverContext is null"), (List<Operator>)ImmutableList.builder().add(Preconditions.checkNotNull((Object)firstOperator, (Object)"firstOperator is null")).add((Object[])Preconditions.checkNotNull((Object)otherOperators, (Object)"otherOperators is null")).build());
    }

    public Driver(DriverContext driverContext, List<Operator> operators) {
        this.driverContext = (DriverContext)Preconditions.checkNotNull((Object)driverContext, (Object)"driverContext is null");
        this.operators = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(operators, (Object)"operators is null")));
        Preconditions.checkArgument((!operators.isEmpty() ? 1 : 0) != 0, (Object)"There must be at least one operator");
        ImmutableMap.Builder sourceOperators = ImmutableMap.builder();
        for (Operator operator : operators) {
            if (!(operator instanceof SourceOperator)) continue;
            SourceOperator sourceOperator = (SourceOperator)operator;
            sourceOperators.put((Object)sourceOperator.getSourceId(), (Object)sourceOperator);
        }
        this.sourceOperators = sourceOperators.build();
    }

    public DriverContext getDriverContext() {
        return this.driverContext;
    }

    public Set<PlanNodeId> getSourceIds() {
        return this.sourceOperators.keySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        block17: {
            if (!this.state.compareAndSet(State.ALIVE, State.NEED_DESTRUCTION)) {
                return;
            }
            try (DriverLockResult lockResult = this.tryLockAndProcessPendingStateChanges(0, TimeUnit.MILLISECONDS);){
                if (lockResult.wasAcquired()) break block17;
                Driver driver = this;
                synchronized (driver) {
                    if (this.lockHolder != null) {
                        this.lockHolder.interrupt();
                    }
                }
            }
        }
    }

    public boolean isFinished() {
        this.checkLockNotHeld("Can not check finished status while holding the driver lock");
        try (DriverLockResult lockResult = this.tryLockAndProcessPendingStateChanges(0, TimeUnit.MILLISECONDS);){
            if (lockResult.wasAcquired()) {
                boolean finished;
                boolean bl = finished = this.state.get() != State.ALIVE || this.driverContext.isDone() || this.operators.get(this.operators.size() - 1).isFinished();
                if (finished) {
                    this.state.compareAndSet(State.ALIVE, State.NEED_DESTRUCTION);
                }
                boolean bl2 = finished;
                return bl2;
            }
            boolean bl = this.state.get() != State.ALIVE || this.driverContext.isDone();
            return bl;
        }
    }

    public void updateSource(TaskSource source) {
        TaskSource newSource;
        TaskSource currentNewSource;
        this.checkLockNotHeld("Can not update sources while holding the driver lock");
        if (!this.sourceOperators.containsKey(source.getPlanNodeId())) {
            return;
        }
        while ((currentNewSource = this.newSources.putIfAbsent(source.getPlanNodeId(), source)) != null && (newSource = currentNewSource.update(source)) != currentNewSource && !this.newSources.replace(source.getPlanNodeId(), currentNewSource, newSource)) {
        }
        this.tryLockAndProcessPendingStateChanges(0, TimeUnit.MILLISECONDS).close();
    }

    private void processNewSources() {
        this.checkLockHeld("Lock must be held to call processNewSources");
        if (this.state.get() != State.ALIVE) {
            return;
        }
        HashMap<PlanNodeId, TaskSource> sources = new HashMap<PlanNodeId, TaskSource>(this.newSources);
        for (Map.Entry entry : sources.entrySet()) {
            this.newSources.remove(entry.getKey(), entry.getValue());
            this.processNewSource((TaskSource)entry.getValue());
        }
    }

    private void processNewSource(TaskSource source) {
        Sets.SetView newSplits;
        this.checkLockHeld("Lock must be held to call processNewSources");
        TaskSource currentSource = this.currentSources.get(source.getPlanNodeId());
        if (currentSource == null) {
            newSplits = source.getSplits();
            this.currentSources.put(source.getPlanNodeId(), source);
        } else {
            TaskSource newSource = currentSource.update(source);
            if (newSource == currentSource) {
                return;
            }
            newSplits = Sets.difference(newSource.getSplits(), currentSource.getSplits());
            this.currentSources.put(source.getPlanNodeId(), newSource);
        }
        for (ScheduledSplit newSplit : newSplits) {
            Split split = newSplit.getSplit();
            SourceOperator sourceOperator = this.sourceOperators.get(source.getPlanNodeId());
            if (sourceOperator == null) continue;
            sourceOperator.addSplit(split);
        }
        if (source.isNoMoreSplits()) {
            this.sourceOperators.get(source.getPlanNodeId()).noMoreSplits();
        }
    }

    public ListenableFuture<?> processFor(Duration duration) {
        this.checkLockNotHeld("Can not process for a duration while holding the driver lock");
        Preconditions.checkNotNull((Object)duration, (Object)"duration is null");
        long maxRuntime = duration.roundTo(TimeUnit.NANOSECONDS);
        long start = System.nanoTime();
        do {
            ListenableFuture<?> future;
            if ((future = this.process()).isDone()) continue;
            return future;
        } while (System.nanoTime() - start < maxRuntime && !this.isFinished());
        return Operator.NOT_BLOCKED;
    }

    public ListenableFuture<?> process() {
        this.checkLockNotHeld("Can not process while holding the driver lock");
        Throwable throwable = null;
        try (DriverLockResult lockResult = this.tryLockAndProcessPendingStateChanges(100, TimeUnit.MILLISECONDS);){
            if (!lockResult.wasAcquired()) {
                ListenableFuture<?> listenableFuture = Operator.NOT_BLOCKED;
                return listenableFuture;
            }
            this.driverContext.start();
            if (!this.newSources.isEmpty()) {
                this.processNewSources();
            }
            for (int i = 0; i < this.operators.size() - 1 && !this.driverContext.isDone(); ++i) {
                Operator current = this.operators.get(i);
                ListenableFuture<?> blocked = current.isBlocked();
                if (!blocked.isDone()) {
                    current.getOperatorContext().recordBlocked(blocked);
                    ListenableFuture<?> listenableFuture = blocked;
                    return listenableFuture;
                }
                Operator next = this.operators.get(i + 1);
                blocked = next.isBlocked();
                if (!blocked.isDone()) {
                    next.getOperatorContext().recordBlocked(blocked);
                    ListenableFuture<?> x2 = blocked;
                    return x2;
                }
                if (current.isFinished()) {
                    next.getOperatorContext().startIntervalTimer();
                    next.finish();
                    next.getOperatorContext().recordFinish();
                    continue;
                }
                if (!next.needsInput()) continue;
                current.getOperatorContext().startIntervalTimer();
                Page page = current.getOutput();
                current.getOperatorContext().recordGetOutput(page);
                if (page == null) continue;
                next.getOperatorContext().startIntervalTimer();
                next.addInput(page);
                next.getOperatorContext().recordAddInput(page);
            }
            ListenableFuture<?> i = Operator.NOT_BLOCKED;
            return i;
        }
        catch (Throwable t) {
            try {
                this.driverContext.failed(t);
                throw t;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void destroyIfNecessary() {
        this.checkLockHeld("Lock must be held to call destroyIfNecessary");
        if (!this.state.compareAndSet(State.NEED_DESTRUCTION, State.DESTROYED)) {
            return;
        }
        Throwable inFlightException = null;
        try {
            for (Operator operator : this.operators) {
                operator.finish();
            }
        }
        catch (Throwable t) {
            try {
                inFlightException = t;
                throw t;
            }
            catch (Throwable throwable) {
                boolean wasInterrupted2 = Thread.interrupted();
                try {
                    for (Operator operator : this.operators) {
                        if (!(operator instanceof AutoCloseable)) continue;
                        try {
                            ((AutoCloseable)((Object)operator)).close();
                        }
                        catch (InterruptedException t2) {
                            wasInterrupted2 = true;
                        }
                        catch (Throwable t3) {
                            inFlightException = this.addSuppressedException(inFlightException, t3, "Error closing operator %s for task %s", operator.getOperatorContext().getOperatorId(), this.driverContext.getTaskId());
                        }
                    }
                    this.driverContext.finished();
                }
                catch (Throwable t4) {
                    inFlightException = this.addSuppressedException(inFlightException, t4, "Error destroying driver for task %s", this.driverContext.getTaskId());
                }
                finally {
                    if (wasInterrupted2) {
                        Thread.currentThread().interrupt();
                    }
                }
                if (inFlightException != null) {
                    throw Throwables.propagate((Throwable)inFlightException);
                }
                throw throwable;
            }
        }
        boolean wasInterrupted = Thread.interrupted();
        try {
            for (Operator operator : this.operators) {
                if (!(operator instanceof AutoCloseable)) continue;
                try {
                    ((AutoCloseable)((Object)operator)).close();
                }
                catch (InterruptedException t) {
                    wasInterrupted = true;
                }
                catch (Throwable t) {
                    inFlightException = this.addSuppressedException(inFlightException, t, "Error closing operator %s for task %s", operator.getOperatorContext().getOperatorId(), this.driverContext.getTaskId());
                }
            }
            this.driverContext.finished();
        }
        catch (Throwable t) {
            inFlightException = this.addSuppressedException(inFlightException, t, "Error destroying driver for task %s", this.driverContext.getTaskId());
        }
        finally {
            if (wasInterrupted) {
                Thread.currentThread().interrupt();
            }
        }
        if (inFlightException != null) {
            throw Throwables.propagate((Throwable)inFlightException);
        }
    }

    private Throwable addSuppressedException(Throwable inFlightException, Throwable newException, String message, Object ... args) {
        if (newException instanceof Error) {
            if (inFlightException == null) {
                inFlightException = newException;
            } else if (inFlightException != newException) {
                inFlightException.addSuppressed(newException);
            }
        } else {
            log.error(newException, message, args);
        }
        return inFlightException;
    }

    private DriverLockResult tryLockAndProcessPendingStateChanges(int timeout, TimeUnit unit) {
        this.checkLockNotHeld("Can not acquire the driver lock while already holding the driver lock");
        return new DriverLockResult(timeout, unit);
    }

    private synchronized void checkLockNotHeld(String message) {
        Preconditions.checkState((Thread.currentThread() != this.lockHolder ? 1 : 0) != 0, (Object)message);
    }

    private synchronized void checkLockHeld(String message) {
        Preconditions.checkState((Thread.currentThread() == this.lockHolder ? 1 : 0) != 0, (Object)message);
    }

    private class DriverLockResult
    implements AutoCloseable {
        private final boolean acquired;

        private DriverLockResult(int timeout, TimeUnit unit) {
            this.acquired = this.tryAcquire(timeout, unit);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean tryAcquire(int timeout, TimeUnit unit) {
            boolean acquired = false;
            try {
                acquired = Driver.this.exclusiveLock.tryLock(timeout, unit);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            if (acquired) {
                Driver driver = Driver.this;
                synchronized (driver) {
                    Driver.this.lockHolder = Thread.currentThread();
                }
            }
            return acquired;
        }

        public boolean wasAcquired() {
            return this.acquired;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            if (!this.acquired) {
                return;
            }
            boolean done = false;
            while (!done) {
                done = true;
                try {
                    try {
                        Driver.this.processNewSources();
                    }
                    finally {
                        Driver.this.destroyIfNecessary();
                    }
                }
                finally {
                    Driver driver = Driver.this;
                    synchronized (driver) {
                        Driver.this.lockHolder = null;
                    }
                    Driver.this.exclusiveLock.unlock();
                    if (Driver.this.newSources.isEmpty() || Driver.this.state.get() != State.ALIVE || !this.tryAcquire(0, TimeUnit.MILLISECONDS)) continue;
                    done = false;
                }
            }
        }
    }

    private static enum State {
        ALIVE,
        NEED_DESTRUCTION,
        DESTROYED;

    }
}

