/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.HostAddress;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.util.List;

public final class Split {
    private final String connectorId;
    private final ConnectorSplit connectorSplit;

    @JsonCreator
    public Split(@JsonProperty(value="connectorId") String connectorId, @JsonProperty(value="connectorSplit") ConnectorSplit connectorSplit) {
        this.connectorId = (String)Preconditions.checkNotNull((Object)connectorId, (Object)"connectorId is null");
        this.connectorSplit = (ConnectorSplit)Preconditions.checkNotNull((Object)connectorSplit, (Object)"connectorSplit is null");
    }

    @JsonProperty
    public String getConnectorId() {
        return this.connectorId;
    }

    @JsonProperty
    public ConnectorSplit getConnectorSplit() {
        return this.connectorSplit;
    }

    public Object getInfo() {
        return this.connectorSplit.getInfo();
    }

    public List<HostAddress> getAddresses() {
        return this.connectorSplit.getAddresses();
    }

    public boolean isRemotelyAccessible() {
        return this.connectorSplit.isRemotelyAccessible();
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("connectorId", (Object)this.connectorId).add("connectorSplit", (Object)this.connectorSplit).toString();
    }

    public static Function<ConnectorSplit, Split> fromConnectorSplit(final String connectorId) {
        return new Function<ConnectorSplit, Split>(){

            public Split apply(ConnectorSplit split) {
                return new Split(connectorId, split);
            }
        };
    }
}

