/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.metadata.ColumnHandle;
import com.facebook.presto.metadata.Util;
import com.facebook.presto.spi.ConnectorColumnHandle;
import com.facebook.presto.spi.ConnectorPartition;
import com.facebook.presto.spi.TupleDomain;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;

public class Partition {
    private final String connectorId;
    private final ConnectorPartition connectorPartition;

    public Partition(String connectorId, ConnectorPartition connectorPartition) {
        this.connectorId = (String)Preconditions.checkNotNull((Object)connectorId, (Object)"connectorId is null");
        this.connectorPartition = (ConnectorPartition)Preconditions.checkNotNull((Object)connectorPartition, (Object)"partition is null");
    }

    public ConnectorPartition getConnectorPartition() {
        return this.connectorPartition;
    }

    public TupleDomain<ColumnHandle> getTupleDomain() {
        return Util.fromConnectorDomain(this.connectorId, (TupleDomain<ConnectorColumnHandle>)this.connectorPartition.getTupleDomain());
    }

    public String toString() {
        return this.connectorId + ":" + this.connectorPartition;
    }

    public static Function<Partition, ConnectorPartition> connectorPartitionGetter() {
        return new Function<Partition, ConnectorPartition>(){

            public ConnectorPartition apply(Partition input) {
                return input.getConnectorPartition();
            }
        };
    }

    public static Function<ConnectorPartition, Partition> fromConnectorPartition(final String connectorId) {
        return new Function<ConnectorPartition, Partition>(){

            public Partition apply(ConnectorPartition partition) {
                return new Partition(connectorId, partition);
            }
        };
    }
}

