/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.execution.SplitSource;
import com.facebook.presto.metadata.Split;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nullable;

public class SampledSplitSource
implements SplitSource {
    private final SplitSource splitSource;
    private final double sampleRatio;

    public SampledSplitSource(SplitSource splitSource, double sampleRatio) {
        this.splitSource = (SplitSource)Preconditions.checkNotNull((Object)splitSource, (Object)"dataSource is null");
        this.sampleRatio = sampleRatio;
    }

    @Override
    @Nullable
    public String getDataSourceName() {
        return this.splitSource.getDataSourceName();
    }

    @Override
    public List<Split> getNextBatch(int maxSize) throws InterruptedException {
        List<Split> nextBatch = this.splitSource.getNextBatch(maxSize);
        Iterable sampleIterable = Iterables.filter(nextBatch, (Predicate)new Predicate<Split>(){

            public boolean apply(@Nullable Split input) {
                return ThreadLocalRandom.current().nextDouble() < SampledSplitSource.this.sampleRatio;
            }
        });
        return ImmutableList.copyOf((Iterable)sampleIterable);
    }

    @Override
    public void close() {
        this.splitSource.close();
    }

    @Override
    public boolean isFinished() {
        return this.splitSource.isFinished();
    }
}

