/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.Session;
import com.facebook.presto.execution.DataDefinitionTask;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataUtil;
import com.facebook.presto.metadata.QualifiedTableName;
import com.facebook.presto.metadata.TableHandle;
import com.facebook.presto.sql.analyzer.SemanticErrorCode;
import com.facebook.presto.sql.analyzer.SemanticException;
import com.facebook.presto.sql.tree.DropTable;
import com.facebook.presto.sql.tree.Node;
import com.google.common.base.Optional;

public class DropTableTask
implements DataDefinitionTask<DropTable> {
    @Override
    public void execute(DropTable statement, Session session, Metadata metadata) {
        QualifiedTableName tableName = MetadataUtil.createQualifiedTableName(session, statement.getTableName());
        Optional<TableHandle> tableHandle = metadata.getTableHandle(session, tableName);
        if (!tableHandle.isPresent()) {
            throw new SemanticException(SemanticErrorCode.MISSING_TABLE, (Node)statement, "Table '%s' does not exist", tableName);
        }
        metadata.dropTable((TableHandle)tableHandle.get());
    }
}

