/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.byteCode.instruction;

import com.facebook.presto.byteCode.ByteCodeNode;
import com.facebook.presto.byteCode.ByteCodeVisitor;
import com.facebook.presto.byteCode.OpCode;
import com.facebook.presto.byteCode.ParameterizedType;
import com.facebook.presto.byteCode.instruction.InstructionNode;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.List;
import org.objectweb.asm.MethodVisitor;

public abstract class FieldInstruction
implements InstructionNode {
    private final boolean isStatic;
    private final OpCode opCode;
    private final ParameterizedType classType;
    private final String fieldName;
    private final ParameterizedType fieldType;

    public static FieldInstruction getFieldInstruction(Field field) {
        boolean isStatic = Modifier.isStatic(field.getModifiers());
        return new GetFieldInstruction(isStatic, ParameterizedType.type(field.getDeclaringClass()), field.getName(), ParameterizedType.type(field.getType()));
    }

    public static FieldInstruction putFieldInstruction(Field field) {
        boolean isStatic = Modifier.isStatic(field.getModifiers());
        return new PutFieldInstruction(isStatic, ParameterizedType.type(field.getDeclaringClass()), field.getName(), ParameterizedType.type(field.getType()));
    }

    public static FieldInstruction getFieldInstruction(ParameterizedType classType, String fieldName, ParameterizedType fieldType) {
        return new GetFieldInstruction(false, classType, fieldName, fieldType);
    }

    public static FieldInstruction getFieldInstruction(Class<?> classType, String fieldName, Class<?> fieldType) {
        return new GetFieldInstruction(false, classType, fieldName, fieldType);
    }

    public static FieldInstruction putFieldInstruction(ParameterizedType classType, String fieldName, ParameterizedType fieldType) {
        return new PutFieldInstruction(false, classType, fieldName, fieldType);
    }

    public static FieldInstruction putFieldInstruction(Class<?> classType, String fieldName, Class<?> fieldType) {
        return new PutFieldInstruction(false, classType, fieldName, fieldType);
    }

    public static FieldInstruction getStaticInstruction(ParameterizedType classType, String fieldName, ParameterizedType fieldType) {
        return new GetFieldInstruction(true, classType, fieldName, fieldType);
    }

    public static FieldInstruction getStaticInstruction(Class<?> classType, String fieldName, Class<?> fieldType) {
        return new GetFieldInstruction(true, classType, fieldName, fieldType);
    }

    public static FieldInstruction putStaticInstruction(ParameterizedType classType, String fieldName, ParameterizedType fieldType) {
        return new PutFieldInstruction(true, classType, fieldName, fieldType);
    }

    public static FieldInstruction putStaticInstruction(Class<?> classType, String fieldName, Class<?> fieldType) {
        return new PutFieldInstruction(true, classType, fieldName, fieldType);
    }

    private FieldInstruction(boolean isStatic, OpCode opCode, ParameterizedType classType, String fieldName, ParameterizedType fieldType) {
        this.isStatic = isStatic;
        this.opCode = opCode;
        this.classType = classType;
        this.fieldName = fieldName;
        this.fieldType = fieldType;
    }

    @Override
    public void accept(MethodVisitor visitor) {
        visitor.visitFieldInsn(this.opCode.getOpCode(), this.classType.getClassName(), this.fieldName, this.fieldType.getType());
    }

    @Override
    public List<ByteCodeNode> getChildNodes() {
        return ImmutableList.of();
    }

    @Override
    public <T> T accept(ByteCodeNode parent, ByteCodeVisitor<T> visitor) {
        return visitor.visitFieldInstruction(parent, this);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("isStatic", this.isStatic).add("classType", (Object)this.classType).add("fieldName", (Object)this.fieldName).add("fieldType", (Object)this.fieldType).toString();
    }

    public static class PutFieldInstruction
    extends FieldInstruction {
        public PutFieldInstruction(boolean isStatic, ParameterizedType classType, String fieldName, ParameterizedType fieldType) {
            super(isStatic, isStatic ? OpCode.PUTSTATIC : OpCode.PUTFIELD, classType, fieldName, fieldType);
        }

        public PutFieldInstruction(boolean isStatic, Class<?> classType, String fieldName, Class<?> fieldType) {
            super(isStatic, isStatic ? OpCode.PUTSTATIC : OpCode.PUTFIELD, ParameterizedType.type(classType), fieldName, ParameterizedType.type(fieldType));
        }

        @Override
        public <T> T accept(ByteCodeNode parent, ByteCodeVisitor<T> visitor) {
            return visitor.visitPutField(parent, this);
        }
    }

    public static class GetFieldInstruction
    extends FieldInstruction {
        public GetFieldInstruction(boolean isStatic, ParameterizedType classType, String fieldName, ParameterizedType fieldType) {
            super(isStatic, isStatic ? OpCode.GETSTATIC : OpCode.GETFIELD, classType, fieldName, fieldType);
        }

        public GetFieldInstruction(boolean isStatic, Class<?> classType, String fieldName, Class<?> fieldType) {
            super(isStatic, isStatic ? OpCode.GETSTATIC : OpCode.GETFIELD, ParameterizedType.type(classType), fieldName, ParameterizedType.type(fieldType));
        }

        @Override
        public <T> T accept(ByteCodeNode parent, ByteCodeVisitor<T> visitor) {
            return visitor.visitGetField(parent, this);
        }
    }
}

