/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.byteCode.expression;

import com.facebook.presto.byteCode.Block;
import com.facebook.presto.byteCode.ByteCodeNode;
import com.facebook.presto.byteCode.ParameterizedType;
import com.facebook.presto.byteCode.expression.ByteCodeExpression;
import com.facebook.presto.byteCode.expression.ConstantByteCodeExpression;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.lang.reflect.Method;
import java.util.List;

class InvokeDynamicByteCodeExpression
extends ByteCodeExpression {
    private final Method bootstrapMethod;
    private final List<Object> bootstrapArgs;
    private final String methodName;
    private final ParameterizedType returnType;
    private final List<ByteCodeExpression> parameters;
    private final List<ParameterizedType> parameterTypes;

    InvokeDynamicByteCodeExpression(Method bootstrapMethod, Iterable<?> bootstrapArgs, String methodName, ParameterizedType returnType, Iterable<? extends ByteCodeExpression> parameters, Iterable<ParameterizedType> parameterTypes) {
        super(returnType);
        this.bootstrapMethod = (Method)Preconditions.checkNotNull((Object)bootstrapMethod, (Object)"bootstrapMethod is null");
        this.bootstrapArgs = ImmutableList.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(bootstrapArgs, (Object)"bootstrapArgs is null")));
        this.methodName = (String)Preconditions.checkNotNull((Object)methodName, (Object)"methodName is null");
        this.returnType = (ParameterizedType)Preconditions.checkNotNull((Object)returnType, (Object)"returnType is null");
        this.parameters = ImmutableList.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(parameters, (Object)"parameters is null")));
        this.parameterTypes = ImmutableList.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(parameterTypes, (Object)"parameterTypes is null")));
    }

    @Override
    public ByteCodeNode getByteCode() {
        Block block = new Block(null);
        for (ByteCodeExpression parameter : this.parameters) {
            block.append(parameter);
        }
        return block.invokeDynamic(this.methodName, this.returnType, this.parameterTypes, this.bootstrapMethod, this.bootstrapArgs);
    }

    @Override
    public List<ByteCodeNode> getChildNodes() {
        return ImmutableList.of();
    }

    @Override
    protected String formatOneLine() {
        StringBuilder builder = new StringBuilder();
        builder.append("[").append(this.bootstrapMethod.getName());
        if (!this.bootstrapArgs.isEmpty()) {
            builder.append("(").append(Joiner.on((String)", ").join(Iterables.transform(this.bootstrapArgs, ConstantByteCodeExpression.constantRenderer()))).append(")");
        }
        builder.append("]=>");
        builder.append(this.methodName).append("(").append(Joiner.on((String)", ").join(this.parameters)).append(")");
        return builder.toString();
    }
}

