/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.byteCode;

import com.facebook.presto.byteCode.IterationScope;
import com.facebook.presto.byteCode.MethodDefinition;
import com.facebook.presto.byteCode.ParameterizedType;
import com.facebook.presto.byteCode.Variable;
import com.facebook.presto.byteCode.instruction.LabelNode;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.objectweb.asm.Type;

public class CompilerContext {
    private final Method defaultBootstrapMethod;
    private final Object[] defaultBootstrapArguments;
    private final Map<String, Variable> variables = new TreeMap<String, Variable>();
    private final List<Variable> allVariables = new ArrayList<Variable>();
    private int nextSlot;
    private final Deque<IterationScope> iterationScopes = new ArrayDeque<IterationScope>();
    private final LabelNode variableStartLabel = new LabelNode("VariableStart");
    private final LabelNode variableEndLabel = new LabelNode("VariableEnd");
    private Integer currentLine;

    public CompilerContext() {
        this(null);
    }

    public CompilerContext(Method defaultBootstrapMethod) {
        this(defaultBootstrapMethod, new Object[0]);
    }

    public CompilerContext(Method defaultBootstrapMethod, Object[] defaultBootstrapArguments) {
        this.defaultBootstrapMethod = defaultBootstrapMethod;
        this.defaultBootstrapArguments = defaultBootstrapArguments;
    }

    public Variable createTempVariable(Class<?> type) {
        Variable variable = new Variable("temp_" + this.nextSlot, this.nextSlot, ParameterizedType.type(type));
        this.nextSlot += Type.getType((String)ParameterizedType.type(type).getType()).getSize();
        return variable;
    }

    public Variable getVariable(String name) {
        Variable variable = this.variables.get(name);
        Preconditions.checkArgument((variable != null ? 1 : 0) != 0, (String)"Variable %s not defined", (Object[])new Object[]{name});
        return variable;
    }

    public void setVariable(String name, Variable variable) {
        Preconditions.checkNotNull((Object)name, (Object)"name is null");
        Preconditions.checkNotNull((Object)variable, (Object)"variable is null");
        this.variables.put(name, variable);
    }

    public void declareThisVariable(ParameterizedType type) {
        if (this.variables.containsKey("this")) {
            return;
        }
        Preconditions.checkState((this.nextSlot == 0 ? 1 : 0) != 0, (Object)"The 'this' variable must be declared before all other parameters and local variables");
        Variable variable = new Variable("this", 0, type);
        this.nextSlot = 1;
        this.variables.put("this", variable);
    }

    public Variable declareParameter(ParameterizedType type, String parameterName) {
        Preconditions.checkArgument((!this.variables.containsKey(parameterName) ? 1 : 0) != 0, (String)"There is already a parameter named %s", (Object[])new Object[]{parameterName});
        Variable variable = new Variable(parameterName, this.nextSlot, type);
        this.nextSlot += Type.getType((String)type.getType()).getSize();
        this.allVariables.add(variable);
        this.variables.put(parameterName, variable);
        return variable;
    }

    public Variable declareVariable(Class<?> type, String variableName) {
        return this.declareVariable(ParameterizedType.type(type), variableName);
    }

    public Variable declareVariable(ParameterizedType type, String variableName) {
        Preconditions.checkArgument((!this.variables.containsKey(variableName) ? 1 : 0) != 0, (String)"There is already a parameter named %s", (Object[])new Object[]{variableName});
        Variable variable = new Variable(variableName, this.nextSlot, type);
        this.nextSlot += Type.getType((String)type.getType()).getSize();
        this.allVariables.add(variable);
        this.variables.put(variableName, variable);
        return variable;
    }

    public void pushIterationScope(LabelNode begin, LabelNode end) {
        this.iterationScopes.push(new IterationScope(begin, end));
    }

    public void popIterationScope() {
        this.iterationScopes.pop();
    }

    public IterationScope peekIterationScope(int level) {
        return (IterationScope)Iterators.get(this.iterationScopes.iterator(), (int)(level - 1), null);
    }

    public Method getDefaultBootstrapMethod() {
        return this.defaultBootstrapMethod;
    }

    public Object[] getDefaultBootstrapArguments() {
        return this.defaultBootstrapArguments;
    }

    public boolean hasVisitedLine(Integer line) {
        return this.currentLine != null && line.intValue() == this.currentLine.intValue();
    }

    public void cleanLineNumber() {
        this.currentLine = null;
    }

    public void visitLine(int currentLine) {
        this.currentLine = currentLine;
    }

    public LabelNode getVariableStartLabel() {
        return this.variableStartLabel;
    }

    public LabelNode getVariableEndLabel() {
        return this.variableEndLabel;
    }

    public void addLocalVariables(MethodDefinition methodDefinition) {
        for (Variable variable : this.allVariables) {
            methodDefinition.addLocalVariable(variable, this.variableStartLabel, this.variableEndLabel);
        }
    }
}

