/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto;

import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.type.TimeZoneKey;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Locale;
import java.util.Objects;
import java.util.TimeZone;
import javax.annotation.Nullable;

public final class Session {
    private final String user;
    @Nullable
    private final String source;
    private final String catalog;
    private final String schema;
    private final TimeZoneKey timeZoneKey;
    private final Locale locale;
    @Nullable
    private final String remoteUserAddress;
    @Nullable
    private final String userAgent;
    private final long startTime;

    @JsonCreator
    public Session(@JsonProperty(value="user") String user, @JsonProperty(value="source") @Nullable String source, @JsonProperty(value="catalog") String catalog, @JsonProperty(value="schema") String schema, @JsonProperty(value="timeZoneKey") TimeZoneKey timeZoneKey, @JsonProperty(value="locale") Locale locale, @JsonProperty(value="remoteUserAddress") @Nullable String remoteUserAddress, @JsonProperty(value="userAgent") @Nullable String userAgent, @JsonProperty(value="startTime") long startTime) {
        this.user = Objects.requireNonNull(user, "user is null");
        this.source = source;
        this.catalog = Objects.requireNonNull(catalog, "catalog is null");
        this.schema = Objects.requireNonNull(schema, "schema is null");
        this.timeZoneKey = Objects.requireNonNull(timeZoneKey, "timeZoneKey is null");
        this.locale = Objects.requireNonNull(locale, "locale is null");
        this.remoteUserAddress = remoteUserAddress;
        this.userAgent = userAgent;
        this.startTime = startTime;
    }

    @JsonProperty
    public String getUser() {
        return this.user;
    }

    @Nullable
    @JsonProperty
    public String getSource() {
        return this.source;
    }

    @JsonProperty
    public String getCatalog() {
        return this.catalog;
    }

    @JsonProperty
    public String getSchema() {
        return this.schema;
    }

    @JsonProperty
    public TimeZoneKey getTimeZoneKey() {
        return this.timeZoneKey;
    }

    @JsonProperty
    public Locale getLocale() {
        return this.locale;
    }

    @Nullable
    @JsonProperty
    public String getRemoteUserAddress() {
        return this.remoteUserAddress;
    }

    @Nullable
    @JsonProperty
    public String getUserAgent() {
        return this.userAgent;
    }

    @JsonProperty
    public long getStartTime() {
        return this.startTime;
    }

    public ConnectorSession toConnectorSession() {
        return new ConnectorSession(this.user, this.schema, this.timeZoneKey, this.locale, this.startTime);
    }

    public String toString() {
        return com.google.common.base.Objects.toStringHelper((Object)this).add("user", (Object)this.user).add("source", (Object)this.source).add("catalog", (Object)this.catalog).add("schema", (Object)this.schema).add("timeZoneKey", (Object)this.timeZoneKey).add("locale", (Object)this.locale).add("remoteUserAddress", (Object)this.remoteUserAddress).add("userAgent", (Object)this.userAgent).add("startTime", this.startTime).toString();
    }

    public static SessionBuilder builder() {
        return new SessionBuilder();
    }

    public static class SessionBuilder {
        private String user;
        private String source;
        private String catalog;
        private String schema;
        private TimeZoneKey timeZoneKey = TimeZoneKey.getTimeZoneKey((String)TimeZone.getDefault().getID());
        private Locale locale = Locale.getDefault();
        private String remoteUserAddress;
        private String userAgent;
        private long startTime = System.currentTimeMillis();

        private SessionBuilder() {
        }

        public SessionBuilder setCatalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        public SessionBuilder setLocale(Locale locale) {
            this.locale = locale;
            return this;
        }

        public SessionBuilder setRemoteUserAddress(String remoteUserAddress) {
            this.remoteUserAddress = remoteUserAddress;
            return this;
        }

        public SessionBuilder setSchema(String schema) {
            this.schema = schema;
            return this;
        }

        public SessionBuilder setSource(String source) {
            this.source = source;
            return this;
        }

        public SessionBuilder setStartTime(long startTime) {
            this.startTime = startTime;
            return this;
        }

        public SessionBuilder setTimeZoneKey(TimeZoneKey timeZoneKey) {
            this.timeZoneKey = timeZoneKey;
            return this;
        }

        public SessionBuilder setUser(String user) {
            this.user = user;
            return this;
        }

        public SessionBuilder setUserAgent(String userAgent) {
            this.userAgent = userAgent;
            return this;
        }

        public Session build() {
            return new Session(this.user, this.source, this.catalog, this.schema, this.timeZoneKey, this.locale, this.remoteUserAddress, this.userAgent, this.startTime);
        }
    }
}

