/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto;

import com.facebook.presto.PagePartitionFunction;
import com.facebook.presto.execution.TaskId;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;

public final class OutputBuffers {
    public static final OutputBuffers INITIAL_EMPTY_OUTPUT_BUFFERS = new OutputBuffers(0L, false, (Map<TaskId, PagePartitionFunction>)ImmutableMap.of());
    private final long version;
    private final boolean noMoreBufferIds;
    private final Map<TaskId, PagePartitionFunction> buffers;

    @JsonCreator
    public OutputBuffers(@JsonProperty(value="version") long version, @JsonProperty(value="noMoreBufferIds") boolean noMoreBufferIds, @JsonProperty(value="buffers") Map<TaskId, PagePartitionFunction> buffers) {
        this.version = version;
        this.buffers = ImmutableMap.copyOf((Map)((Map)Preconditions.checkNotNull(buffers, (Object)"buffers is null")));
        this.noMoreBufferIds = noMoreBufferIds;
    }

    @JsonProperty
    public long getVersion() {
        return this.version;
    }

    @JsonProperty
    public boolean isNoMoreBufferIds() {
        return this.noMoreBufferIds;
    }

    @JsonProperty
    public Map<TaskId, PagePartitionFunction> getBuffers() {
        return this.buffers;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.version, this.noMoreBufferIds, this.buffers});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        OutputBuffers other = (OutputBuffers)obj;
        return Objects.equal((Object)this.version, (Object)other.version) && Objects.equal((Object)this.noMoreBufferIds, (Object)other.noMoreBufferIds) && Objects.equal(this.buffers, other.buffers);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("version", this.version).add("noMoreBufferIds", this.noMoreBufferIds).add("bufferIds", this.buffers).toString();
    }

    public OutputBuffers withBuffer(TaskId bufferId, PagePartitionFunction pagePartitionFunction) {
        Preconditions.checkNotNull((Object)bufferId, (Object)"bufferId is null");
        Preconditions.checkState((!this.noMoreBufferIds ? 1 : 0) != 0, (Object)"No more buffer ids already set");
        if (this.buffers.containsKey(bufferId)) {
            this.checkHasBuffer(bufferId, pagePartitionFunction);
            return this;
        }
        return new OutputBuffers(this.version + 1L, false, (Map<TaskId, PagePartitionFunction>)ImmutableMap.builder().putAll(this.buffers).put((Object)bufferId, (Object)pagePartitionFunction).build());
    }

    public OutputBuffers withBuffers(Map<TaskId, PagePartitionFunction> buffers) {
        Preconditions.checkNotNull(buffers, (Object)"buffers is null");
        HashMap<TaskId, PagePartitionFunction> newBuffers = new HashMap<TaskId, PagePartitionFunction>();
        for (Map.Entry<TaskId, PagePartitionFunction> entry : buffers.entrySet()) {
            TaskId bufferId = entry.getKey();
            PagePartitionFunction pagePartitionFunction = entry.getValue();
            if (this.buffers.containsKey(bufferId)) {
                this.checkHasBuffer(bufferId, pagePartitionFunction);
                continue;
            }
            newBuffers.put(bufferId, pagePartitionFunction);
        }
        if (newBuffers.isEmpty()) {
            return this;
        }
        Preconditions.checkState((!this.noMoreBufferIds ? 1 : 0) != 0, (Object)"No more buffer ids already set");
        newBuffers.putAll(this.buffers);
        return new OutputBuffers(this.version + 1L, false, newBuffers);
    }

    public OutputBuffers withNoMoreBufferIds() {
        Preconditions.checkNotNull((Object)this, (Object)"this is null");
        if (this.noMoreBufferIds) {
            return this;
        }
        return new OutputBuffers(this.version + 1L, true, this.buffers);
    }

    private void checkHasBuffer(TaskId bufferId, PagePartitionFunction pagePartitionFunction) {
        Preconditions.checkState((boolean)this.getBuffers().get(bufferId).equals(pagePartitionFunction), (String)"outputBuffers already contains buffer %s, but partition function is %s not %s", (Object[])new Object[]{bufferId, this.buffers.get(bufferId), pagePartitionFunction});
    }
}

