/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type;

import com.facebook.presto.metadata.OperatorType;
import com.facebook.presto.operator.scalar.ScalarOperator;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.VarbinaryType;
import com.facebook.presto.type.SqlType;
import io.airlift.slice.Slice;

public final class VarbinaryOperators {
    private VarbinaryOperators() {
    }

    @ScalarOperator(value=OperatorType.EQUAL)
    @SqlType(value=BooleanType.class)
    public static boolean equal(@SqlType(value=VarbinaryType.class) Slice left, @SqlType(value=VarbinaryType.class) Slice right) {
        return left.equals((Object)right);
    }

    @ScalarOperator(value=OperatorType.NOT_EQUAL)
    @SqlType(value=BooleanType.class)
    public static boolean notEqual(@SqlType(value=VarbinaryType.class) Slice left, @SqlType(value=VarbinaryType.class) Slice right) {
        return !left.equals((Object)right);
    }

    @ScalarOperator(value=OperatorType.LESS_THAN)
    @SqlType(value=BooleanType.class)
    public static boolean lessThan(@SqlType(value=VarbinaryType.class) Slice left, @SqlType(value=VarbinaryType.class) Slice right) {
        return left.compareTo(right) < 0;
    }

    @ScalarOperator(value=OperatorType.LESS_THAN_OR_EQUAL)
    @SqlType(value=BooleanType.class)
    public static boolean lessThanOrEqual(@SqlType(value=VarbinaryType.class) Slice left, @SqlType(value=VarbinaryType.class) Slice right) {
        return left.compareTo(right) <= 0;
    }

    @ScalarOperator(value=OperatorType.GREATER_THAN)
    @SqlType(value=BooleanType.class)
    public static boolean greaterThan(@SqlType(value=VarbinaryType.class) Slice left, @SqlType(value=VarbinaryType.class) Slice right) {
        return left.compareTo(right) > 0;
    }

    @ScalarOperator(value=OperatorType.GREATER_THAN_OR_EQUAL)
    @SqlType(value=BooleanType.class)
    public static boolean greaterThanOrEqual(@SqlType(value=VarbinaryType.class) Slice left, @SqlType(value=VarbinaryType.class) Slice right) {
        return left.compareTo(right) >= 0;
    }

    @ScalarOperator(value=OperatorType.BETWEEN)
    @SqlType(value=BooleanType.class)
    public static boolean between(@SqlType(value=VarbinaryType.class) Slice value, @SqlType(value=VarbinaryType.class) Slice min, @SqlType(value=VarbinaryType.class) Slice max) {
        return min.compareTo(value) <= 0 && value.compareTo(max) <= 0;
    }

    @ScalarOperator(value=OperatorType.HASH_CODE)
    public static int hashCode(@SqlType(value=VarbinaryType.class) Slice value) {
        return value.hashCode();
    }
}

