/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type;

import com.facebook.presto.metadata.OperatorType;
import com.facebook.presto.operator.scalar.ScalarOperator;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.DateTimeEncoding;
import com.facebook.presto.spi.type.TimeType;
import com.facebook.presto.spi.type.TimeWithTimeZoneType;
import com.facebook.presto.spi.type.TimeZoneKey;
import com.facebook.presto.spi.type.TimestampType;
import com.facebook.presto.spi.type.TimestampWithTimeZoneType;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.type.SqlType;
import com.facebook.presto.util.DateTimeUtils;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public final class TimeOperators {
    private TimeOperators() {
    }

    @ScalarOperator(value=OperatorType.EQUAL)
    @SqlType(value=BooleanType.class)
    public static boolean equal(@SqlType(value=TimeType.class) long left, @SqlType(value=TimeType.class) long right) {
        return left == right;
    }

    @ScalarOperator(value=OperatorType.NOT_EQUAL)
    @SqlType(value=BooleanType.class)
    public static boolean notEqual(@SqlType(value=TimeType.class) long left, @SqlType(value=TimeType.class) long right) {
        return left != right;
    }

    @ScalarOperator(value=OperatorType.LESS_THAN)
    @SqlType(value=BooleanType.class)
    public static boolean lessThan(@SqlType(value=TimeType.class) long left, @SqlType(value=TimeType.class) long right) {
        return left < right;
    }

    @ScalarOperator(value=OperatorType.LESS_THAN_OR_EQUAL)
    @SqlType(value=BooleanType.class)
    public static boolean lessThanOrEqual(@SqlType(value=TimeType.class) long left, @SqlType(value=TimeType.class) long right) {
        return left <= right;
    }

    @ScalarOperator(value=OperatorType.GREATER_THAN)
    @SqlType(value=BooleanType.class)
    public static boolean greaterThan(@SqlType(value=TimeType.class) long left, @SqlType(value=TimeType.class) long right) {
        return left > right;
    }

    @ScalarOperator(value=OperatorType.GREATER_THAN_OR_EQUAL)
    @SqlType(value=BooleanType.class)
    public static boolean greaterThanOrEqual(@SqlType(value=TimeType.class) long left, @SqlType(value=TimeType.class) long right) {
        return left >= right;
    }

    @ScalarOperator(value=OperatorType.BETWEEN)
    @SqlType(value=BooleanType.class)
    public static boolean between(@SqlType(value=TimeType.class) long value, @SqlType(value=TimeType.class) long min, @SqlType(value=TimeType.class) long max) {
        return min <= value && value <= max;
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value=TimeWithTimeZoneType.class)
    public static long castToTimeWithTimeZone(ConnectorSession session, @SqlType(value=TimeType.class) long value) {
        return DateTimeEncoding.packDateTimeWithZone((long)value, (TimeZoneKey)session.getTimeZoneKey());
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value=TimestampType.class)
    public static long castToTimestamp(@SqlType(value=TimeType.class) long value) {
        return value;
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value=TimestampWithTimeZoneType.class)
    public static long castToTimestampWithTimeZone(ConnectorSession session, @SqlType(value=TimeType.class) long value) {
        return DateTimeEncoding.packDateTimeWithZone((long)value, (TimeZoneKey)session.getTimeZoneKey());
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value=VarcharType.class)
    public static Slice castToSlice(ConnectorSession session, @SqlType(value=TimeType.class) long value) {
        return Slices.copiedBuffer((String)DateTimeUtils.printTimeWithoutTimeZone(session.getTimeZoneKey(), value), (Charset)StandardCharsets.UTF_8);
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value=TimeType.class)
    public static long castFromSlice(ConnectorSession session, @SqlType(value=VarcharType.class) Slice value) {
        try {
            return DateTimeUtils.parseTimeWithoutTimeZone(session.getTimeZoneKey(), value.toStringUtf8());
        }
        catch (IllegalArgumentException e) {
            throw new PrestoException(StandardErrorCode.INVALID_CAST_ARGUMENT.toErrorCode(), (Throwable)e);
        }
    }

    @ScalarOperator(value=OperatorType.HASH_CODE)
    public static int hashCode(@SqlType(value=TimeType.class) long value) {
        return (int)(value ^ value >>> 32);
    }
}

