/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type;

import com.facebook.presto.operator.scalar.ColorFunctions;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.block.BlockCursor;
import com.facebook.presto.spi.block.BlockEncodingFactory;
import com.facebook.presto.spi.block.FixedWidthBlockUtil;
import com.facebook.presto.spi.type.FixedWidthType;
import com.google.common.base.Preconditions;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;

public class ColorType
implements FixedWidthType {
    public static final ColorType COLOR = new ColorType();
    private static final FixedWidthBlockUtil.FixedWidthBlockBuilderFactory BLOCK_BUILDER_FACTORY = FixedWidthBlockUtil.createIsolatedFixedWidthBlockBuilderFactory((FixedWidthType)COLOR);
    public static final BlockEncodingFactory<?> BLOCK_ENCODING_FACTORY = BLOCK_BUILDER_FACTORY.getBlockEncodingFactory();

    public static ColorType getInstance() {
        return COLOR;
    }

    private ColorType() {
    }

    public String getName() {
        return "color";
    }

    public Class<?> getJavaType() {
        return Long.TYPE;
    }

    public int getFixedSize() {
        return 4;
    }

    public Object getObjectValue(ConnectorSession session, Slice slice, int offset) {
        int color = slice.getInt(offset);
        if (color < 0) {
            return ColorFunctions.SystemColor.valueOf(-(color + 1)).getName();
        }
        return String.format("#%02x%02x%02x", color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF);
    }

    public BlockBuilder createBlockBuilder(BlockBuilderStatus blockBuilderStatus) {
        return BLOCK_BUILDER_FACTORY.createFixedWidthBlockBuilder(blockBuilderStatus);
    }

    public BlockBuilder createFixedSizeBlockBuilder(int positionCount) {
        return BLOCK_BUILDER_FACTORY.createFixedWidthBlockBuilder(positionCount);
    }

    public boolean getBoolean(Slice slice, int offset) {
        throw new UnsupportedOperationException();
    }

    public void writeBoolean(SliceOutput sliceOutput, boolean value) {
        throw new UnsupportedOperationException();
    }

    public long getLong(Slice slice, int offset) {
        return slice.getInt(offset);
    }

    public void writeLong(SliceOutput sliceOutput, long value) {
        sliceOutput.writeInt((int)value);
    }

    public double getDouble(Slice slice, int offset) {
        throw new UnsupportedOperationException();
    }

    public void writeDouble(SliceOutput sliceOutput, double value) {
        throw new UnsupportedOperationException();
    }

    public Slice getSlice(Slice slice, int offset) {
        return slice.slice(offset, this.getFixedSize());
    }

    public void writeSlice(SliceOutput sliceOutput, Slice value, int offset) {
        Preconditions.checkArgument((value.length() == 4 ? 1 : 0) != 0);
        sliceOutput.writeBytes(value, offset, 4);
    }

    public boolean equalTo(Slice leftSlice, int leftOffset, Slice rightSlice, int rightOffset) {
        return leftSlice.getInt(leftOffset) == rightSlice.getInt(rightOffset);
    }

    public boolean equalTo(Slice leftSlice, int leftOffset, BlockCursor rightCursor) {
        return leftSlice.getInt(leftOffset) == (int)rightCursor.getLong();
    }

    public int hash(Slice slice, int offset) {
        return slice.getInt(offset);
    }

    public int compareTo(Slice leftSlice, int leftOffset, Slice rightSlice, int rightOffset) {
        throw new UnsupportedOperationException("Color is not ordered");
    }

    public void appendTo(Slice slice, int offset, BlockBuilder blockBuilder) {
        blockBuilder.appendLong((long)slice.getInt(offset));
    }

    public void appendTo(Slice slice, int offset, SliceOutput sliceOutput) {
        sliceOutput.writeBytes(slice, offset, 4);
    }

    public String toString() {
        return this.getName();
    }
}

