/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.testing;

import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.OutputFactory;
import com.facebook.presto.operator.Page;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Collection;
import java.util.List;

public class NullOutputOperator
implements Operator {
    private final OperatorContext operatorContext;
    private final List<Type> types;
    private boolean finished;

    public NullOutputOperator(OperatorContext operatorContext, List<Type> types) {
        this.operatorContext = (OperatorContext)Preconditions.checkNotNull((Object)operatorContext, (Object)"operatorContext is null");
        this.types = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(types, (Object)"types is null")));
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public List<Type> getTypes() {
        return this.types;
    }

    @Override
    public void finish() {
        this.finished = true;
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        return NOT_BLOCKED;
    }

    @Override
    public boolean needsInput() {
        return true;
    }

    @Override
    public void addInput(Page page) {
        this.operatorContext.recordGeneratedOutput(page.getDataSize(), page.getPositionCount());
    }

    @Override
    public Page getOutput() {
        return null;
    }

    public static class NullOutputOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final List<Type> types;

        public NullOutputOperatorFactory(int operatorId, List<Type> types) {
            this.operatorId = operatorId;
            this.types = types;
        }

        @Override
        public List<Type> getTypes() {
            return this.types;
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, NullOutputOperator.class.getSimpleName());
            return new NullOutputOperator(operatorContext, this.types);
        }

        @Override
        public void close() {
        }
    }

    public static class NullOutputFactory
    implements OutputFactory {
        @Override
        public OperatorFactory createOutputOperator(int operatorId, List<Type> sourceType) {
            return new NullOutputOperatorFactory(operatorId, sourceType);
        }
    }
}

