/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.testing;

import com.facebook.presto.ScheduledSplit;
import com.facebook.presto.TaskSource;
import com.facebook.presto.connector.ConnectorManager;
import com.facebook.presto.connector.system.CatalogSystemTable;
import com.facebook.presto.connector.system.NodesSystemTable;
import com.facebook.presto.connector.system.SystemConnector;
import com.facebook.presto.connector.system.SystemRecordSetProvider;
import com.facebook.presto.connector.system.SystemSplitManager;
import com.facebook.presto.connector.system.SystemTablesManager;
import com.facebook.presto.connector.system.SystemTablesMetadata;
import com.facebook.presto.execution.SplitSource;
import com.facebook.presto.execution.TaskId;
import com.facebook.presto.index.IndexManager;
import com.facebook.presto.metadata.ColumnHandle;
import com.facebook.presto.metadata.HandleResolver;
import com.facebook.presto.metadata.InMemoryNodeManager;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.metadata.OutputTableHandleResolver;
import com.facebook.presto.metadata.Partition;
import com.facebook.presto.metadata.PartitionResult;
import com.facebook.presto.metadata.QualifiedTableName;
import com.facebook.presto.metadata.QualifiedTablePrefix;
import com.facebook.presto.metadata.Split;
import com.facebook.presto.metadata.TableHandle;
import com.facebook.presto.operator.Driver;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.DriverFactory;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.OutputFactory;
import com.facebook.presto.operator.RecordSinkManager;
import com.facebook.presto.operator.TaskContext;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.Connector;
import com.facebook.presto.spi.ConnectorFactory;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.SystemTable;
import com.facebook.presto.spi.TupleDomain;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.split.DataStreamManager;
import com.facebook.presto.split.SplitManager;
import com.facebook.presto.sql.analyzer.Analysis;
import com.facebook.presto.sql.analyzer.Analyzer;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.sql.analyzer.QueryExplainer;
import com.facebook.presto.sql.gen.ExpressionCompiler;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.CompilerConfig;
import com.facebook.presto.sql.planner.DistributedLogicalPlanner;
import com.facebook.presto.sql.planner.LocalExecutionPlanner;
import com.facebook.presto.sql.planner.LogicalPlanner;
import com.facebook.presto.sql.planner.Plan;
import com.facebook.presto.sql.planner.PlanNodeIdAllocator;
import com.facebook.presto.sql.planner.PlanOptimizersFactory;
import com.facebook.presto.sql.planner.PlanPrinter;
import com.facebook.presto.sql.planner.SubPlan;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.sql.planner.plan.TableScanNode;
import com.facebook.presto.sql.planner.plan.ValuesNode;
import com.facebook.presto.sql.testing.TreeAssertions;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.Statement;
import com.facebook.presto.testing.MaterializedResult;
import com.facebook.presto.testing.MaterializingOperator;
import com.facebook.presto.testing.QueryRunner;
import com.facebook.presto.type.TypeRegistry;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import io.airlift.concurrent.Threads;
import io.airlift.node.NodeConfig;
import io.airlift.node.NodeInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicReference;
import org.intellij.lang.annotations.Language;

public class LocalQueryRunner
implements QueryRunner {
    private final ConnectorSession defaultSession;
    private final ExecutorService executor;
    private final InMemoryNodeManager nodeManager;
    private final TypeRegistry typeRegistry;
    private final MetadataManager metadata;
    private final SplitManager splitManager;
    private final DataStreamManager dataStreamProvider;
    private final IndexManager indexManager;
    private final RecordSinkManager recordSinkManager;
    private final ExpressionCompiler compiler;
    private final ConnectorManager connectorManager;
    private boolean printPlan;

    public LocalQueryRunner(ConnectorSession defaultSession) {
        this.defaultSession = (ConnectorSession)Preconditions.checkNotNull((Object)defaultSession, (Object)"defaultSession is null");
        this.executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"local-query-runner-%s"));
        this.nodeManager = new InMemoryNodeManager();
        this.typeRegistry = new TypeRegistry();
        this.metadata = new MetadataManager(new FeaturesConfig().setExperimentalSyntaxEnabled(true), this.typeRegistry);
        this.splitManager = new SplitManager();
        this.dataStreamProvider = new DataStreamManager();
        this.indexManager = new IndexManager();
        this.recordSinkManager = new RecordSinkManager();
        this.compiler = new ExpressionCompiler(this.metadata);
        SystemTablesMetadata systemTablesMetadata = new SystemTablesMetadata();
        SystemSplitManager systemSplitManager = new SystemSplitManager(this.nodeManager);
        SystemRecordSetProvider systemRecordSetProvider = new SystemRecordSetProvider();
        SystemTablesManager systemTablesManager = new SystemTablesManager(systemTablesMetadata, systemSplitManager, systemRecordSetProvider, (Set<SystemTable>)ImmutableSet.of());
        systemTablesManager.addTable(new NodesSystemTable(this.nodeManager));
        systemTablesManager.addTable(new CatalogSystemTable(this.metadata));
        this.connectorManager = new ConnectorManager(this.metadata, this.splitManager, this.dataStreamProvider, this.indexManager, this.recordSinkManager, new HandleResolver(), new OutputTableHandleResolver(), (Map<String, ConnectorFactory>)ImmutableMap.of(), (Map<String, Connector>)ImmutableMap.of((Object)"system", (Object)new SystemConnector(systemTablesMetadata, systemSplitManager, systemRecordSetProvider)), this.nodeManager);
    }

    @Override
    public void close() {
        this.executor.shutdownNow();
    }

    @Override
    public int getNodeCount() {
        return 1;
    }

    public InMemoryNodeManager getNodeManager() {
        return this.nodeManager;
    }

    public TypeRegistry getTypeManager() {
        return this.typeRegistry;
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public ExecutorService getExecutor() {
        return this.executor;
    }

    @Override
    public ConnectorSession getDefaultSession() {
        return this.defaultSession;
    }

    public void createCatalog(String catalogName, ConnectorFactory connectorFactory, Map<String, String> properties) {
        this.nodeManager.addCurrentNodeDatasource(catalogName);
        this.connectorManager.createConnection(catalogName, connectorFactory, properties);
    }

    public QueryRunner printPlan() {
        this.printPlan = true;
        return this;
    }

    @Override
    public List<QualifiedTableName> listTables(ConnectorSession session, String catalog, String schema) {
        return this.getMetadata().listTables(session, new QualifiedTablePrefix(catalog, schema));
    }

    @Override
    public boolean tableExists(ConnectorSession session, String table) {
        QualifiedTableName name = new QualifiedTableName(session.getCatalog(), session.getSchema(), table);
        Optional<TableHandle> handle = this.getMetadata().getTableHandle(session, name);
        return handle.isPresent();
    }

    @Override
    public MaterializedResult execute(@Language(value="SQL") String sql) {
        return this.execute(this.defaultSession, sql);
    }

    @Override
    public MaterializedResult execute(ConnectorSession session, @Language(value="SQL") String sql) {
        MaterializedOutputFactory outputFactory = new MaterializedOutputFactory();
        TaskContext taskContext = new TaskContext(new TaskId("query", "stage", "task"), this.executor, session);
        List<Driver> drivers = this.createDrivers(session, sql, outputFactory, taskContext);
        boolean done = false;
        while (!done) {
            boolean processed = false;
            for (Driver driver : drivers) {
                if (driver.isFinished()) continue;
                driver.process();
                processed = true;
            }
            done = !processed;
        }
        return outputFactory.getMaterializingOperator().getMaterializedResult();
    }

    public List<Driver> createDrivers(@Language(value="SQL") String sql, OutputFactory outputFactory, TaskContext taskContext) {
        return this.createDrivers(this.defaultSession, sql, outputFactory, taskContext);
    }

    public List<Driver> createDrivers(ConnectorSession session, @Language(value="SQL") String sql, OutputFactory outputFactory, TaskContext taskContext) {
        SubPlan subplan;
        Statement statement = SqlParser.createStatement((String)sql);
        TreeAssertions.assertFormattedSql((Node)statement);
        PlanNodeIdAllocator idAllocator = new PlanNodeIdAllocator();
        FeaturesConfig featuresConfig = new FeaturesConfig().setExperimentalSyntaxEnabled(true);
        PlanOptimizersFactory planOptimizersFactory = new PlanOptimizersFactory(this.metadata, this.splitManager, this.indexManager, featuresConfig);
        QueryExplainer queryExplainer = new QueryExplainer(session, (List<PlanOptimizer>)planOptimizersFactory.get(), this.metadata, featuresConfig.isExperimentalSyntaxEnabled());
        Analyzer analyzer = new Analyzer(session, this.metadata, (Optional<QueryExplainer>)Optional.of((Object)queryExplainer), featuresConfig.isExperimentalSyntaxEnabled());
        Analysis analysis = analyzer.analyze(statement);
        Plan plan = new LogicalPlanner(session, (List<PlanOptimizer>)planOptimizersFactory.get(), idAllocator, this.metadata).plan(analysis);
        if (this.printPlan) {
            System.out.println(PlanPrinter.textLogicalPlan(plan.getRoot(), plan.getTypes(), this.metadata));
        }
        if (!(subplan = new DistributedLogicalPlanner(session, this.metadata, idAllocator).createSubPlans(plan, true)).getChildren().isEmpty()) {
            throw new AssertionError((Object)"Expected subplan to have no children");
        }
        LocalExecutionPlanner executionPlanner = new LocalExecutionPlanner(new NodeInfo(new NodeConfig().setEnvironment("test").setNodeId("test-node")), this.metadata, this.dataStreamProvider, this.indexManager, this.recordSinkManager, null, this.compiler, new CompilerConfig().setInterpreterEnabled(false));
        LocalExecutionPlanner.LocalExecutionPlan localExecutionPlan = executionPlanner.plan(session, subplan.getFragment().getRoot(), plan.getTypes(), outputFactory);
        ArrayList<TaskSource> sources = new ArrayList<TaskSource>();
        long sequenceId = 0L;
        for (PlanNode sourceNode : subplan.getFragment().getSources()) {
            if (sourceNode instanceof ValuesNode) continue;
            TableScanNode tableScan = (TableScanNode)sourceNode;
            SplitSource splitSource = this.splitManager.getPartitionSplits(tableScan.getTable(), this.getPartitions(tableScan));
            ImmutableSet.Builder scheduledSplits = ImmutableSet.builder();
            while (!splitSource.isFinished()) {
                try {
                    for (Split split : splitSource.getNextBatch(1000)) {
                        scheduledSplits.add((Object)new ScheduledSplit(sequenceId++, split));
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw Throwables.propagate((Throwable)e);
                }
            }
            sources.add(new TaskSource(tableScan.getId(), (Set<ScheduledSplit>)scheduledSplits.build(), true));
        }
        ArrayList<Driver> drivers = new ArrayList<Driver>();
        HashMap<PlanNodeId, Driver> driversBySource = new HashMap<PlanNodeId, Driver>();
        for (DriverFactory driverFactory : localExecutionPlan.getDriverFactories()) {
            DriverContext driverContext = taskContext.addPipelineContext(driverFactory.isInputDriver(), driverFactory.isOutputDriver()).addDriverContext();
            Driver driver = driverFactory.createDriver(driverContext);
            drivers.add(driver);
            for (PlanNodeId sourceId : driver.getSourceIds()) {
                driversBySource.put(sourceId, driver);
            }
            driverFactory.close();
        }
        for (TaskSource source : sources) {
            for (Driver driver : driversBySource.values()) {
                driver.updateSource(source);
            }
        }
        return ImmutableList.copyOf(drivers);
    }

    private List<Partition> getPartitions(TableScanNode node) {
        if (node.getGeneratedPartitions().isPresent()) {
            return ((TableScanNode.GeneratedPartitions)node.getGeneratedPartitions().get()).getPartitions();
        }
        PartitionResult matchingPartitions = this.splitManager.getPartitions(node.getTable(), (Optional<TupleDomain<ColumnHandle>>)Optional.absent());
        return matchingPartitions.getPartitions();
    }

    public OperatorFactory createTableScanOperator(int operatorId, String tableName, String ... columnNames) {
        return this.createTableScanOperator(this.defaultSession, operatorId, tableName, columnNames);
    }

    public OperatorFactory createTableScanOperator(ConnectorSession session, int operatorId, String tableName, String ... columnNames) {
        TableHandle tableHandle = (TableHandle)this.metadata.getTableHandle(session, new QualifiedTableName(session.getCatalog(), session.getSchema(), tableName)).orNull();
        Preconditions.checkArgument((tableHandle != null ? 1 : 0) != 0, (String)"Table %s does not exist", (Object[])new Object[]{tableName});
        ImmutableList.Builder columnHandlesBuilder = ImmutableList.builder();
        ImmutableList.Builder columnTypesBuilder = ImmutableList.builder();
        for (String columnName : columnNames) {
            ColumnHandle columnHandle = (ColumnHandle)this.metadata.getColumnHandle(tableHandle, columnName).orNull();
            Preconditions.checkArgument((columnHandle != null ? 1 : 0) != 0, (String)"Table %s does not have a column %s", (Object[])new Object[]{tableName, columnName});
            columnHandlesBuilder.add((Object)columnHandle);
            ColumnMetadata columnMetadata = this.metadata.getColumnMetadata(tableHandle, columnHandle);
            columnTypesBuilder.add((Object)columnMetadata.getType());
        }
        ImmutableList columnHandles = columnHandlesBuilder.build();
        ImmutableList columnTypes = columnTypesBuilder.build();
        Split split = this.getLocalQuerySplit(tableHandle);
        return new OperatorFactory((List)columnTypes, operatorId, split, (List)columnHandles){
            final /* synthetic */ List val$columnTypes;
            final /* synthetic */ int val$operatorId;
            final /* synthetic */ Split val$split;
            final /* synthetic */ List val$columnHandles;
            {
                this.val$columnTypes = list;
                this.val$operatorId = n;
                this.val$split = split;
                this.val$columnHandles = list2;
            }

            @Override
            public List<Type> getTypes() {
                return this.val$columnTypes;
            }

            @Override
            public Operator createOperator(DriverContext driverContext) {
                OperatorContext operatorContext = driverContext.addOperatorContext(this.val$operatorId, "BenchmarkSource");
                return LocalQueryRunner.this.dataStreamProvider.createNewDataStream(operatorContext, this.val$split, this.val$columnHandles);
            }

            @Override
            public void close() {
            }
        };
    }

    private Split getLocalQuerySplit(TableHandle tableHandle) {
        try {
            List<Partition> partitions = this.splitManager.getPartitions(tableHandle, (Optional<TupleDomain<ColumnHandle>>)Optional.absent()).getPartitions();
            SplitSource splitSource = this.splitManager.getPartitionSplits(tableHandle, partitions);
            Split split = (Split)Iterables.getOnlyElement(splitSource.getNextBatch(1000));
            Preconditions.checkState((boolean)splitSource.isFinished(), (Object)"Expected only one split for a local query");
            return split;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw Throwables.propagate((Throwable)e);
        }
    }

    private static class MaterializedOutputFactory
    implements OutputFactory {
        private final AtomicReference<MaterializingOperator> materializingOperator = new AtomicReference();

        private MaterializedOutputFactory() {
        }

        private MaterializingOperator getMaterializingOperator() {
            MaterializingOperator operator = this.materializingOperator.get();
            Preconditions.checkState((operator != null ? 1 : 0) != 0, (Object)"Output not created");
            return operator;
        }

        @Override
        public OperatorFactory createOutputOperator(final int operatorId, final List<Type> sourceType) {
            Preconditions.checkNotNull(sourceType, (Object)"sourceType is null");
            return new OperatorFactory(){

                @Override
                public List<Type> getTypes() {
                    return ImmutableList.of();
                }

                @Override
                public Operator createOperator(DriverContext driverContext) {
                    OperatorContext operatorContext = driverContext.addOperatorContext(operatorId, MaterializingOperator.class.getSimpleName());
                    MaterializingOperator operator = new MaterializingOperator(operatorContext, sourceType);
                    if (!MaterializedOutputFactory.this.materializingOperator.compareAndSet(null, operator)) {
                        throw new IllegalArgumentException("Output already created");
                    }
                    return operator;
                }

                @Override
                public void close() {
                }
            };
        }
    }
}

