/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.plan;

import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.sql.planner.plan.PlanVisitor;
import com.facebook.presto.sql.tree.Expression;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.concurrent.Immutable;

@Immutable
public class ValuesNode
extends PlanNode {
    private final List<Symbol> outputSymbols;
    private final List<List<Expression>> rows;

    @JsonCreator
    public ValuesNode(@JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="outputSymbols") List<Symbol> outputSymbols, @JsonProperty(value="rows") List<List<Expression>> rows) {
        super(id);
        this.outputSymbols = ImmutableList.copyOf(outputSymbols);
        this.rows = ImmutableList.copyOf(rows);
        for (List<Expression> row : rows) {
            Preconditions.checkArgument((row.size() == outputSymbols.size() ? 1 : 0) != 0, (String)"Expected row to have %s values, but row has %s values", (Object[])new Object[]{outputSymbols.size(), row.size()});
        }
    }

    @Override
    @JsonProperty
    public List<Symbol> getOutputSymbols() {
        return this.outputSymbols;
    }

    @JsonProperty
    public List<List<Expression>> getRows() {
        return this.rows;
    }

    @Override
    public List<PlanNode> getSources() {
        return ImmutableList.of();
    }

    @Override
    public <C, R> R accept(PlanVisitor<C, R> visitor, C context) {
        return visitor.visitValues(this, context);
    }
}

