/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.analyzer.ExpressionAnalyzer;
import com.facebook.presto.sql.planner.ExpressionInterpreter;
import com.facebook.presto.sql.planner.LiteralInterpreter;
import com.facebook.presto.sql.planner.NoOpSymbolResolver;
import com.facebook.presto.sql.planner.PlanNodeIdAllocator;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.SymbolAllocator;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.planner.plan.FilterNode;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanNodeRewriter;
import com.facebook.presto.sql.planner.plan.PlanRewriter;
import com.facebook.presto.sql.planner.plan.ProjectNode;
import com.facebook.presto.sql.planner.plan.TableScanNode;
import com.facebook.presto.sql.tree.BooleanLiteral;
import com.facebook.presto.sql.tree.Expression;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.IdentityHashMap;
import java.util.Map;

public class SimplifyExpressions
extends PlanOptimizer {
    private final Metadata metadata;

    public SimplifyExpressions(Metadata metadata) {
        this.metadata = (Metadata)Preconditions.checkNotNull((Object)metadata, (Object)"metadata is null");
    }

    @Override
    public PlanNode optimize(PlanNode plan, ConnectorSession session, Map<Symbol, Type> types, SymbolAllocator symbolAllocator, PlanNodeIdAllocator idAllocator) {
        Preconditions.checkNotNull((Object)plan, (Object)"plan is null");
        Preconditions.checkNotNull((Object)session, (Object)"session is null");
        Preconditions.checkNotNull(types, (Object)"types is null");
        Preconditions.checkNotNull((Object)symbolAllocator, (Object)"symbolAllocator is null");
        Preconditions.checkNotNull((Object)idAllocator, (Object)"idAllocator is null");
        return PlanRewriter.rewriteWith(new Rewriter(this.metadata, session, types), plan);
    }

    private static class Rewriter
    extends PlanNodeRewriter<Void> {
        private final Metadata metadata;
        private final ConnectorSession session;
        private final Map<Symbol, Type> types;

        public Rewriter(Metadata metadata, ConnectorSession session, Map<Symbol, Type> types) {
            this.metadata = metadata;
            this.session = session;
            this.types = types;
        }

        @Override
        public PlanNode rewriteProject(ProjectNode node, Void context, PlanRewriter<Void> planRewriter) {
            PlanNode source = planRewriter.rewrite(node.getSource(), context);
            ImmutableMap assignments = ImmutableMap.copyOf((Map)Maps.transformValues(node.getOutputMap(), this.simplifyExpressionFunction()));
            return new ProjectNode(node.getId(), source, (Map<Symbol, Expression>)assignments);
        }

        @Override
        public PlanNode rewriteFilter(FilterNode node, Void context, PlanRewriter<Void> planRewriter) {
            PlanNode source = planRewriter.rewrite(node.getSource(), context);
            Expression simplified = this.simplifyExpression(node.getPredicate());
            if (simplified.equals((Object)BooleanLiteral.TRUE_LITERAL)) {
                return source;
            }
            return new FilterNode(node.getId(), source, simplified);
        }

        @Override
        public PlanNode rewriteTableScan(TableScanNode node, Void context, PlanRewriter<Void> planRewriter) {
            Expression originalConstraint = null;
            if (node.getOriginalConstraint() != null) {
                originalConstraint = this.simplifyExpression(node.getOriginalConstraint());
            }
            return new TableScanNode(node.getId(), node.getTable(), node.getOutputSymbols(), node.getAssignments(), originalConstraint, node.getSummarizedPartition());
        }

        private Function<Expression, Expression> simplifyExpressionFunction() {
            return new Function<Expression, Expression>(){

                public Expression apply(Expression input) {
                    return Rewriter.this.simplifyExpression(input);
                }
            };
        }

        private Expression simplifyExpression(Expression input) {
            IdentityHashMap<Expression, Type> expressionTypes = ExpressionAnalyzer.getExpressionTypes(this.session, this.metadata, this.types, input);
            ExpressionInterpreter interpreter = ExpressionInterpreter.expressionOptimizer(input, this.metadata, this.session, expressionTypes);
            return LiteralInterpreter.toExpression(interpreter.optimize(NoOpSymbolResolver.INSTANCE), expressionTypes.get(input));
        }
    }
}

