/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.ExpressionRewriter;
import com.facebook.presto.sql.tree.ExpressionTreeRewriter;
import com.facebook.presto.sql.tree.Input;
import com.facebook.presto.sql.tree.InputReference;
import com.facebook.presto.sql.tree.QualifiedNameReference;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;

public class SymbolToInputRewriter
extends ExpressionRewriter<Void> {
    private final Map<Symbol, Input> symbolToInputMapping;

    public SymbolToInputRewriter(Map<Symbol, Input> symbolToInputMapping) {
        Preconditions.checkNotNull(symbolToInputMapping, (Object)"symbolToInputMapping is null");
        this.symbolToInputMapping = ImmutableMap.copyOf(symbolToInputMapping);
    }

    public Expression rewriteQualifiedNameReference(QualifiedNameReference node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
        Input input = this.symbolToInputMapping.get(Symbol.fromQualifiedName(node.getName()));
        Preconditions.checkArgument((input != null ? 1 : 0) != 0, (String)"Cannot resolve symbol %s", (Object[])new Object[]{node.getName()});
        return new InputReference(input);
    }
}

