/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.block.BlockUtils;
import com.facebook.presto.index.IndexManager;
import com.facebook.presto.metadata.ColumnHandle;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.operator.AggregationFunctionDefinition;
import com.facebook.presto.operator.AggregationOperator;
import com.facebook.presto.operator.DistinctLimitOperator;
import com.facebook.presto.operator.DriverFactory;
import com.facebook.presto.operator.ExchangeClient;
import com.facebook.presto.operator.ExchangeOperator;
import com.facebook.presto.operator.FilterAndProjectOperator;
import com.facebook.presto.operator.FilterFunction;
import com.facebook.presto.operator.FilterFunctions;
import com.facebook.presto.operator.HashAggregationOperator;
import com.facebook.presto.operator.HashBuilderOperator;
import com.facebook.presto.operator.HashSemiJoinOperator;
import com.facebook.presto.operator.InMemoryExchange;
import com.facebook.presto.operator.InMemoryExchangeSourceOperator;
import com.facebook.presto.operator.LimitOperator;
import com.facebook.presto.operator.LookupJoinOperators;
import com.facebook.presto.operator.LookupSourceSupplier;
import com.facebook.presto.operator.MarkDistinctOperator;
import com.facebook.presto.operator.MaterializeSampleOperator;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.OrderByOperator;
import com.facebook.presto.operator.OutputFactory;
import com.facebook.presto.operator.Page;
import com.facebook.presto.operator.PageBuilder;
import com.facebook.presto.operator.ProjectionFunction;
import com.facebook.presto.operator.ProjectionFunctions;
import com.facebook.presto.operator.RecordSinkManager;
import com.facebook.presto.operator.SampleOperator;
import com.facebook.presto.operator.ScanFilterAndProjectOperator;
import com.facebook.presto.operator.SetBuilderOperator;
import com.facebook.presto.operator.TableCommitOperator;
import com.facebook.presto.operator.TableScanOperator;
import com.facebook.presto.operator.TableWriterOperator;
import com.facebook.presto.operator.TopNOperator;
import com.facebook.presto.operator.ValuesOperator;
import com.facebook.presto.operator.WindowFunctionDefinition;
import com.facebook.presto.operator.WindowOperator;
import com.facebook.presto.operator.index.FieldSetFilteringRecordSet;
import com.facebook.presto.operator.index.IndexLookupSourceSupplier;
import com.facebook.presto.operator.index.IndexSourceOperator;
import com.facebook.presto.operator.index.PagesIndexBuilderOperator;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.Index;
import com.facebook.presto.spi.RecordSet;
import com.facebook.presto.spi.RecordSink;
import com.facebook.presto.spi.block.BlockCursor;
import com.facebook.presto.spi.block.SortOrder;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.split.DataStreamProvider;
import com.facebook.presto.split.MappedRecordSet;
import com.facebook.presto.sql.analyzer.ExpressionAnalyzer;
import com.facebook.presto.sql.gen.ExpressionCompiler;
import com.facebook.presto.sql.planner.CompilerConfig;
import com.facebook.presto.sql.planner.ExpressionInterpreter;
import com.facebook.presto.sql.planner.InterpretedFilterFunction;
import com.facebook.presto.sql.planner.InterpretedProjectionFunction;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.SymbolToInputRewriter;
import com.facebook.presto.sql.planner.optimizations.IndexJoinOptimizer;
import com.facebook.presto.sql.planner.plan.AggregationNode;
import com.facebook.presto.sql.planner.plan.DistinctLimitNode;
import com.facebook.presto.sql.planner.plan.ExchangeNode;
import com.facebook.presto.sql.planner.plan.FilterNode;
import com.facebook.presto.sql.planner.plan.IndexJoinNode;
import com.facebook.presto.sql.planner.plan.IndexSourceNode;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.LimitNode;
import com.facebook.presto.sql.planner.plan.MarkDistinctNode;
import com.facebook.presto.sql.planner.plan.MaterializeSampleNode;
import com.facebook.presto.sql.planner.plan.OutputNode;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanVisitor;
import com.facebook.presto.sql.planner.plan.ProjectNode;
import com.facebook.presto.sql.planner.plan.SampleNode;
import com.facebook.presto.sql.planner.plan.SemiJoinNode;
import com.facebook.presto.sql.planner.plan.SinkNode;
import com.facebook.presto.sql.planner.plan.SortNode;
import com.facebook.presto.sql.planner.plan.TableCommitNode;
import com.facebook.presto.sql.planner.plan.TableScanNode;
import com.facebook.presto.sql.planner.plan.TableWriterNode;
import com.facebook.presto.sql.planner.plan.TopNNode;
import com.facebook.presto.sql.planner.plan.UnionNode;
import com.facebook.presto.sql.planner.plan.ValuesNode;
import com.facebook.presto.sql.planner.plan.WindowNode;
import com.facebook.presto.sql.tree.BooleanLiteral;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.ExpressionRewriter;
import com.facebook.presto.sql.tree.ExpressionTreeRewriter;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.Input;
import com.facebook.presto.sql.tree.QualifiedNameReference;
import com.facebook.presto.util.IterableTransformer;
import com.facebook.presto.util.MoreFunctions;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Ordering;
import com.google.common.collect.SetMultimap;
import io.airlift.log.Logger;
import io.airlift.node.NodeInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.validation.constraints.NotNull;

public class LocalExecutionPlanner {
    private static final Logger log = Logger.get(LocalExecutionPlanner.class);
    private final NodeInfo nodeInfo;
    private final Metadata metadata;
    private final DataStreamProvider dataStreamProvider;
    private final IndexManager indexManager;
    private final RecordSinkManager recordSinkManager;
    private final Supplier<ExchangeClient> exchangeClientSupplier;
    private final ExpressionCompiler compiler;
    private final boolean interpreterEnabled;

    @Inject
    public LocalExecutionPlanner(NodeInfo nodeInfo, Metadata metadata, DataStreamProvider dataStreamProvider, IndexManager indexManager, RecordSinkManager recordSinkManager, Supplier<ExchangeClient> exchangeClientSupplier, ExpressionCompiler compiler, CompilerConfig config) {
        Preconditions.checkNotNull((Object)config, (Object)"config is null");
        this.nodeInfo = (NodeInfo)Preconditions.checkNotNull((Object)nodeInfo, (Object)"nodeInfo is null");
        this.dataStreamProvider = dataStreamProvider;
        this.indexManager = (IndexManager)Preconditions.checkNotNull((Object)indexManager, (Object)"indexManager is null");
        this.exchangeClientSupplier = exchangeClientSupplier;
        this.metadata = (Metadata)Preconditions.checkNotNull((Object)metadata, (Object)"metadata is null");
        this.recordSinkManager = (RecordSinkManager)Preconditions.checkNotNull((Object)recordSinkManager, (Object)"recordSinkManager is null");
        this.compiler = (ExpressionCompiler)Preconditions.checkNotNull((Object)compiler, (Object)"compiler is null");
        this.interpreterEnabled = config.isInterpreterEnabled();
    }

    public LocalExecutionPlan plan(ConnectorSession session, PlanNode plan, Map<Symbol, Type> types, OutputFactory outputOperatorFactory) {
        LocalExecutionPlanContext context = new LocalExecutionPlanContext(session, types);
        PhysicalOperation physicalOperation = plan.accept(new Visitor(session), context);
        DriverFactory driverFactory = new DriverFactory(context.isInputDriver(), true, (List<OperatorFactory>)ImmutableList.builder().addAll((Iterable)physicalOperation.getOperatorFactories()).add((Object)outputOperatorFactory.createOutputOperator(context.getNextOperatorId(), physicalOperation.getTypes())).build());
        context.addDriverFactory(driverFactory);
        return new LocalExecutionPlan(context.getDriverFactories());
    }

    private static TableCommitOperator.TableCommitter createTableCommitter(final TableCommitNode node, final Metadata metadata) {
        return new TableCommitOperator.TableCommitter(){

            @Override
            public void commitTable(Collection<String> fragments) {
                metadata.commitCreateTable(node.getTarget(), fragments);
            }
        };
    }

    private static IdentityProjectionInfo computeIdentityMapping(List<Symbol> symbols, Map<Symbol, Input> inputLayout, Map<Symbol, Type> types) {
        HashMap<Symbol, Input> outputMappings = new HashMap<Symbol, Input>();
        ArrayList<ProjectionFunction> projections = new ArrayList<ProjectionFunction>();
        int channel = 0;
        for (Symbol symbol : symbols) {
            ProjectionFunction function = ProjectionFunctions.singleColumn(types.get(symbol), inputLayout.get(symbol));
            projections.add(function);
            if (outputMappings.containsKey(symbol)) continue;
            outputMappings.put(symbol, new Input(channel));
            ++channel;
        }
        return new IdentityProjectionInfo((Map<Symbol, Input>)ImmutableMap.copyOf(outputMappings), projections);
    }

    private static List<Integer> getChannelsForSymbols(List<Symbol> symbols, Map<Symbol, Input> layout) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Symbol symbol : symbols) {
            builder.add((Object)layout.get(symbol).getChannel());
        }
        return builder.build();
    }

    private static Ordering<Input> inputOrdering() {
        return Ordering.from((Comparator)new Comparator<Input>(){

            @Override
            public int compare(Input o1, Input o2) {
                return ComparisonChain.start().compare(o1.getChannel(), o2.getChannel()).result();
            }
        });
    }

    private static class PhysicalOperation {
        private final List<OperatorFactory> operatorFactories;
        private final Map<Symbol, Input> layout;
        private final List<Type> types;

        public PhysicalOperation(OperatorFactory operatorFactory, Map<Symbol, Input> layout) {
            Preconditions.checkNotNull((Object)operatorFactory, (Object)"operatorFactory is null");
            Preconditions.checkNotNull(layout, (Object)"layout is null");
            this.operatorFactories = ImmutableList.of((Object)operatorFactory);
            this.layout = ImmutableMap.copyOf(layout);
            this.types = operatorFactory.getTypes();
        }

        public PhysicalOperation(OperatorFactory operatorFactory, Map<Symbol, Input> layout, PhysicalOperation source) {
            Preconditions.checkNotNull((Object)operatorFactory, (Object)"operatorFactory is null");
            Preconditions.checkNotNull(layout, (Object)"layout is null");
            Preconditions.checkNotNull((Object)source, (Object)"source is null");
            this.operatorFactories = ImmutableList.builder().addAll(source.getOperatorFactories()).add((Object)operatorFactory).build();
            this.layout = ImmutableMap.copyOf(layout);
            this.types = operatorFactory.getTypes();
        }

        public Function<Symbol, Integer> channelGetter() {
            return new Function<Symbol, Integer>(){

                @NotNull
                public Integer apply(Symbol input) {
                    Preconditions.checkArgument((boolean)PhysicalOperation.this.layout.containsKey(input));
                    return ((Input)PhysicalOperation.this.layout.get(input)).getChannel();
                }
            };
        }

        public List<Type> getTypes() {
            return this.types;
        }

        public Map<Symbol, Input> getLayout() {
            return this.layout;
        }

        private List<OperatorFactory> getOperatorFactories() {
            return this.operatorFactories;
        }
    }

    private static class IdentityProjectionInfo {
        private final Map<Symbol, Input> layout;
        private final List<ProjectionFunction> projections;

        public IdentityProjectionInfo(Map<Symbol, Input> outputLayout, List<ProjectionFunction> projections) {
            this.layout = (Map)Preconditions.checkNotNull(outputLayout, (Object)"outputLayout is null");
            this.projections = (List)Preconditions.checkNotNull(projections, (Object)"projections is null");
        }

        public Map<Symbol, Input> getOutputLayout() {
            return this.layout;
        }

        public List<ProjectionFunction> getProjections() {
            return this.projections;
        }
    }

    private class Visitor
    extends PlanVisitor<LocalExecutionPlanContext, PhysicalOperation> {
        private final ConnectorSession session;

        private Visitor(ConnectorSession session) {
            this.session = session;
        }

        @Override
        public PhysicalOperation visitExchange(ExchangeNode node, LocalExecutionPlanContext context) {
            List<Type> types = this.getSourceOperatorTypes(node, context.getTypes());
            ExchangeOperator.ExchangeOperatorFactory operatorFactory = new ExchangeOperator.ExchangeOperatorFactory(context.getNextOperatorId(), node.getId(), (Supplier<ExchangeClient>)LocalExecutionPlanner.this.exchangeClientSupplier, types);
            ImmutableMap.Builder outputMappings = ImmutableMap.builder();
            int channel = 0;
            for (Symbol symbol : node.getOutputSymbols()) {
                outputMappings.put((Object)symbol, (Object)new Input(channel));
                ++channel;
            }
            return new PhysicalOperation(operatorFactory, (Map<Symbol, Input>)outputMappings.build());
        }

        @Override
        public PhysicalOperation visitOutput(OutputNode node, LocalExecutionPlanContext context) {
            PhysicalOperation source = node.getSource().accept(this, context);
            Ordering comparator = LocalExecutionPlanner.inputOrdering();
            List sourceSymbols = IterableTransformer.on(source.getLayout().entrySet()).orderBy((Comparator<Map.Entry<Symbol, Input>>)comparator.onResultOf(MoreFunctions.valueGetter())).transform(MoreFunctions.keyGetter()).list();
            List<Symbol> resultSymbols = node.getOutputSymbols();
            if (resultSymbols.equals(sourceSymbols) && resultSymbols.size() == source.getTypes().size()) {
                return source;
            }
            IdentityProjectionInfo mappings = LocalExecutionPlanner.computeIdentityMapping(resultSymbols, source.getLayout(), context.getTypes());
            FilterAndProjectOperator.FilterAndProjectOperatorFactory operatorFactory = new FilterAndProjectOperator.FilterAndProjectOperatorFactory(context.getNextOperatorId(), FilterFunctions.TRUE_FUNCTION, mappings.getProjections());
            return new PhysicalOperation(operatorFactory, mappings.getOutputLayout(), source);
        }

        @Override
        public PhysicalOperation visitWindow(WindowNode node, LocalExecutionPlanContext context) {
            PhysicalOperation source = node.getSource().accept(this, context);
            List<Symbol> partitionBySymbols = node.getPartitionBy();
            List<Symbol> orderBySymbols = node.getOrderBy();
            ImmutableList.Builder partitionChannels = ImmutableList.builder();
            for (Symbol symbol : partitionBySymbols) {
                partitionChannels.add((Object)source.getLayout().get(symbol).getChannel());
            }
            ImmutableList.Builder sortChannels = ImmutableList.builder();
            ImmutableList.Builder sortOrder = ImmutableList.builder();
            for (Symbol symbol : orderBySymbols) {
                sortChannels.add((Object)source.getLayout().get(symbol).getChannel());
                sortOrder.add((Object)node.getOrderings().get(symbol));
            }
            ImmutableList.Builder outputChannels = ImmutableList.builder();
            for (int i = 0; i < source.getTypes().size(); ++i) {
                outputChannels.add((Object)i);
            }
            ImmutableList.Builder windowFunctions = ImmutableList.builder();
            ArrayList<Symbol> windowFunctionOutputSymbols = new ArrayList<Symbol>();
            for (Map.Entry<Symbol, FunctionCall> entry : node.getWindowFunctions().entrySet()) {
                ImmutableList.Builder arguments = ImmutableList.builder();
                for (Expression argument : entry.getValue().getArguments()) {
                    Symbol argumentSymbol = Symbol.fromQualifiedName(((QualifiedNameReference)argument).getName());
                    arguments.add((Object)source.getLayout().get(argumentSymbol));
                }
                Symbol symbol = entry.getKey();
                Signature signature = node.getSignatures().get(symbol);
                windowFunctions.add((Object)LocalExecutionPlanner.this.metadata.getExactFunction(signature).bindWindowFunction((List<Input>)arguments.build()));
                windowFunctionOutputSymbols.add(symbol);
            }
            ImmutableMap.Builder outputMappings = ImmutableMap.builder();
            for (Symbol symbol : node.getSource().getOutputSymbols()) {
                outputMappings.put((Object)symbol, (Object)source.getLayout().get(symbol));
            }
            int channel = source.getTypes().size();
            for (Symbol symbol : windowFunctionOutputSymbols) {
                outputMappings.put((Object)symbol, (Object)new Input(channel));
                ++channel;
            }
            WindowOperator.WindowOperatorFactory operatorFactory = new WindowOperator.WindowOperatorFactory(context.getNextOperatorId(), source.getTypes(), (List<Integer>)outputChannels.build(), (List<WindowFunctionDefinition>)windowFunctions.build(), (List<Integer>)partitionChannels.build(), (List<Integer>)sortChannels.build(), (List<SortOrder>)sortOrder.build(), 1000000);
            return new PhysicalOperation(operatorFactory, (Map<Symbol, Input>)outputMappings.build(), source);
        }

        @Override
        public PhysicalOperation visitTopN(TopNNode node, LocalExecutionPlanContext context) {
            PhysicalOperation source = node.getSource().accept(this, context);
            List<Symbol> orderBySymbols = node.getOrderBy();
            ArrayList<Integer> sortChannels = new ArrayList<Integer>();
            ArrayList<SortOrder> sortOrders = new ArrayList<SortOrder>();
            for (Symbol symbol : orderBySymbols) {
                sortChannels.add(source.getLayout().get(symbol).getChannel());
                sortOrders.add(node.getOrderings().get(symbol));
            }
            Optional sampleWeightChannel = node.getSampleWeight().transform(source.channelGetter());
            TopNOperator.TopNOperatorFactory operator = new TopNOperator.TopNOperatorFactory(context.getNextOperatorId(), source.getTypes(), (int)node.getCount(), sortChannels, sortOrders, (Optional<Integer>)sampleWeightChannel, node.isPartial());
            return new PhysicalOperation(operator, source.getLayout(), source);
        }

        @Override
        public PhysicalOperation visitSort(SortNode node, LocalExecutionPlanContext context) {
            PhysicalOperation source = node.getSource().accept(this, context);
            List<Symbol> orderBySymbols = node.getOrderBy();
            List orderByChannels = LocalExecutionPlanner.getChannelsForSymbols(orderBySymbols, source.getLayout());
            ImmutableList.Builder sortOrder = ImmutableList.builder();
            for (Symbol symbol : orderBySymbols) {
                sortOrder.add((Object)node.getOrderings().get(symbol));
            }
            ImmutableList.Builder outputChannels = ImmutableList.builder();
            for (int i = 0; i < source.getTypes().size(); ++i) {
                outputChannels.add((Object)i);
            }
            OrderByOperator.OrderByOperatorFactory operator = new OrderByOperator.OrderByOperatorFactory(context.getNextOperatorId(), source.getTypes(), (List<Integer>)outputChannels.build(), 10000, orderByChannels, (List<SortOrder>)sortOrder.build());
            return new PhysicalOperation(operator, source.getLayout(), source);
        }

        @Override
        public PhysicalOperation visitLimit(LimitNode node, LocalExecutionPlanContext context) {
            PhysicalOperation source = node.getSource().accept(this, context);
            Optional sampleWeightChannel = node.getSampleWeight().transform(source.channelGetter());
            LimitOperator.LimitOperatorFactory operatorFactory = new LimitOperator.LimitOperatorFactory(context.getNextOperatorId(), source.getTypes(), node.getCount(), (Optional<Integer>)sampleWeightChannel);
            return new PhysicalOperation(operatorFactory, source.getLayout(), source);
        }

        @Override
        public PhysicalOperation visitDistinctLimit(DistinctLimitNode node, LocalExecutionPlanContext context) {
            PhysicalOperation source = node.getSource().accept(this, context);
            DistinctLimitOperator.DistinctLimitOperatorFactory operatorFactory = new DistinctLimitOperator.DistinctLimitOperatorFactory(context.getNextOperatorId(), source.getTypes(), node.getLimit());
            return new PhysicalOperation(operatorFactory, source.getLayout(), source);
        }

        @Override
        public PhysicalOperation visitAggregation(AggregationNode node, LocalExecutionPlanContext context) {
            PhysicalOperation source = node.getSource().accept(this, context);
            if (node.getGroupBy().isEmpty()) {
                return this.planGlobalAggregation(context.getNextOperatorId(), node, source);
            }
            return this.planGroupByAggregation(node, source, context);
        }

        @Override
        public PhysicalOperation visitMarkDistinct(MarkDistinctNode node, LocalExecutionPlanContext context) {
            PhysicalOperation source = node.getSource().accept(this, context);
            List channels = LocalExecutionPlanner.getChannelsForSymbols(node.getDistinctSymbols(), source.getLayout());
            ImmutableMap outputMappings = ImmutableMap.builder().putAll(source.getLayout()).put((Object)node.getMarkerSymbol(), (Object)new Input(source.getLayout().size())).build();
            Optional sampleWeightChannel = node.getSampleWeightSymbol().transform(source.channelGetter());
            MarkDistinctOperator.MarkDistinctOperatorFactory operator = new MarkDistinctOperator.MarkDistinctOperatorFactory(context.getNextOperatorId(), source.getTypes(), channels, (Optional<Integer>)sampleWeightChannel);
            return new PhysicalOperation(operator, (Map<Symbol, Input>)outputMappings, source);
        }

        @Override
        public PhysicalOperation visitMaterializeSample(MaterializeSampleNode node, LocalExecutionPlanContext context) {
            PhysicalOperation source = node.getSource().accept(this, context);
            int sampleWeightChannel = (Integer)Iterables.getOnlyElement((Iterable)LocalExecutionPlanner.getChannelsForSymbols((List)ImmutableList.of((Object)node.getSampleWeightSymbol()), source.getLayout()));
            ImmutableMap.Builder outputMappings = ImmutableMap.builder();
            for (Map.Entry<Symbol, Input> entry : source.getLayout().entrySet()) {
                int value = entry.getValue().getChannel();
                if (value == sampleWeightChannel) continue;
                outputMappings.put((Object)entry.getKey(), (Object)new Input(value > sampleWeightChannel ? value - 1 : value));
            }
            ArrayList<Type> types = new ArrayList<Type>();
            types.addAll(source.getTypes());
            types.remove(sampleWeightChannel);
            MaterializeSampleOperator.MaterializeSampleOperatorFactory operator = new MaterializeSampleOperator.MaterializeSampleOperatorFactory(context.getNextOperatorId(), types, sampleWeightChannel);
            return new PhysicalOperation(operator, (Map<Symbol, Input>)outputMappings.build(), source);
        }

        @Override
        public PhysicalOperation visitSample(SampleNode node, LocalExecutionPlanContext context) {
            if (node.getSampleType() == SampleNode.Type.SYSTEM) {
                return node.getSource().accept(this, context);
            }
            if (node.getSampleType() == SampleNode.Type.POISSONIZED) {
                PhysicalOperation source = node.getSource().accept(this, context);
                SampleOperator.SampleOperatorFactory operatorFactory = new SampleOperator.SampleOperatorFactory(context.getNextOperatorId(), node.getSampleRatio(), node.isRescaled(), source.getTypes());
                Preconditions.checkState((boolean)node.getSampleWeightSymbol().isPresent(), (Object)"sample weight symbol missing");
                ImmutableMap layout = ImmutableMap.builder().putAll(source.getLayout()).put(node.getSampleWeightSymbol().get(), (Object)new Input(source.getTypes().size())).build();
                return new PhysicalOperation(operatorFactory, (Map<Symbol, Input>)layout, source);
            }
            throw new UnsupportedOperationException("not yet implemented: " + node);
        }

        @Override
        public PhysicalOperation visitFilter(FilterNode node, LocalExecutionPlanContext context) {
            PlanNode sourceNode = node.getSource();
            Expression filterExpression = node.getPredicate();
            ArrayList<Expression> projectionExpressions = new ArrayList<Expression>();
            for (int i = 0; i < node.getOutputSymbols().size(); ++i) {
                Symbol symbol = node.getOutputSymbols().get(i);
                projectionExpressions.add((Expression)new QualifiedNameReference(symbol.toQualifiedName()));
            }
            List<Symbol> outputSymbols = node.getOutputSymbols();
            return this.visitScanFilterAndProject(context, sourceNode, filterExpression, projectionExpressions, outputSymbols);
        }

        @Override
        public PhysicalOperation visitProject(ProjectNode node, LocalExecutionPlanContext context) {
            BooleanLiteral filterExpression;
            PlanNode sourceNode;
            if (node.getSource() instanceof FilterNode) {
                FilterNode filterNode = (FilterNode)node.getSource();
                sourceNode = filterNode.getSource();
                filterExpression = filterNode.getPredicate();
            } else {
                sourceNode = node.getSource();
                filterExpression = BooleanLiteral.TRUE_LITERAL;
            }
            List<Expression> projectionExpressions = node.getExpressions();
            List<Symbol> outputSymbols = node.getOutputSymbols();
            return this.visitScanFilterAndProject(context, sourceNode, (Expression)filterExpression, projectionExpressions, outputSymbols);
        }

        private PhysicalOperation visitScanFilterAndProject(LocalExecutionPlanContext context, PlanNode sourceNode, Expression filterExpression, List<Expression> projectionExpressions, List<Symbol> outputSymbols) {
            LinkedHashMap<Input, Type> sourceTypes;
            LinkedHashMap<Symbol, Input> sourceLayout;
            ArrayList<ColumnHandle> columns = null;
            PhysicalOperation source = null;
            if (sourceNode instanceof TableScanNode) {
                TableScanNode tableScanNode = (TableScanNode)sourceNode;
                sourceLayout = new LinkedHashMap();
                sourceTypes = new LinkedHashMap();
                columns = new ArrayList<ColumnHandle>();
                int channel = 0;
                for (Symbol symbol : tableScanNode.getOutputSymbols()) {
                    columns.add(tableScanNode.getAssignments().get(symbol));
                    Input input = new Input(channel);
                    sourceLayout.put(symbol, input);
                    Type type = (Type)Preconditions.checkNotNull((Object)context.getTypes().get(symbol), (String)"No type for symbol %s", (Object[])new Object[]{symbol});
                    sourceTypes.put(input, type);
                    ++channel;
                }
            } else {
                source = sourceNode.accept(this, context);
                sourceLayout = source.getLayout();
                sourceTypes = this.getInputTypes(source.getLayout(), source.getTypes());
            }
            ImmutableMap.Builder outputMappingsBuilder = ImmutableMap.builder();
            for (int i = 0; i < outputSymbols.size(); ++i) {
                Symbol symbol = outputSymbols.get(i);
                outputMappingsBuilder.put((Object)symbol, (Object)new Input(i));
            }
            ImmutableMap outputMappings = outputMappingsBuilder.build();
            try {
                OperatorFactory operatorFactory;
                SymbolToInputRewriter symbolToInputRewriter = new SymbolToInputRewriter(sourceLayout);
                Expression rewrittenFilter = ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)symbolToInputRewriter, (Expression)filterExpression);
                ArrayList<Expression> rewrittenProjections = new ArrayList<Expression>();
                ArrayList<Type> outputTypes = new ArrayList<Type>();
                for (int i = 0; i < projectionExpressions.size(); ++i) {
                    Expression projection = projectionExpressions.get(i);
                    rewrittenProjections.add(ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)symbolToInputRewriter, (Expression)projection));
                    outputTypes.add(context.getTypes().get(outputSymbols.get(i)));
                }
                IdentityHashMap<Expression, Type> expressionTypes = ExpressionAnalyzer.getExpressionTypesFromInput(context.getSession(), LocalExecutionPlanner.this.metadata, sourceTypes, Iterables.concat(Collections.singleton(rewrittenFilter), rewrittenProjections));
                if (columns != null) {
                    operatorFactory = LocalExecutionPlanner.this.compiler.compileScanFilterAndProjectOperator(context.getNextOperatorId(), sourceNode.getId(), LocalExecutionPlanner.this.dataStreamProvider, columns, rewrittenFilter, rewrittenProjections, expressionTypes, this.session.getTimeZoneKey());
                    return new PhysicalOperation(operatorFactory, (Map<Symbol, Input>)outputMappings);
                }
                operatorFactory = LocalExecutionPlanner.this.compiler.compileFilterAndProjectOperator(context.getNextOperatorId(), rewrittenFilter, rewrittenProjections, expressionTypes, this.session.getTimeZoneKey());
                return new PhysicalOperation(operatorFactory, (Map<Symbol, Input>)outputMappings, source);
            }
            catch (RuntimeException e) {
                OperatorFactory operatorFactory;
                if (!LocalExecutionPlanner.this.interpreterEnabled) {
                    throw e;
                }
                log.error((Throwable)e, "Compile failed for filter=%s projections=%s sourceTypes=%s error=%s", new Object[]{filterExpression, projectionExpressions, sourceTypes, e});
                FilterFunction filterFunction = filterExpression != BooleanLiteral.TRUE_LITERAL ? new InterpretedFilterFunction(filterExpression, context.getTypes(), sourceLayout, LocalExecutionPlanner.this.metadata, context.getSession()) : FilterFunctions.TRUE_FUNCTION;
                ArrayList<InterpretedProjectionFunction> projectionFunctions = new ArrayList<InterpretedProjectionFunction>();
                for (Expression expression : projectionExpressions) {
                    ProjectionFunction function;
                    if (expression instanceof QualifiedNameReference) {
                        Symbol reference = Symbol.fromQualifiedName(((QualifiedNameReference)expression).getName());
                        function = ProjectionFunctions.singleColumn(context.getTypes().get(reference), (Input)sourceLayout.get(reference));
                    } else {
                        function = new InterpretedProjectionFunction(expression, context.getTypes(), sourceLayout, LocalExecutionPlanner.this.metadata, context.getSession());
                    }
                    projectionFunctions.add((InterpretedProjectionFunction)function);
                }
                if (columns != null) {
                    operatorFactory = new ScanFilterAndProjectOperator.ScanFilterAndProjectOperatorFactory(context.getNextOperatorId(), sourceNode.getId(), LocalExecutionPlanner.this.dataStreamProvider, columns, filterFunction, projectionFunctions);
                    return new PhysicalOperation(operatorFactory, (Map<Symbol, Input>)outputMappings);
                }
                operatorFactory = new FilterAndProjectOperator.FilterAndProjectOperatorFactory(context.getNextOperatorId(), filterFunction, projectionFunctions);
                return new PhysicalOperation(operatorFactory, (Map<Symbol, Input>)outputMappings, source);
            }
        }

        private Map<Input, Type> getInputTypes(Map<Symbol, Input> layout, List<Type> types) {
            ImmutableMap.Builder inputTypes = ImmutableMap.builder();
            for (Input input : ImmutableSet.copyOf(layout.values())) {
                Type type = types.get(input.getChannel());
                inputTypes.put((Object)input, (Object)type);
            }
            return inputTypes.build();
        }

        @Override
        public PhysicalOperation visitTableScan(TableScanNode node, LocalExecutionPlanContext context) {
            ImmutableMap.Builder outputMappings = ImmutableMap.builder();
            ArrayList<ColumnHandle> columns = new ArrayList<ColumnHandle>();
            int channel = 0;
            for (Symbol symbol : node.getOutputSymbols()) {
                columns.add(node.getAssignments().get(symbol));
                outputMappings.put((Object)symbol, (Object)new Input(channel));
                ++channel;
            }
            List<Type> types = this.getSourceOperatorTypes(node, context.getTypes());
            TableScanOperator.TableScanOperatorFactory operatorFactory = new TableScanOperator.TableScanOperatorFactory(context.getNextOperatorId(), node.getId(), LocalExecutionPlanner.this.dataStreamProvider, types, columns);
            return new PhysicalOperation(operatorFactory, (Map<Symbol, Input>)outputMappings.build());
        }

        @Override
        public PhysicalOperation visitValues(ValuesNode node, LocalExecutionPlanContext context) {
            LinkedHashMap<Symbol, Input> outputMappings = new LinkedHashMap<Symbol, Input>();
            ArrayList<Type> outputTypes = new ArrayList<Type>();
            int channel = 0;
            for (Symbol symbol : node.getOutputSymbols()) {
                Input input = new Input(channel);
                outputMappings.put(symbol, input);
                Type type = (Type)Preconditions.checkNotNull((Object)context.getTypes().get(symbol), (String)"No type for symbol %s", (Object[])new Object[]{symbol});
                outputTypes.add(type);
                ++channel;
            }
            PageBuilder pageBuilder = new PageBuilder(outputTypes);
            for (List<Expression> row : node.getRows()) {
                pageBuilder.declarePosition();
                IdentityHashMap<Expression, Type> expressionTypes = ExpressionAnalyzer.getExpressionTypes(context.getSession(), LocalExecutionPlanner.this.metadata, (Map<Symbol, Type>)ImmutableMap.of(), (Iterable<? extends Expression>)ImmutableList.copyOf(row));
                for (int i = 0; i < row.size(); ++i) {
                    Object result = ExpressionInterpreter.expressionInterpreter(row.get(i), LocalExecutionPlanner.this.metadata, context.getSession(), expressionTypes).evaluate(new BlockCursor[0]);
                    BlockUtils.appendObject(pageBuilder.getBlockBuilder(i), result);
                }
            }
            ValuesOperator.ValuesOperatorFactory operatorFactory = new ValuesOperator.ValuesOperatorFactory(context.getNextOperatorId(), (List<Page>)ImmutableList.of((Object)pageBuilder.build()));
            return new PhysicalOperation(operatorFactory, outputMappings);
        }

        @Override
        public PhysicalOperation visitIndexSource(IndexSourceNode node, LocalExecutionPlanContext context) {
            Preconditions.checkState((boolean)context.getIndexSourceContext().isPresent(), (Object)"Must be in an index source context");
            IndexSourceContext indexSourceContext = (IndexSourceContext)context.getIndexSourceContext().get();
            ImmutableMap.Builder outputMappings = ImmutableMap.builder();
            int channel = 0;
            for (Symbol symbol : node.getOutputSymbols()) {
                outputMappings.put((Object)symbol, (Object)new Input(channel));
                ++channel;
            }
            SetMultimap indexLookupToProbeInput = indexSourceContext.getIndexLookupToProbeInput();
            Preconditions.checkState((boolean)indexLookupToProbeInput.keySet().equals(node.getLookupSymbols()));
            ImmutableList lookupSymbolSchema = ImmutableList.copyOf(node.getLookupSymbols());
            ImmutableList.Builder remappedProbeKeyChannelsBuilder = ImmutableList.builder();
            ImmutableList.Builder overlappingFieldSetsBuilder = ImmutableList.builder();
            for (Symbol lookupSymbol : lookupSymbolSchema) {
                Set potentialProbeInputs = indexLookupToProbeInput.get((Object)lookupSymbol);
                Preconditions.checkState((!potentialProbeInputs.isEmpty() ? 1 : 0) != 0, (Object)"Must have at least one source from the probe input");
                if (potentialProbeInputs.size() > 1) {
                    overlappingFieldSetsBuilder.add((Object)FluentIterable.from((Iterable)potentialProbeInputs).transform(Input.channelGetter()).toSet());
                }
                remappedProbeKeyChannelsBuilder.add((Object)((Input)Iterables.getFirst((Iterable)potentialProbeInputs, null)).getChannel());
            }
            ImmutableList overlappingFieldSets = overlappingFieldSetsBuilder.build();
            ImmutableList remappedProbeKeyChannels = remappedProbeKeyChannelsBuilder.build();
            Function<RecordSet, RecordSet> probeKeyNormalizer = new Function<RecordSet, RecordSet>((List)overlappingFieldSets, (List)remappedProbeKeyChannels){
                final /* synthetic */ List val$overlappingFieldSets;
                final /* synthetic */ List val$remappedProbeKeyChannels;
                {
                    this.val$overlappingFieldSets = list;
                    this.val$remappedProbeKeyChannels = list2;
                }

                public RecordSet apply(RecordSet recordSet) {
                    if (!this.val$overlappingFieldSets.isEmpty()) {
                        recordSet = new FieldSetFilteringRecordSet(recordSet, this.val$overlappingFieldSets);
                    }
                    return new MappedRecordSet(recordSet, this.val$remappedProbeKeyChannels);
                }
            };
            List lookupSchema = Lists.transform((List)lookupSymbolSchema, (Function)Functions.forMap(node.getAssignments()));
            List outputSchema = Lists.transform(node.getOutputSymbols(), (Function)Functions.forMap(node.getAssignments()));
            Index index = LocalExecutionPlanner.this.indexManager.getIndex(node.getIndexHandle(), lookupSchema, outputSchema);
            List<Type> types = this.getSourceOperatorTypes(node, context.getTypes());
            IndexSourceOperator.IndexSourceOperatorFactory operatorFactory = new IndexSourceOperator.IndexSourceOperatorFactory(context.getNextOperatorId(), node.getId(), index, types, probeKeyNormalizer);
            return new PhysicalOperation(operatorFactory, (Map<Symbol, Input>)outputMappings.build());
        }

        private SetMultimap<Symbol, Input> mapIndexSourceLookupSymbolToProbeKeyInput(IndexJoinNode node, Map<Symbol, Input> probeKeyLayout) {
            ImmutableSet indexJoinSymbols = FluentIterable.from(node.getCriteria()).transform(IndexJoinNode.EquiJoinClause.indexGetter()).toSet();
            Map<Symbol, Symbol> indexKeyTrace = IndexJoinOptimizer.IndexKeyTracer.trace(node.getIndexSource(), (Set<Symbol>)indexJoinSymbols);
            HashMultimap indexToProbeKeyInput = HashMultimap.create();
            for (IndexJoinNode.EquiJoinClause clause : node.getCriteria()) {
                indexToProbeKeyInput.put((Object)clause.getIndex(), (Object)probeKeyLayout.get(clause.getProbe()));
            }
            ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
            for (Map.Entry<Symbol, Symbol> entry : indexKeyTrace.entrySet()) {
                Symbol indexJoinSymbol = entry.getKey();
                Symbol indexLookupSymbol = entry.getValue();
                builder.putAll((Object)indexLookupSymbol, (Iterable)indexToProbeKeyInput.get((Object)indexJoinSymbol));
            }
            return builder.build();
        }

        @Override
        public PhysicalOperation visitIndexJoin(IndexJoinNode node, LocalExecutionPlanContext context) {
            OperatorFactory lookupJoinOperatorFactory;
            List<IndexJoinNode.EquiJoinClause> clauses = node.getCriteria();
            List probeSymbols = Lists.transform(clauses, IndexJoinNode.EquiJoinClause.probeGetter());
            List indexSymbols = Lists.transform(clauses, IndexJoinNode.EquiJoinClause.indexGetter());
            PhysicalOperation probeSource = node.getProbeSource().accept(this, context);
            List probeChannels = LocalExecutionPlanner.getChannelsForSymbols(probeSymbols, probeSource.getLayout());
            HashMap<Symbol, Input> probeKeyLayout = new HashMap<Symbol, Input>();
            for (int i = 0; i < probeSymbols.size(); ++i) {
                probeKeyLayout.put((Symbol)probeSymbols.get(i), new Input(i));
            }
            SetMultimap<Symbol, Input> indexLookupToProbeInput = this.mapIndexSourceLookupSymbolToProbeKeyInput(node, probeKeyLayout);
            LocalExecutionPlanContext indexContext = context.createIndexSourceSubContext(new IndexSourceContext(indexLookupToProbeInput));
            PhysicalOperation indexSource = node.getIndexSource().accept(this, indexContext);
            List indexChannels = LocalExecutionPlanner.getChannelsForSymbols(indexSymbols, indexSource.getLayout());
            PagesIndexBuilderOperator.PagesIndexBuilderOperatorFactory pagesIndexOutput = new PagesIndexBuilderOperator.PagesIndexBuilderOperatorFactory(indexContext.getNextOperatorId(), indexSource.getTypes());
            DriverFactory indexBuildDriverFactory = new DriverFactory(indexContext.isInputDriver(), false, (List<OperatorFactory>)ImmutableList.builder().addAll((Iterable)indexSource.getOperatorFactories()).add((Object)pagesIndexOutput).build());
            IndexLookupSourceSupplier indexLookupSourceSupplier = new IndexLookupSourceSupplier(indexChannels, indexSource.getTypes(), indexContext.getNextOperatorId(), indexBuildDriverFactory, pagesIndexOutput);
            ImmutableMap.Builder outputMappings = ImmutableMap.builder();
            outputMappings.putAll(probeSource.getLayout());
            int offset = probeSource.getTypes().size();
            for (Map.Entry<Symbol, Input> entry : indexSource.getLayout().entrySet()) {
                Input input = entry.getValue();
                outputMappings.put((Object)entry.getKey(), (Object)new Input(offset + input.getChannel()));
            }
            switch (node.getType()) {
                case INNER: {
                    lookupJoinOperatorFactory = LookupJoinOperators.innerJoin(context.getNextOperatorId(), indexLookupSourceSupplier, probeSource.getTypes(), probeChannels);
                    break;
                }
                case SOURCE_OUTER: {
                    lookupJoinOperatorFactory = LookupJoinOperators.outerJoin(context.getNextOperatorId(), indexLookupSourceSupplier, probeSource.getTypes(), probeChannels);
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unknown type: " + (Object)((Object)node.getType())));
                }
            }
            return new PhysicalOperation(lookupJoinOperatorFactory, (Map<Symbol, Input>)outputMappings.build(), probeSource);
        }

        @Override
        public PhysicalOperation visitJoin(JoinNode node, LocalExecutionPlanContext context) {
            List<JoinNode.EquiJoinClause> clauses = node.getCriteria();
            List leftSymbols = Lists.transform(clauses, JoinNode.EquiJoinClause.leftGetter());
            List rightSymbols = Lists.transform(clauses, JoinNode.EquiJoinClause.rightGetter());
            switch (node.getType()) {
                case INNER: 
                case LEFT: {
                    return this.createJoinOperator(node, node.getLeft(), leftSymbols, node.getRight(), rightSymbols, context);
                }
                case RIGHT: {
                    return this.createJoinOperator(node, node.getRight(), rightSymbols, node.getLeft(), leftSymbols, context);
                }
            }
            throw new UnsupportedOperationException("Unsupported join type: " + (Object)((Object)node.getType()));
        }

        private PhysicalOperation createJoinOperator(JoinNode node, PlanNode probeNode, List<Symbol> probeSymbols, PlanNode buildNode, List<Symbol> buildSymbols, LocalExecutionPlanContext context) {
            PhysicalOperation probeSource = probeNode.accept(this, context);
            ImmutableList probeChannels = ImmutableList.copyOf((Collection)LocalExecutionPlanner.getChannelsForSymbols(probeSymbols, probeSource.getLayout()));
            LocalExecutionPlanContext buildContext = context.createSubContext();
            PhysicalOperation buildSource = buildNode.accept(this, buildContext);
            ImmutableList buildChannels = ImmutableList.copyOf((Collection)LocalExecutionPlanner.getChannelsForSymbols(buildSymbols, buildSource.getLayout()));
            HashBuilderOperator.HashBuilderOperatorFactory hashBuilderOperatorFactory = new HashBuilderOperator.HashBuilderOperatorFactory(buildContext.getNextOperatorId(), buildSource.getTypes(), (List<Integer>)buildChannels, 100000);
            LookupSourceSupplier lookupSourceSupplier = hashBuilderOperatorFactory.getLookupSourceSupplier();
            DriverFactory buildDriverFactory = new DriverFactory(buildContext.isInputDriver(), false, (List<OperatorFactory>)ImmutableList.builder().addAll((Iterable)buildSource.getOperatorFactories()).add((Object)hashBuilderOperatorFactory).build());
            context.addDriverFactory(buildDriverFactory);
            ImmutableMap.Builder outputMappings = ImmutableMap.builder();
            outputMappings.putAll(probeSource.getLayout());
            int offset = probeSource.getTypes().size();
            for (Map.Entry<Symbol, Input> entry : buildSource.getLayout().entrySet()) {
                Input input = entry.getValue();
                outputMappings.put((Object)entry.getKey(), (Object)new Input(offset + input.getChannel()));
            }
            OperatorFactory operator = this.createJoinOperator(node.getType(), lookupSourceSupplier, probeSource.getTypes(), (List<Integer>)probeChannels, context);
            return new PhysicalOperation(operator, (Map<Symbol, Input>)outputMappings.build(), probeSource);
        }

        private OperatorFactory createJoinOperator(JoinNode.Type type, LookupSourceSupplier lookupSourceSupplier, List<Type> probeTypes, List<Integer> probeJoinChannels, LocalExecutionPlanContext context) {
            switch (type) {
                case INNER: {
                    return LookupJoinOperators.innerJoin(context.getNextOperatorId(), lookupSourceSupplier, probeTypes, probeJoinChannels);
                }
                case LEFT: 
                case RIGHT: {
                    return LookupJoinOperators.outerJoin(context.getNextOperatorId(), lookupSourceSupplier, probeTypes, probeJoinChannels);
                }
            }
            throw new UnsupportedOperationException("Unsupported join type: " + (Object)((Object)type));
        }

        @Override
        public PhysicalOperation visitSemiJoin(SemiJoinNode node, LocalExecutionPlanContext context) {
            PhysicalOperation probeSource = node.getSource().accept(this, context);
            LocalExecutionPlanContext buildContext = context.createSubContext();
            PhysicalOperation buildSource = node.getFilteringSource().accept(this, buildContext);
            int probeChannel = probeSource.getLayout().get(node.getSourceJoinSymbol()).getChannel();
            int buildChannel = buildSource.getLayout().get(node.getFilteringSourceJoinSymbol()).getChannel();
            SetBuilderOperator.SetBuilderOperatorFactory setBuilderOperatorFactory = new SetBuilderOperator.SetBuilderOperatorFactory(buildContext.getNextOperatorId(), buildSource.getTypes(), buildChannel, 100000);
            SetBuilderOperator.SetSupplier setProvider = setBuilderOperatorFactory.getSetProvider();
            DriverFactory buildDriverFactory = new DriverFactory(buildContext.isInputDriver(), false, (List<OperatorFactory>)ImmutableList.builder().addAll((Iterable)buildSource.getOperatorFactories()).add((Object)setBuilderOperatorFactory).build());
            context.addDriverFactory(buildDriverFactory);
            ImmutableMap outputMappings = ImmutableMap.builder().putAll(probeSource.getLayout()).put((Object)node.getSemiJoinOutput(), (Object)new Input(probeSource.getLayout().size())).build();
            HashSemiJoinOperator.HashSemiJoinOperatorFactory operator = new HashSemiJoinOperator.HashSemiJoinOperatorFactory(context.getNextOperatorId(), setProvider, probeSource.getTypes(), probeChannel);
            return new PhysicalOperation(operator, (Map<Symbol, Input>)outputMappings, probeSource);
        }

        @Override
        public PhysicalOperation visitSink(SinkNode node, LocalExecutionPlanContext context) {
            PhysicalOperation source = node.getSource().accept(this, context);
            boolean projectionMatchesOutput = IterableTransformer.on(source.getLayout().entrySet()).orderBy((Comparator<Map.Entry<Symbol, Input>>)LocalExecutionPlanner.inputOrdering().onResultOf(MoreFunctions.valueGetter())).transform(MoreFunctions.keyGetter()).list().equals(node.getOutputSymbols());
            if (!projectionMatchesOutput) {
                IdentityProjectionInfo mappings = LocalExecutionPlanner.computeIdentityMapping(node.getOutputSymbols(), source.getLayout(), context.getTypes());
                FilterAndProjectOperator.FilterAndProjectOperatorFactory operatorFactory = new FilterAndProjectOperator.FilterAndProjectOperatorFactory(context.getNextOperatorId(), FilterFunctions.TRUE_FUNCTION, mappings.getProjections());
                return new PhysicalOperation(operatorFactory, mappings.getOutputLayout(), source);
            }
            return source;
        }

        @Override
        public PhysicalOperation visitTableWriter(TableWriterNode node, LocalExecutionPlanContext context) {
            PhysicalOperation exchange = this.createInMemoryExchange(node.getSource(), context);
            Optional sampleWeightChannel = node.getSampleWeightSymbol().transform(exchange.channelGetter());
            RecordSink recordSink = LocalExecutionPlanner.this.recordSinkManager.getRecordSink(node.getTarget());
            List<Type> types = IterableTransformer.on(node.getColumns()).transform(Functions.forMap(context.getTypes())).list();
            List<Integer> inputChannels = IterableTransformer.on(node.getColumns()).transform(exchange.channelGetter()).list();
            TableWriterOperator.TableWriterOperatorFactory operatorFactory = new TableWriterOperator.TableWriterOperatorFactory(context.getNextOperatorId(), recordSink, types, inputChannels, (Optional<Integer>)sampleWeightChannel);
            ImmutableMap layout = ImmutableMap.builder().put((Object)node.getOutputSymbols().get(0), (Object)new Input(0)).put((Object)node.getOutputSymbols().get(1), (Object)new Input(1)).build();
            return new PhysicalOperation(operatorFactory, (Map<Symbol, Input>)layout, exchange);
        }

        private PhysicalOperation createInMemoryExchange(PlanNode node, LocalExecutionPlanContext context) {
            LocalExecutionPlanContext subContext = context.createSubContext();
            PhysicalOperation source = node.accept(this, subContext);
            InMemoryExchange exchange = new InMemoryExchange(this.getSourceOperatorTypes(node, context.getTypes()));
            ImmutableList factories = ImmutableList.builder().addAll((Iterable)source.getOperatorFactories()).add((Object)exchange.createSinkFactory(subContext.getNextOperatorId())).build();
            context.addDriverFactory(new DriverFactory(subContext.isInputDriver(), false, (List<OperatorFactory>)factories));
            exchange.noMoreSinkFactories();
            context.setInputDriver(false);
            List<Symbol> layout = node.getOutputSymbols();
            ImmutableMap.Builder outputMappings = ImmutableMap.builder();
            for (int i = 0; i < layout.size(); ++i) {
                outputMappings.put((Object)layout.get(i), (Object)new Input(i));
            }
            InMemoryExchangeSourceOperator.InMemoryExchangeSourceOperatorFactory factory = new InMemoryExchangeSourceOperator.InMemoryExchangeSourceOperatorFactory(context.getNextOperatorId(), exchange);
            return new PhysicalOperation(factory, (Map<Symbol, Input>)outputMappings.build());
        }

        @Override
        public PhysicalOperation visitTableCommit(TableCommitNode node, LocalExecutionPlanContext context) {
            PhysicalOperation source = node.getSource().accept(this, context);
            TableCommitOperator.TableCommitOperatorFactory operatorFactory = new TableCommitOperator.TableCommitOperatorFactory(context.getNextOperatorId(), LocalExecutionPlanner.createTableCommitter(node, LocalExecutionPlanner.this.metadata));
            ImmutableMap layout = ImmutableMap.of((Object)node.getOutputSymbols().get(0), (Object)new Input(0));
            return new PhysicalOperation(operatorFactory, (Map<Symbol, Input>)layout, source);
        }

        @Override
        public PhysicalOperation visitUnion(UnionNode node, LocalExecutionPlanContext context) {
            List<Type> types = this.getSourceOperatorTypes(node, context.getTypes());
            InMemoryExchange inMemoryExchange = new InMemoryExchange(types);
            for (int i = 0; i < node.getSources().size(); ++i) {
                PlanNode subplan = node.getSources().get(i);
                List<Symbol> expectedLayout = node.sourceOutputLayout(i);
                LocalExecutionPlanContext subContext = context.createSubContext();
                PhysicalOperation source = subplan.accept(this, subContext);
                ArrayList<OperatorFactory> operatorFactories = new ArrayList<OperatorFactory>(source.getOperatorFactories());
                boolean projectionMatchesOutput = IterableTransformer.on(source.getLayout().entrySet()).orderBy((Comparator<Map.Entry<Symbol, Input>>)LocalExecutionPlanner.inputOrdering().onResultOf(MoreFunctions.valueGetter())).transform(MoreFunctions.keyGetter()).list().equals(expectedLayout);
                if (!projectionMatchesOutput) {
                    IdentityProjectionInfo mappings = LocalExecutionPlanner.computeIdentityMapping(expectedLayout, source.getLayout(), context.getTypes());
                    operatorFactories.add(new FilterAndProjectOperator.FilterAndProjectOperatorFactory(subContext.getNextOperatorId(), FilterFunctions.TRUE_FUNCTION, mappings.getProjections()));
                }
                operatorFactories.add(inMemoryExchange.createSinkFactory(subContext.getNextOperatorId()));
                DriverFactory driverFactory = new DriverFactory(subContext.isInputDriver(), false, operatorFactories);
                context.addDriverFactory(driverFactory);
            }
            inMemoryExchange.noMoreSinkFactories();
            context.setInputDriver(false);
            ImmutableMap.Builder outputMappings = ImmutableMap.builder();
            int channel = 0;
            for (Symbol symbol : node.getOutputSymbols()) {
                outputMappings.put((Object)symbol, (Object)new Input(channel));
                ++channel;
            }
            return new PhysicalOperation(new InMemoryExchangeSourceOperator.InMemoryExchangeSourceOperatorFactory(context.getNextOperatorId(), inMemoryExchange), (Map<Symbol, Input>)outputMappings.build());
        }

        @Override
        protected PhysicalOperation visitPlan(PlanNode node, LocalExecutionPlanContext context) {
            throw new UnsupportedOperationException("not yet implemented");
        }

        private List<Type> getSourceOperatorTypes(PlanNode node, Map<Symbol, Type> types) {
            return this.getSymbolTypes(node.getOutputSymbols(), types);
        }

        private List<Type> getSymbolTypes(List<Symbol> symbols, Map<Symbol, Type> types) {
            return ImmutableList.copyOf(IterableTransformer.on(symbols).transform(Functions.forMap(types)).list());
        }

        private AggregationFunctionDefinition buildFunctionDefinition(PhysicalOperation source, Signature function, FunctionCall call, @Nullable Symbol mask, Optional<Symbol> sampleWeight, double confidence) {
            ArrayList<Input> arguments = new ArrayList<Input>();
            for (Expression argument : call.getArguments()) {
                Symbol argumentSymbol = Symbol.fromQualifiedName(((QualifiedNameReference)argument).getName());
                arguments.add(source.getLayout().get(argumentSymbol));
            }
            Optional maskInput = Optional.absent();
            if (mask != null) {
                maskInput = Optional.of((Object)source.getLayout().get(mask));
            }
            Optional sampleWeightInput = Optional.absent();
            if (sampleWeight.isPresent()) {
                sampleWeightInput = Optional.of((Object)source.getLayout().get(sampleWeight.get()));
            }
            return LocalExecutionPlanner.this.metadata.getExactFunction(function).bind(arguments, (Optional<Input>)maskInput, (Optional<Input>)sampleWeightInput, confidence);
        }

        private PhysicalOperation planGlobalAggregation(int operatorId, AggregationNode node, PhysicalOperation source) {
            int outputChannel = 0;
            ImmutableMap.Builder outputMappings = ImmutableMap.builder();
            ArrayList<AggregationFunctionDefinition> functionDefinitions = new ArrayList<AggregationFunctionDefinition>();
            for (Map.Entry<Symbol, FunctionCall> entry : node.getAggregations().entrySet()) {
                Symbol symbol = entry.getKey();
                functionDefinitions.add(this.buildFunctionDefinition(source, node.getFunctions().get(symbol), entry.getValue(), node.getMasks().get(entry.getKey()), node.getSampleWeight(), node.getConfidence()));
                outputMappings.put((Object)symbol, (Object)new Input(outputChannel));
                ++outputChannel;
            }
            AggregationOperator.AggregationOperatorFactory operatorFactory = new AggregationOperator.AggregationOperatorFactory(operatorId, node.getStep(), functionDefinitions);
            return new PhysicalOperation(operatorFactory, (Map<Symbol, Input>)outputMappings.build(), source);
        }

        private PhysicalOperation planGroupByAggregation(AggregationNode node, final PhysicalOperation source, LocalExecutionPlanContext context) {
            List<Symbol> groupBySymbols = node.getGroupBy();
            ArrayList<Symbol> aggregationOutputSymbols = new ArrayList<Symbol>();
            ArrayList<AggregationFunctionDefinition> functionDefinitions = new ArrayList<AggregationFunctionDefinition>();
            for (Map.Entry<Symbol, FunctionCall> entry : node.getAggregations().entrySet()) {
                Symbol symbol = entry.getKey();
                functionDefinitions.add(this.buildFunctionDefinition(source, node.getFunctions().get(symbol), entry.getValue(), node.getMasks().get(entry.getKey()), node.getSampleWeight(), node.getConfidence()));
                aggregationOutputSymbols.add(symbol);
            }
            ImmutableMap.Builder outputMappings = ImmutableMap.builder();
            int channel = 0;
            for (Symbol symbol : groupBySymbols) {
                outputMappings.put((Object)symbol, (Object)new Input(channel));
                ++channel;
            }
            for (Symbol symbol : aggregationOutputSymbols) {
                outputMappings.put((Object)symbol, (Object)new Input(channel));
                ++channel;
            }
            ImmutableList groupByChannels = ImmutableList.copyOf((Collection)LocalExecutionPlanner.getChannelsForSymbols(groupBySymbols, source.getLayout()));
            ImmutableList groupByTypes = ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)groupByChannels, (Function)new Function<Integer, Type>(){

                public Type apply(Integer input) {
                    return source.getTypes().get(input);
                }
            }));
            HashAggregationOperator.HashAggregationOperatorFactory operatorFactory = new HashAggregationOperator.HashAggregationOperatorFactory(context.getNextOperatorId(), (List<? extends Type>)groupByTypes, (List<Integer>)groupByChannels, node.getStep(), functionDefinitions, 10000);
            return new PhysicalOperation(operatorFactory, (Map<Symbol, Input>)outputMappings.build(), source);
        }
    }

    public static class LocalExecutionPlan {
        private final List<DriverFactory> driverFactories;

        public LocalExecutionPlan(List<DriverFactory> driverFactories) {
            this.driverFactories = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(driverFactories, (Object)"driverFactories is null")));
        }

        public List<DriverFactory> getDriverFactories() {
            return this.driverFactories;
        }
    }

    private static class IndexSourceContext {
        private final SetMultimap<Symbol, Input> indexLookupToProbeInput;

        public IndexSourceContext(SetMultimap<Symbol, Input> indexLookupToProbeInput) {
            this.indexLookupToProbeInput = ImmutableSetMultimap.copyOf((Multimap)((Multimap)Preconditions.checkNotNull(indexLookupToProbeInput, (Object)"indexLookupToProbeInput is null")));
        }

        private SetMultimap<Symbol, Input> getIndexLookupToProbeInput() {
            return this.indexLookupToProbeInput;
        }
    }

    private static class LocalExecutionPlanContext {
        private final ConnectorSession session;
        private final Map<Symbol, Type> types;
        private final List<DriverFactory> driverFactories;
        private final Optional<IndexSourceContext> indexSourceContext;
        private int nextOperatorId;
        private boolean inputDriver = true;

        public LocalExecutionPlanContext(ConnectorSession session, Map<Symbol, Type> types) {
            this(session, types, new ArrayList<DriverFactory>(), (Optional<IndexSourceContext>)Optional.absent());
        }

        private LocalExecutionPlanContext(ConnectorSession session, Map<Symbol, Type> types, List<DriverFactory> driverFactories, Optional<IndexSourceContext> indexSourceContext) {
            this.session = session;
            this.types = types;
            this.driverFactories = driverFactories;
            this.indexSourceContext = indexSourceContext;
        }

        public void addDriverFactory(DriverFactory driverFactory) {
            this.driverFactories.add((DriverFactory)Preconditions.checkNotNull((Object)driverFactory, (Object)"driverFactory is null"));
        }

        private List<DriverFactory> getDriverFactories() {
            return ImmutableList.copyOf(this.driverFactories);
        }

        public ConnectorSession getSession() {
            return this.session;
        }

        public Map<Symbol, Type> getTypes() {
            return this.types;
        }

        public Optional<IndexSourceContext> getIndexSourceContext() {
            return this.indexSourceContext;
        }

        private int getNextOperatorId() {
            return this.nextOperatorId++;
        }

        private boolean isInputDriver() {
            return this.inputDriver;
        }

        private void setInputDriver(boolean inputDriver) {
            this.inputDriver = inputDriver;
        }

        public LocalExecutionPlanContext createSubContext() {
            Preconditions.checkState((!this.indexSourceContext.isPresent() ? 1 : 0) != 0, (Object)"index build plan can not have sub-contexts");
            return new LocalExecutionPlanContext(this.session, this.types, this.driverFactories, this.indexSourceContext);
        }

        public LocalExecutionPlanContext createIndexSourceSubContext(IndexSourceContext indexSourceContext) {
            return new LocalExecutionPlanContext(this.session, this.types, this.driverFactories, (Optional<IndexSourceContext>)Optional.of((Object)indexSourceContext));
        }
    }
}

