/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.metadata.ColumnHandle;
import com.facebook.presto.spi.Domain;
import com.facebook.presto.spi.Range;
import com.facebook.presto.spi.SortedRangeSet;
import com.facebook.presto.spi.TupleDomain;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.ExpressionUtils;
import com.facebook.presto.sql.planner.DeterminismEvaluator;
import com.facebook.presto.sql.planner.DomainTranslator;
import com.facebook.presto.sql.planner.EqualityInference;
import com.facebook.presto.sql.planner.ExpressionSymbolInliner;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.plan.AggregationNode;
import com.facebook.presto.sql.planner.plan.DistinctLimitNode;
import com.facebook.presto.sql.planner.plan.FilterNode;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.LimitNode;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanVisitor;
import com.facebook.presto.sql.planner.plan.ProjectNode;
import com.facebook.presto.sql.planner.plan.SemiJoinNode;
import com.facebook.presto.sql.planner.plan.SortNode;
import com.facebook.presto.sql.planner.plan.TableScanNode;
import com.facebook.presto.sql.planner.plan.TopNNode;
import com.facebook.presto.sql.planner.plan.UnionNode;
import com.facebook.presto.sql.planner.plan.WindowNode;
import com.facebook.presto.sql.tree.BooleanLiteral;
import com.facebook.presto.sql.tree.ComparisonExpression;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.ExpressionRewriter;
import com.facebook.presto.sql.tree.ExpressionTreeRewriter;
import com.facebook.presto.sql.tree.QualifiedNameReference;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public class EffectivePredicateExtractor
extends PlanVisitor<Void, Expression> {
    private final Map<Symbol, Type> symbolTypes;

    public static Expression extract(PlanNode node, Map<Symbol, Type> symbolTypes) {
        return node.accept(new EffectivePredicateExtractor(symbolTypes), null);
    }

    public EffectivePredicateExtractor(Map<Symbol, Type> symbolTypes) {
        this.symbolTypes = symbolTypes;
    }

    @Override
    protected Expression visitPlan(PlanNode node, Void context) {
        return BooleanLiteral.TRUE_LITERAL;
    }

    @Override
    public Expression visitAggregation(AggregationNode node, Void context) {
        Expression underlyingPredicate = node.getSource().accept(this, context);
        return EffectivePredicateExtractor.pullExpressionThroughSymbols(underlyingPredicate, node.getGroupBy());
    }

    @Override
    public Expression visitFilter(FilterNode node, Void context) {
        Expression underlyingPredicate = node.getSource().accept(this, context);
        Expression predicate = node.getPredicate();
        predicate = ExpressionUtils.stripNonDeterministicConjuncts(predicate);
        return ExpressionUtils.combineConjuncts(predicate, underlyingPredicate);
    }

    private static Predicate<Map.Entry<Symbol, Expression>> symbolMatchesExpression() {
        return new Predicate<Map.Entry<Symbol, Expression>>(){

            public boolean apply(Map.Entry<Symbol, Expression> entry) {
                return entry.getValue().equals((Object)new QualifiedNameReference(entry.getKey().toQualifiedName()));
            }
        };
    }

    @Override
    public Expression visitProject(ProjectNode node, Void context) {
        Expression underlyingPredicate = node.getSource().accept(this, context);
        Iterable projectionEqualities = Iterables.transform((Iterable)Iterables.filter(node.getOutputMap().entrySet(), (Predicate)Predicates.not(EffectivePredicateExtractor.symbolMatchesExpression())), (Function)new Function<Map.Entry<Symbol, Expression>, Expression>(){

            public Expression apply(Map.Entry<Symbol, Expression> entry) {
                QualifiedNameReference reference = new QualifiedNameReference(entry.getKey().toQualifiedName());
                Expression expression = entry.getValue();
                return new ComparisonExpression(ComparisonExpression.Type.EQUAL, (Expression)reference, expression);
            }
        });
        return EffectivePredicateExtractor.pullExpressionThroughSymbols(ExpressionUtils.combineConjuncts((Iterable<Expression>)ImmutableList.builder().addAll(projectionEqualities).add((Object)underlyingPredicate).build()), node.getOutputSymbols());
    }

    @Override
    public Expression visitTopN(TopNNode node, Void context) {
        return node.getSource().accept(this, context);
    }

    @Override
    public Expression visitLimit(LimitNode node, Void context) {
        return node.getSource().accept(this, context);
    }

    @Override
    public Expression visitDistinctLimit(DistinctLimitNode node, Void context) {
        return node.getSource().accept(this, context);
    }

    @Override
    public Expression visitTableScan(TableScanNode node, Void context) {
        if (!node.getGeneratedPartitions().isPresent()) {
            return BooleanLiteral.TRUE_LITERAL;
        }
        TupleDomain<ColumnHandle> tupleDomain = node.getPartitionsDomainSummary().intersect(((TableScanNode.GeneratedPartitions)node.getGeneratedPartitions().get()).getTupleDomainInput());
        tupleDomain = EffectivePredicateExtractor.spanTupleDomain(tupleDomain);
        Expression partitionPredicate = DomainTranslator.toPredicate(tupleDomain, (Map<ColumnHandle, Symbol>)ImmutableBiMap.copyOf(node.getAssignments()).inverse(), this.symbolTypes);
        return EffectivePredicateExtractor.pullExpressionThroughSymbols(partitionPredicate, node.getOutputSymbols());
    }

    private static TupleDomain<ColumnHandle> spanTupleDomain(TupleDomain<ColumnHandle> tupleDomain) {
        if (tupleDomain.isNone()) {
            return tupleDomain;
        }
        Map spannedDomains = Maps.transformValues((Map)tupleDomain.getDomains(), (Function)new Function<Domain, Domain>(){

            public Domain apply(Domain domain) {
                return Domain.create((SortedRangeSet)EffectivePredicateExtractor.getSortedRangeSpan(domain.getRanges()), (boolean)domain.isNullAllowed());
            }
        });
        return TupleDomain.withColumnDomains((Map)spannedDomains);
    }

    private static SortedRangeSet getSortedRangeSpan(SortedRangeSet rangeSet) {
        return rangeSet.isNone() ? SortedRangeSet.none((Class)rangeSet.getType()) : SortedRangeSet.of((Range)rangeSet.getSpan(), (Range[])new Range[0]);
    }

    @Override
    public Expression visitSort(SortNode node, Void context) {
        return node.getSource().accept(this, context);
    }

    @Override
    public Expression visitWindow(WindowNode node, Void context) {
        return node.getSource().accept(this, context);
    }

    @Override
    public Expression visitUnion(UnionNode node, Void context) {
        Expression firstUnderlyingPredicate = node.getSources().get(0).accept(this, context);
        Expression firstOutputPredicate = ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new ExpressionSymbolInliner(node.outputSymbolMap(0)), (Expression)firstUnderlyingPredicate);
        ImmutableSet conjuncts = ImmutableSet.copyOf(ExpressionUtils.extractConjuncts(firstOutputPredicate));
        for (int i = 1; i < node.getSources().size(); ++i) {
            Expression underlyingPredicate = node.getSources().get(i).accept(this, context);
            Expression outputPredicate = ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new ExpressionSymbolInliner(node.outputSymbolMap(i)), (Expression)underlyingPredicate);
            conjuncts = Sets.intersection((Set)conjuncts, (Set)ImmutableSet.copyOf(ExpressionUtils.extractConjuncts(outputPredicate)));
        }
        return ExpressionUtils.combineConjuncts((Iterable<Expression>)conjuncts);
    }

    @Override
    public Expression visitJoin(JoinNode node, Void context) {
        Expression leftPredicate = node.getLeft().accept(this, context);
        Expression rightPredicate = node.getRight().accept(this, context);
        ArrayList<ComparisonExpression> joinConjuncts = new ArrayList<ComparisonExpression>();
        for (JoinNode.EquiJoinClause clause : node.getCriteria()) {
            joinConjuncts.add(new ComparisonExpression(ComparisonExpression.Type.EQUAL, (Expression)new QualifiedNameReference(clause.getLeft().toQualifiedName()), (Expression)new QualifiedNameReference(clause.getRight().toQualifiedName())));
        }
        switch (node.getType()) {
            case INNER: 
            case CROSS: {
                return ExpressionUtils.combineConjuncts((Iterable<Expression>)ImmutableList.builder().add((Object)leftPredicate).add((Object)rightPredicate).addAll(joinConjuncts).build());
            }
            case LEFT: {
                return ExpressionUtils.combineConjuncts((Iterable<Expression>)ImmutableList.builder().add((Object)leftPredicate).addAll(Iterables.transform(ExpressionUtils.extractConjuncts(rightPredicate), ExpressionUtils.expressionOrNullSymbols((Predicate<Symbol>)Predicates.in(node.getRight().getOutputSymbols())))).addAll(Iterables.transform(joinConjuncts, ExpressionUtils.expressionOrNullSymbols((Predicate<Symbol>)Predicates.in(node.getRight().getOutputSymbols())))).build());
            }
            case RIGHT: {
                return ExpressionUtils.combineConjuncts((Iterable<Expression>)ImmutableList.builder().add((Object)rightPredicate).addAll(Iterables.transform(ExpressionUtils.extractConjuncts(leftPredicate), ExpressionUtils.expressionOrNullSymbols((Predicate<Symbol>)Predicates.in(node.getLeft().getOutputSymbols())))).addAll(Iterables.transform(joinConjuncts, ExpressionUtils.expressionOrNullSymbols((Predicate<Symbol>)Predicates.in(node.getLeft().getOutputSymbols())))).build());
            }
        }
        throw new UnsupportedOperationException("Unknown join type: " + (Object)((Object)node.getType()));
    }

    @Override
    public Expression visitSemiJoin(SemiJoinNode node, Void context) {
        return node.getSource().accept(this, context);
    }

    private static Expression pullExpressionThroughSymbols(Expression expression, Collection<Symbol> symbols) {
        EqualityInference equalityInference = EqualityInference.createEqualityInference(expression);
        ImmutableList.Builder effectiveConjuncts = ImmutableList.builder();
        for (Expression conjunct : EqualityInference.nonInferrableConjuncts(expression)) {
            Expression rewritten;
            if (!DeterminismEvaluator.isDeterministic(conjunct) || (rewritten = equalityInference.rewriteExpression(conjunct, (Predicate<Symbol>)Predicates.in(symbols))) == null) continue;
            effectiveConjuncts.add((Object)rewritten);
        }
        effectiveConjuncts.addAll(equalityInference.generateEqualitiesPartitionedBy((Predicate<Symbol>)Predicates.in(symbols)).getScopeEqualities());
        return ExpressionUtils.combineConjuncts((Iterable<Expression>)effectiveConjuncts.build());
    }
}

