/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.gen;

import com.facebook.presto.byteCode.Access;
import com.facebook.presto.byteCode.ClassDefinition;
import com.facebook.presto.byteCode.ClassInfoLoader;
import com.facebook.presto.byteCode.CompilerContext;
import com.facebook.presto.byteCode.DynamicClassLoader;
import com.facebook.presto.byteCode.LocalVariableDefinition;
import com.facebook.presto.byteCode.MethodDefinition;
import com.facebook.presto.byteCode.NamedParameterDefinition;
import com.facebook.presto.byteCode.ParameterizedType;
import com.facebook.presto.byteCode.SmartClassWriter;
import com.facebook.presto.byteCode.instruction.LabelNode;
import com.facebook.presto.operator.PagesIndex;
import com.facebook.presto.operator.PagesIndexComparator;
import com.facebook.presto.operator.PagesIndexOrdering;
import com.facebook.presto.operator.SimplePagesIndexComparator;
import com.facebook.presto.operator.SyntheticAddress;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.SortOrder;
import com.facebook.presto.sql.gen.ExpressionCompiler;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.io.Files;
import com.google.common.util.concurrent.ExecutionError;
import com.google.common.util.concurrent.UncheckedExecutionException;
import io.airlift.log.Logger;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.objectweb.asm.ClassVisitor;

public class OrderingCompiler {
    private static final Logger log = Logger.get(ExpressionCompiler.class);
    private static final AtomicLong CLASS_ID = new AtomicLong();
    private static final boolean DUMP_BYTE_CODE_TREE = false;
    private static final boolean DUMP_BYTE_CODE_RAW = false;
    private static final boolean RUN_ASM_VERIFIER = false;
    private static final AtomicReference<String> DUMP_CLASS_FILES_TO = new AtomicReference();
    private final Method bootstrapMethod = null;
    private final LoadingCache<PagesIndexComparatorCacheKey, PagesIndexOrdering> pagesIndexOrderings = CacheBuilder.newBuilder().maximumSize(1000L).build((CacheLoader)new CacheLoader<PagesIndexComparatorCacheKey, PagesIndexOrdering>(){

        public PagesIndexOrdering load(PagesIndexComparatorCacheKey key) throws Exception {
            return OrderingCompiler.this.internalCompilePagesIndexOrdering(key.getSortChannels(), key.getSortOrders());
        }
    });

    public PagesIndexOrdering compilePagesIndexOrdering(List<Integer> sortChannels, List<SortOrder> sortOrders) {
        Preconditions.checkNotNull(sortChannels, (Object)"sortChannels is null");
        Preconditions.checkNotNull(sortOrders, (Object)"sortOrders is null");
        try {
            return (PagesIndexOrdering)this.pagesIndexOrderings.get((Object)new PagesIndexComparatorCacheKey(sortChannels, sortOrders));
        }
        catch (ExecutionError | UncheckedExecutionException | ExecutionException e) {
            throw Throwables.propagate((Throwable)e.getCause());
        }
    }

    @VisibleForTesting
    public PagesIndexOrdering internalCompilePagesIndexOrdering(List<Integer> sortChannels, List<SortOrder> sortOrders) throws Exception {
        PagesIndexComparator comparator;
        Preconditions.checkNotNull(sortChannels, (Object)"sortChannels is null");
        Preconditions.checkNotNull(sortOrders, (Object)"sortOrders is null");
        try {
            DynamicClassLoader classLoader = new DynamicClassLoader(this.getClass().getClassLoader());
            Class<? extends PagesIndexComparator> pagesHashStrategyClass = this.compilePagesIndexComparator(sortChannels, sortOrders, classLoader);
            comparator = pagesHashStrategyClass.newInstance();
        }
        catch (Throwable e) {
            log.error(e, "Error compiling comparator for channels %s with order %s", new Object[]{sortChannels, sortChannels});
            comparator = new SimplePagesIndexComparator(sortChannels, sortOrders);
        }
        return new PagesIndexOrdering(comparator);
    }

    private Class<? extends PagesIndexComparator> compilePagesIndexComparator(List<Integer> sortChannels, List<SortOrder> sortOrders, DynamicClassLoader classLoader) {
        ClassDefinition classDefinition = new ClassDefinition(new CompilerContext(this.bootstrapMethod), Access.a(Access.PUBLIC, Access.FINAL), ParameterizedType.typeFromPathName("PagesIndexComparator" + CLASS_ID.incrementAndGet()), ParameterizedType.type(Object.class), ParameterizedType.type(PagesIndexComparator.class));
        this.generateConstructor(classDefinition);
        this.generateCompareTo(classDefinition, sortChannels, sortOrders);
        Class<PagesIndexComparator> joinHashClass = OrderingCompiler.defineClass(classDefinition, PagesIndexComparator.class, classLoader);
        return joinHashClass;
    }

    private void generateConstructor(ClassDefinition classDefinition) {
        classDefinition.declareConstructor(new CompilerContext(this.bootstrapMethod), Access.a(Access.PUBLIC), new NamedParameterDefinition[0]).getBody().comment("super();").pushThis().invokeConstructor(Object.class, new Class[0]).ret();
    }

    private void generateCompareTo(ClassDefinition classDefinition, List<Integer> sortChannels, List<SortOrder> sortOrders) {
        CompilerContext compilerContext = new CompilerContext(this.bootstrapMethod);
        MethodDefinition compareToMethod = classDefinition.declareMethod(compilerContext, Access.a(Access.PUBLIC), "compareTo", ParameterizedType.type(Integer.TYPE), NamedParameterDefinition.arg("pagesIndex", PagesIndex.class), NamedParameterDefinition.arg("leftPosition", Integer.TYPE), NamedParameterDefinition.arg("rightPosition", Integer.TYPE));
        LocalVariableDefinition valueAddresses = compilerContext.declareVariable(LongArrayList.class, "valueAddresses");
        compareToMethod.getBody().comment("LongArrayList valueAddresses = pagesIndex.valueAddresses").getVariable("pagesIndex").invokeVirtual(PagesIndex.class, "getValueAddresses", LongArrayList.class, new Class[0]).putVariable(valueAddresses);
        LocalVariableDefinition leftPageAddress = compilerContext.declareVariable(Long.TYPE, "leftPageAddress");
        compareToMethod.getBody().comment("long leftPageAddress = valueAddresses.getLong(leftPosition)").getVariable(valueAddresses).getVariable("leftPosition").invokeVirtual(LongArrayList.class, "getLong", Long.TYPE, Integer.TYPE).putVariable(leftPageAddress);
        LocalVariableDefinition leftBlockIndex = compilerContext.declareVariable(Integer.TYPE, "leftBlockIndex");
        compareToMethod.getBody().comment("int leftBlockIndex = decodeSliceIndex(leftPageAddress)").getVariable(leftPageAddress).invokeStatic(SyntheticAddress.class, "decodeSliceIndex", Integer.TYPE, Long.TYPE).putVariable(leftBlockIndex);
        LocalVariableDefinition leftBlockPosition = compilerContext.declareVariable(Integer.TYPE, "leftBlockPosition");
        compareToMethod.getBody().comment("int leftBlockPosition = decodePosition(leftPageAddress)").getVariable(leftPageAddress).invokeStatic(SyntheticAddress.class, "decodePosition", Integer.TYPE, Long.TYPE).putVariable(leftBlockPosition);
        LocalVariableDefinition rightPageAddress = compilerContext.declareVariable(Long.TYPE, "rightPageAddress");
        compareToMethod.getBody().comment("long rightPageAddress = valueAddresses.getLong(rightPosition);").getVariable(valueAddresses).getVariable("rightPosition").invokeVirtual(LongArrayList.class, "getLong", Long.TYPE, Integer.TYPE).putVariable(rightPageAddress);
        LocalVariableDefinition rightBlockIndex = compilerContext.declareVariable(Integer.TYPE, "rightBlockIndex");
        compareToMethod.getBody().comment("int rightBlockIndex = decodeSliceIndex(rightPageAddress)").getVariable(rightPageAddress).invokeStatic(SyntheticAddress.class, "decodeSliceIndex", Integer.TYPE, Long.TYPE).putVariable(rightBlockIndex);
        LocalVariableDefinition rightBlockPosition = compilerContext.declareVariable(Integer.TYPE, "rightBlockPosition");
        compareToMethod.getBody().comment("int rightBlockPosition = decodePosition(rightPageAddress)").getVariable(rightPageAddress).invokeStatic(SyntheticAddress.class, "decodePosition", Integer.TYPE, Long.TYPE).putVariable(rightBlockPosition);
        for (int i = 0; i < sortChannels.size(); ++i) {
            int sortChannel = sortChannels.get(i);
            SortOrder sortOrder = sortOrders.get(i);
            com.facebook.presto.byteCode.Block block = new com.facebook.presto.byteCode.Block(compilerContext).setDescription("compare channel " + sortChannel + " " + sortOrder);
            block.comment("push leftBlock -- pagesIndex.getChannel(sortChannel).get(leftBlockIndex)").getVariable("pagesIndex").push(sortChannel).invokeVirtual(PagesIndex.class, "getChannel", ObjectArrayList.class, Integer.TYPE).getVariable(leftBlockIndex).invokeVirtual(ObjectArrayList.class, "get", Object.class, Integer.TYPE).checkCast(Block.class);
            block.comment("push sortOrder").getStaticField(SortOrder.class, sortOrder.name(), SortOrder.class);
            block.comment("push leftBlockPosition").getVariable(leftBlockPosition);
            block.comment("push rightBlock -- pagesIndex.getChannel(sortChannel).get(rightBlockIndex)").getVariable("pagesIndex").push(sortChannel).invokeVirtual(PagesIndex.class, "getChannel", ObjectArrayList.class, Integer.TYPE).getVariable(rightBlockIndex).invokeVirtual(ObjectArrayList.class, "get", Object.class, Integer.TYPE).checkCast(Block.class);
            block.comment("push rightBlockPosition").getVariable(rightBlockPosition);
            block.comment("invoke compareTo").invokeInterface(Block.class, "compareTo", Integer.TYPE, SortOrder.class, Integer.TYPE, Block.class, Integer.TYPE);
            LabelNode equal = new LabelNode("equal");
            block.comment("if (compare != 0) return compare").dup().ifZeroGoto(equal).retInt().visitLabel(equal).pop(Integer.TYPE);
            compareToMethod.getBody().append(block);
        }
        compareToMethod.getBody().push(0).retInt();
    }

    private static <T> Class<? extends T> defineClass(ClassDefinition classDefinition, Class<T> superType, DynamicClassLoader classLoader) {
        Class<?> clazz = OrderingCompiler.defineClasses((List<ClassDefinition>)ImmutableList.of((Object)classDefinition), classLoader).values().iterator().next();
        return clazz.asSubclass(superType);
    }

    private static Map<String, Class<?>> defineClasses(List<ClassDefinition> classDefinitions, DynamicClassLoader classLoader) {
        ClassInfoLoader classInfoLoader = ClassInfoLoader.createClassInfoLoader(classDefinitions, classLoader);
        LinkedHashMap<String, byte[]> byteCodes = new LinkedHashMap<String, byte[]>();
        for (ClassDefinition classDefinition : classDefinitions) {
            SmartClassWriter cw = new SmartClassWriter(classInfoLoader);
            classDefinition.visit((ClassVisitor)cw);
            byte[] byteCode = cw.toByteArray();
            byteCodes.put(classDefinition.getType().getJavaClassName(), byteCode);
        }
        String dumpClassPath = DUMP_CLASS_FILES_TO.get();
        if (dumpClassPath != null) {
            for (Map.Entry entry : byteCodes.entrySet()) {
                File file = new File(dumpClassPath, ParameterizedType.typeFromJavaClassName((String)entry.getKey()).getClassName() + ".class");
                try {
                    log.debug("ClassFile: " + file.getAbsolutePath());
                    Files.createParentDirs((File)file);
                    Files.write((byte[])((byte[])entry.getValue()), (File)file);
                }
                catch (IOException e) {
                    log.error((Throwable)e, "Failed to write generated class file to: %s" + file.getAbsolutePath());
                }
            }
        }
        return classLoader.defineClasses(byteCodes);
    }

    private static final class PagesIndexComparatorCacheKey {
        private List<Integer> sortChannels;
        private List<SortOrder> sortOrders;

        private PagesIndexComparatorCacheKey(List<Integer> sortChannels, List<SortOrder> sortOrders) {
            this.sortChannels = ImmutableList.copyOf(sortChannels);
            this.sortOrders = ImmutableList.copyOf(sortOrders);
        }

        public List<Integer> getSortChannels() {
            return this.sortChannels;
        }

        public List<SortOrder> getSortOrders() {
            return this.sortOrders;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.sortChannels, this.sortOrders});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            PagesIndexComparatorCacheKey other = (PagesIndexComparatorCacheKey)obj;
            return Objects.equal(this.sortChannels, other.sortChannels) && Objects.equal(this.sortOrders, other.sortOrders);
        }
    }
}

