/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.gen;

import com.facebook.presto.byteCode.Access;
import com.facebook.presto.byteCode.ClassDefinition;
import com.facebook.presto.byteCode.ClassInfoLoader;
import com.facebook.presto.byteCode.CompilerContext;
import com.facebook.presto.byteCode.DynamicClassLoader;
import com.facebook.presto.byteCode.FieldDefinition;
import com.facebook.presto.byteCode.LocalVariableDefinition;
import com.facebook.presto.byteCode.NamedParameterDefinition;
import com.facebook.presto.byteCode.ParameterizedType;
import com.facebook.presto.byteCode.SmartClassWriter;
import com.facebook.presto.byteCode.control.IfStatement;
import com.facebook.presto.byteCode.instruction.LabelNode;
import com.facebook.presto.operator.JoinProbe;
import com.facebook.presto.operator.JoinProbeFactory;
import com.facebook.presto.operator.LookupJoinOperator;
import com.facebook.presto.operator.LookupJoinOperatorFactory;
import com.facebook.presto.operator.LookupSource;
import com.facebook.presto.operator.LookupSourceSupplier;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.Page;
import com.facebook.presto.operator.PageBuilder;
import com.facebook.presto.operator.aggregation.IsolatedClass;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockCursor;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.gen.ExpressionCompiler;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.io.Files;
import com.google.common.util.concurrent.ExecutionError;
import com.google.common.util.concurrent.UncheckedExecutionException;
import io.airlift.log.Logger;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.objectweb.asm.ClassVisitor;

public class JoinProbeCompiler {
    private static final Logger log = Logger.get(ExpressionCompiler.class);
    private static final AtomicLong CLASS_ID = new AtomicLong();
    private static final boolean DUMP_BYTE_CODE_TREE = false;
    private static final boolean DUMP_BYTE_CODE_RAW = false;
    private static final boolean RUN_ASM_VERIFIER = false;
    private static final AtomicReference<String> DUMP_CLASS_FILES_TO = new AtomicReference();
    private final Method bootstrapMethod = null;
    private final LoadingCache<JoinOperatorCacheKey, HashJoinOperatorFactoryFactory> joinProbeFactories = CacheBuilder.newBuilder().maximumSize(1000L).build((CacheLoader)new CacheLoader<JoinOperatorCacheKey, HashJoinOperatorFactoryFactory>(){

        public HashJoinOperatorFactoryFactory load(JoinOperatorCacheKey key) throws Exception {
            return JoinProbeCompiler.this.internalCompileJoinOperatorFactory(key.getTypes().size(), key.getProbeChannels());
        }
    });

    public OperatorFactory compileJoinOperatorFactory(int operatorId, LookupSourceSupplier lookupSourceSupplier, List<? extends Type> probeTypes, List<Integer> probeJoinChannel, boolean enableOuterJoin) {
        try {
            HashJoinOperatorFactoryFactory operatorFactoryFactory = (HashJoinOperatorFactoryFactory)this.joinProbeFactories.get((Object)new JoinOperatorCacheKey(probeTypes, probeJoinChannel, enableOuterJoin));
            return operatorFactoryFactory.createHashJoinOperatorFactory(operatorId, lookupSourceSupplier, probeTypes, probeJoinChannel, enableOuterJoin);
        }
        catch (ExecutionError | UncheckedExecutionException | ExecutionException e) {
            throw Throwables.propagate((Throwable)e.getCause());
        }
    }

    public HashJoinOperatorFactoryFactory internalCompileJoinOperatorFactory(int channelCount, List<Integer> probeJoinChannel) {
        JoinProbeFactory joinProbeFactory;
        DynamicClassLoader classLoader = new DynamicClassLoader(this.getClass().getClassLoader());
        Class<? extends JoinProbe> joinProbeClass = this.compileJoinProbe(channelCount, probeJoinChannel, classLoader);
        ClassDefinition classDefinition = new ClassDefinition(new CompilerContext(this.bootstrapMethod), Access.a(Access.PUBLIC, Access.FINAL), ParameterizedType.typeFromPathName("JoinProbeFactory_" + CLASS_ID.incrementAndGet()), ParameterizedType.type(Object.class), ParameterizedType.type(JoinProbeFactory.class));
        classDefinition.declareConstructor(new CompilerContext(this.bootstrapMethod), Access.a(Access.PUBLIC), new NamedParameterDefinition[0]).getBody().comment("super();").pushThis().invokeConstructor(Object.class, new Class[0]).ret();
        classDefinition.declareMethod(new CompilerContext(this.bootstrapMethod), Access.a(Access.PUBLIC), "createJoinProbe", ParameterizedType.type(JoinProbe.class), NamedParameterDefinition.arg("lookupSource", LookupSource.class), NamedParameterDefinition.arg("page", Page.class)).getBody().newObject(joinProbeClass).dup().getVariable("lookupSource").getVariable("page").invokeConstructor(joinProbeClass, LookupSource.class, Page.class).retObject();
        Class<JoinProbeFactory> joinProbeFactoryClass = JoinProbeCompiler.defineClass(classDefinition, JoinProbeFactory.class, classLoader);
        try {
            joinProbeFactory = joinProbeFactoryClass.newInstance();
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
        Class<LookupJoinOperatorFactory> operatorFactoryClass = IsolatedClass.isolateClass(classLoader, OperatorFactory.class, LookupJoinOperatorFactory.class, LookupJoinOperator.class);
        return new HashJoinOperatorFactoryFactory(joinProbeFactory, operatorFactoryClass);
    }

    @VisibleForTesting
    public JoinProbeFactory internalCompileJoinProbe(int channelCount, List<Integer> probeChannels) {
        DynamicClassLoader classLoader = new DynamicClassLoader(this.getClass().getClassLoader());
        Class<? extends JoinProbe> joinProbeClass = this.compileJoinProbe(channelCount, probeChannels, classLoader);
        return new ReflectionJoinProbeFactory(joinProbeClass);
    }

    private Class<? extends JoinProbe> compileJoinProbe(int channelCount, List<Integer> probeChannels, DynamicClassLoader classLoader) {
        ClassDefinition classDefinition = new ClassDefinition(new CompilerContext(this.bootstrapMethod), Access.a(Access.PUBLIC, Access.FINAL), ParameterizedType.typeFromPathName("JoinProbe_" + CLASS_ID.incrementAndGet()), ParameterizedType.type(Object.class), ParameterizedType.type(JoinProbe.class));
        FieldDefinition lookupSourceField = classDefinition.declareField(Access.a(Access.PRIVATE, Access.FINAL), "lookupSource", LookupSource.class);
        ArrayList<FieldDefinition> cursorFields = new ArrayList<FieldDefinition>();
        for (int i = 0; i < channelCount; ++i) {
            FieldDefinition channelField = classDefinition.declareField(Access.a(Access.PRIVATE, Access.FINAL), "cursor_" + i, BlockCursor.class);
            cursorFields.add(channelField);
        }
        ArrayList<FieldDefinition> probeCursorFields = new ArrayList<FieldDefinition>();
        for (int i = 0; i < probeChannels.size(); ++i) {
            FieldDefinition channelField = classDefinition.declareField(Access.a(Access.PRIVATE, Access.FINAL), "probeCursor_" + i, BlockCursor.class);
            probeCursorFields.add(channelField);
        }
        FieldDefinition probeCursorsArrayField = classDefinition.declareField(Access.a(Access.PRIVATE, Access.FINAL), "probeCursors", BlockCursor[].class);
        this.generateConstructor(classDefinition, probeChannels, lookupSourceField, cursorFields, probeCursorFields, probeCursorsArrayField);
        this.generateGetChannelCountMethod(classDefinition, cursorFields.size());
        this.generateAppendToMethod(classDefinition, cursorFields);
        this.generateAdvanceNextPosition(classDefinition, cursorFields);
        this.generateGetCurrentJoinPosition(classDefinition, lookupSourceField, probeCursorsArrayField);
        this.generateCurrentRowContainsNull(classDefinition, probeCursorFields);
        Class<JoinProbe> joinProbeClass = JoinProbeCompiler.defineClass(classDefinition, JoinProbe.class, classLoader);
        return joinProbeClass;
    }

    private void generateConstructor(ClassDefinition classDefinition, List<Integer> probeChannels, FieldDefinition lookupSourceField, List<FieldDefinition> cursorFields, List<FieldDefinition> probeChannelFields, FieldDefinition probeCursorsArrayField) {
        int index;
        com.facebook.presto.byteCode.Block constructor = classDefinition.declareConstructor(new CompilerContext(this.bootstrapMethod), Access.a(Access.PUBLIC), NamedParameterDefinition.arg("lookupSource", LookupSource.class), NamedParameterDefinition.arg("page", Page.class)).getBody().comment("super();").pushThis().invokeConstructor(Object.class, new Class[0]);
        constructor.comment("this.lookupSource = lookupSource;");
        constructor.pushThis().getVariable("lookupSource").putField(lookupSourceField);
        constructor.comment("Set cursor fields");
        for (index = 0; index < cursorFields.size(); ++index) {
            constructor.pushThis().getVariable("page").push(index).invokeVirtual(Page.class, "getBlock", Block.class, Integer.TYPE).invokeInterface(Block.class, "cursor", BlockCursor.class, new Class[0]).putField(cursorFields.get(index));
        }
        constructor.comment("Set probe channel fields");
        for (index = 0; index < probeChannelFields.size(); ++index) {
            constructor.pushThis().pushThis().getField(cursorFields.get(probeChannels.get(index))).putField(probeChannelFields.get(index));
        }
        constructor.comment("this.probeCursors = new BlockCursor[<probeChannelCount>];");
        constructor.pushThis().push(probeChannelFields.size()).newArray(BlockCursor.class).putField(probeCursorsArrayField);
        for (index = 0; index < probeChannelFields.size(); ++index) {
            constructor.pushThis().getField(probeCursorsArrayField).push(index).pushThis().getField(probeChannelFields.get(index)).putObjectArrayElement();
        }
        constructor.ret();
    }

    private void generateGetChannelCountMethod(ClassDefinition classDefinition, int channelCount) {
        classDefinition.declareMethod(new CompilerContext(this.bootstrapMethod), Access.a(Access.PUBLIC), "getChannelCount", ParameterizedType.type(Integer.TYPE), new NamedParameterDefinition[0]).getBody().push(channelCount).retInt();
    }

    private void generateAppendToMethod(ClassDefinition classDefinition, List<FieldDefinition> cursorFields) {
        com.facebook.presto.byteCode.Block appendToBody = classDefinition.declareMethod(new CompilerContext(this.bootstrapMethod), Access.a(Access.PUBLIC), "appendTo", ParameterizedType.type(Void.TYPE), NamedParameterDefinition.arg("pageBuilder", PageBuilder.class)).getBody();
        for (int index = 0; index < cursorFields.size(); ++index) {
            appendToBody.pushThis().getField(cursorFields.get(index)).getVariable("pageBuilder").push(index).invokeVirtual(PageBuilder.class, "getBlockBuilder", BlockBuilder.class, Integer.TYPE).invokeInterface(BlockCursor.class, "appendTo", Void.TYPE, BlockBuilder.class);
        }
        appendToBody.ret();
    }

    private void generateAdvanceNextPosition(ClassDefinition classDefinition, List<FieldDefinition> cursorFields) {
        CompilerContext compilerContext = new CompilerContext(this.bootstrapMethod);
        com.facebook.presto.byteCode.Block advanceNextPositionBody = classDefinition.declareMethod(compilerContext, Access.a(Access.PUBLIC), "advanceNextPosition", ParameterizedType.type(Boolean.TYPE), new NamedParameterDefinition[0]).getBody();
        LocalVariableDefinition advancedVariable = compilerContext.declareVariable(Boolean.TYPE, "advanced");
        advanceNextPositionBody.pushThis().getField(cursorFields.get(0)).invokeInterface(BlockCursor.class, "advanceNextPosition", Boolean.TYPE, new Class[0]).putVariable(advancedVariable);
        for (int index = 1; index < cursorFields.size(); ++index) {
            advanceNextPositionBody.pushThis().getField(cursorFields.get(index)).invokeInterface(BlockCursor.class, "advanceNextPosition", Boolean.TYPE, new Class[0]).getVariable(advancedVariable).invokeStatic(JoinProbeCompiler.class, "checkState", Void.TYPE, Boolean.TYPE, Boolean.TYPE);
        }
        advanceNextPositionBody.getVariable(advancedVariable).retBoolean();
    }

    private void generateGetCurrentJoinPosition(ClassDefinition classDefinition, FieldDefinition lookupSourceField, FieldDefinition probeCursorsArrayField) {
        CompilerContext compilerContext = new CompilerContext(this.bootstrapMethod);
        classDefinition.declareMethod(compilerContext, Access.a(Access.PUBLIC), "getCurrentJoinPosition", ParameterizedType.type(Long.TYPE), new NamedParameterDefinition[0]).getBody().append(new IfStatement(compilerContext, new com.facebook.presto.byteCode.Block(compilerContext).pushThis().invokeVirtual(classDefinition.getType(), "currentRowContainsNull", ParameterizedType.type(Boolean.TYPE), new ParameterizedType[0]), new com.facebook.presto.byteCode.Block(compilerContext).push(-1L).retLong(), null)).pushThis().getField(lookupSourceField).pushThis().getField(probeCursorsArrayField).invokeInterface(LookupSource.class, "getJoinPosition", Long.TYPE, BlockCursor[].class).retLong();
    }

    private void generateCurrentRowContainsNull(ClassDefinition classDefinition, List<FieldDefinition> probeCursorFields) {
        com.facebook.presto.byteCode.Block body = classDefinition.declareMethod(new CompilerContext(this.bootstrapMethod), Access.a(Access.PRIVATE), "currentRowContainsNull", ParameterizedType.type(Boolean.TYPE), new NamedParameterDefinition[0]).getBody();
        for (FieldDefinition probeCursorField : probeCursorFields) {
            LabelNode checkNextField = new LabelNode("checkNextField");
            body.pushThis().getField(probeCursorField).invokeInterface(BlockCursor.class, "isNull", Boolean.TYPE, new Class[0]).ifFalseGoto(checkNextField).push(true).retBoolean().visitLabel(checkNextField);
        }
        body.push(false).retInt();
    }

    private static <T> Class<? extends T> defineClass(ClassDefinition classDefinition, Class<T> superType, DynamicClassLoader classLoader) {
        Class<?> clazz = JoinProbeCompiler.defineClasses((List<ClassDefinition>)ImmutableList.of((Object)classDefinition), classLoader).values().iterator().next();
        return clazz.asSubclass(superType);
    }

    private static Map<String, Class<?>> defineClasses(List<ClassDefinition> classDefinitions, DynamicClassLoader classLoader) {
        ClassInfoLoader classInfoLoader = ClassInfoLoader.createClassInfoLoader(classDefinitions, classLoader);
        LinkedHashMap<String, byte[]> byteCodes = new LinkedHashMap<String, byte[]>();
        for (ClassDefinition classDefinition : classDefinitions) {
            SmartClassWriter cw = new SmartClassWriter(classInfoLoader);
            classDefinition.visit((ClassVisitor)cw);
            byte[] byteCode = cw.toByteArray();
            byteCodes.put(classDefinition.getType().getJavaClassName(), byteCode);
        }
        String dumpClassPath = DUMP_CLASS_FILES_TO.get();
        if (dumpClassPath != null) {
            for (Map.Entry entry : byteCodes.entrySet()) {
                File file = new File(dumpClassPath, ParameterizedType.typeFromJavaClassName((String)entry.getKey()).getClassName() + ".class");
                try {
                    log.debug("ClassFile: " + file.getAbsolutePath());
                    Files.createParentDirs((File)file);
                    Files.write((byte[])((byte[])entry.getValue()), (File)file);
                }
                catch (IOException e) {
                    log.error((Throwable)e, "Failed to write generated class file to: %s" + file.getAbsolutePath());
                }
            }
        }
        return classLoader.defineClasses(byteCodes);
    }

    public static void checkState(boolean left, boolean right) {
        if (left != right) {
            throw new IllegalStateException();
        }
    }

    private static class HashJoinOperatorFactoryFactory {
        private final JoinProbeFactory joinProbeFactory;
        private final Constructor<? extends OperatorFactory> constructor;

        private HashJoinOperatorFactoryFactory(JoinProbeFactory joinProbeFactory, Class<? extends OperatorFactory> operatorFactoryClass) {
            this.joinProbeFactory = joinProbeFactory;
            try {
                this.constructor = operatorFactoryClass.getConstructor(Integer.TYPE, LookupSourceSupplier.class, List.class, Boolean.TYPE, JoinProbeFactory.class);
            }
            catch (NoSuchMethodException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }

        public OperatorFactory createHashJoinOperatorFactory(int operatorId, LookupSourceSupplier lookupSourceSupplier, List<? extends Type> probeTypes, List<Integer> probeJoinChannel, boolean enableOuterJoin) {
            try {
                return this.constructor.newInstance(operatorId, lookupSourceSupplier, probeTypes, enableOuterJoin, this.joinProbeFactory);
            }
            catch (Exception e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
    }

    private static final class JoinOperatorCacheKey {
        private final List<Type> types;
        private final List<Integer> probeChannels;
        private final boolean enableOuterJoin;

        private JoinOperatorCacheKey(List<? extends Type> types, List<Integer> probeChannels, boolean enableOuterJoin) {
            this.types = ImmutableList.copyOf(types);
            this.probeChannels = ImmutableList.copyOf(probeChannels);
            this.enableOuterJoin = enableOuterJoin;
        }

        private List<Type> getTypes() {
            return this.types;
        }

        private List<Integer> getProbeChannels() {
            return this.probeChannels;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.types, this.probeChannels, this.enableOuterJoin});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof JoinOperatorCacheKey)) {
                return false;
            }
            JoinOperatorCacheKey other = (JoinOperatorCacheKey)obj;
            return Objects.equal(this.types, other.types) && Objects.equal(this.probeChannels, other.probeChannels) && Objects.equal((Object)this.enableOuterJoin, (Object)other.enableOuterJoin);
        }
    }

    public static class ReflectionJoinProbeFactory
    implements JoinProbeFactory {
        private final Constructor<? extends JoinProbe> constructor;

        public ReflectionJoinProbeFactory(Class<? extends JoinProbe> joinProbeClass) {
            try {
                this.constructor = joinProbeClass.getConstructor(LookupSource.class, Page.class);
            }
            catch (NoSuchMethodException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }

        @Override
        public JoinProbe createJoinProbe(LookupSource lookupSource, Page page) {
            try {
                return this.constructor.newInstance(lookupSource, page);
            }
            catch (Exception e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
    }
}

