/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.gen;

import com.facebook.presto.byteCode.Access;
import com.facebook.presto.byteCode.ClassDefinition;
import com.facebook.presto.byteCode.ClassInfoLoader;
import com.facebook.presto.byteCode.CompilerContext;
import com.facebook.presto.byteCode.DynamicClassLoader;
import com.facebook.presto.byteCode.FieldDefinition;
import com.facebook.presto.byteCode.LocalVariableDefinition;
import com.facebook.presto.byteCode.MethodDefinition;
import com.facebook.presto.byteCode.NamedParameterDefinition;
import com.facebook.presto.byteCode.OpCodes;
import com.facebook.presto.byteCode.ParameterizedType;
import com.facebook.presto.byteCode.SmartClassWriter;
import com.facebook.presto.byteCode.instruction.LabelNode;
import com.facebook.presto.operator.InMemoryJoinHash;
import com.facebook.presto.operator.LookupSource;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.PageBuilder;
import com.facebook.presto.operator.PagesHashStrategy;
import com.facebook.presto.operator.aggregation.IsolatedClass;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockCursor;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.gen.ExpressionCompiler;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.io.Files;
import com.google.common.util.concurrent.ExecutionError;
import com.google.common.util.concurrent.UncheckedExecutionException;
import io.airlift.log.Logger;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.objectweb.asm.ClassVisitor;

public class JoinCompiler {
    private static final Logger log = Logger.get(ExpressionCompiler.class);
    private static final AtomicLong CLASS_ID = new AtomicLong();
    private static final boolean DUMP_BYTE_CODE_TREE = false;
    private static final boolean DUMP_BYTE_CODE_RAW = false;
    private static final boolean RUN_ASM_VERIFIER = false;
    private static final AtomicReference<String> DUMP_CLASS_FILES_TO = new AtomicReference();
    private final Method bootstrapMethod = null;
    private final LoadingCache<LookupSourceCacheKey, LookupSourceFactory> lookupSourceFactories = CacheBuilder.newBuilder().maximumSize(1000L).build((CacheLoader)new CacheLoader<LookupSourceCacheKey, LookupSourceFactory>(){

        public LookupSourceFactory load(LookupSourceCacheKey key) throws Exception {
            return JoinCompiler.this.internalCompileLookupSourceFactory(key.getTypes(), key.getJoinChannels());
        }
    });

    public LookupSourceFactory compileLookupSourceFactory(List<? extends Type> types, List<Integer> joinChannels) {
        try {
            return (LookupSourceFactory)this.lookupSourceFactories.get((Object)new LookupSourceCacheKey(types, joinChannels));
        }
        catch (ExecutionError | UncheckedExecutionException | ExecutionException e) {
            throw Throwables.propagate((Throwable)e.getCause());
        }
    }

    @VisibleForTesting
    public LookupSourceFactory internalCompileLookupSourceFactory(List<? extends Type> types, List<Integer> joinChannels) {
        DynamicClassLoader classLoader = new DynamicClassLoader(this.getClass().getClassLoader());
        Class<? extends PagesHashStrategy> pagesHashStrategyClass = this.compilePagesHashStrategy(types.size(), joinChannels, classLoader);
        Class<InMemoryJoinHash> lookupSourceClass = IsolatedClass.isolateClass(classLoader, LookupSource.class, InMemoryJoinHash.class, new Class[0]);
        return new LookupSourceFactory(lookupSourceClass, new PagesHashStrategyFactory(pagesHashStrategyClass));
    }

    @VisibleForTesting
    public PagesHashStrategyFactory compilePagesHashStrategy(int channelCount, List<Integer> joinChannels) {
        DynamicClassLoader classLoader = new DynamicClassLoader(this.getClass().getClassLoader());
        Class<? extends PagesHashStrategy> pagesHashStrategyClass = this.compilePagesHashStrategy(channelCount, joinChannels, classLoader);
        return new PagesHashStrategyFactory(pagesHashStrategyClass);
    }

    private Class<? extends PagesHashStrategy> compilePagesHashStrategy(int channelCount, List<Integer> joinChannels, DynamicClassLoader classLoader) {
        ClassDefinition classDefinition = new ClassDefinition(new CompilerContext(this.bootstrapMethod), Access.a(Access.PUBLIC, Access.FINAL), ParameterizedType.typeFromPathName("PagesHashStrategy_" + CLASS_ID.incrementAndGet()), ParameterizedType.type(Object.class), ParameterizedType.type(PagesHashStrategy.class));
        ArrayList<FieldDefinition> channelFields = new ArrayList<FieldDefinition>();
        for (int i = 0; i < channelCount; ++i) {
            FieldDefinition channelField = classDefinition.declareField(Access.a(Access.PRIVATE, Access.FINAL), "channel_" + i, ParameterizedType.type(List.class, Block.class));
            channelFields.add(channelField);
        }
        ArrayList<FieldDefinition> joinChannelFields = new ArrayList<FieldDefinition>();
        for (int i = 0; i < joinChannels.size(); ++i) {
            FieldDefinition channelField = classDefinition.declareField(Access.a(Access.PRIVATE, Access.FINAL), "joinChannel_" + i, ParameterizedType.type(List.class, Block.class));
            joinChannelFields.add(channelField);
        }
        this.generateConstructor(classDefinition, joinChannels, channelFields, joinChannelFields);
        this.generateGetChannelCountMethod(classDefinition, channelFields);
        this.generateAppendToMethod(classDefinition, channelFields);
        this.generateHashPositionMethod(classDefinition, joinChannelFields);
        this.generatePositionEqualsCursorsMethod(classDefinition, joinChannelFields);
        this.generatePositionEqualsPositionMethod(classDefinition, joinChannelFields);
        Class<PagesHashStrategy> pagesHashStrategyClass = JoinCompiler.defineClass(classDefinition, PagesHashStrategy.class, classLoader);
        return pagesHashStrategyClass;
    }

    private void generateConstructor(ClassDefinition classDefinition, List<Integer> joinChannels, List<FieldDefinition> channelFields, List<FieldDefinition> joinChannelFields) {
        int index;
        com.facebook.presto.byteCode.Block constructor = classDefinition.declareConstructor(new CompilerContext(this.bootstrapMethod), Access.a(Access.PUBLIC), NamedParameterDefinition.arg("channels", ParameterizedType.type(List.class, ParameterizedType.type(List.class, Block.class)))).getBody().comment("super();").pushThis().invokeConstructor(Object.class, new Class[0]);
        constructor.comment("Set channel fields");
        for (index = 0; index < channelFields.size(); ++index) {
            constructor.pushThis().getVariable("channels").push(index).invokeInterface(List.class, "get", Object.class, Integer.TYPE).checkCast(ParameterizedType.type(List.class, Block.class)).putField(channelFields.get(index));
        }
        constructor.comment("Set join channel fields");
        for (index = 0; index < joinChannelFields.size(); ++index) {
            constructor.pushThis().getVariable("channels").push(joinChannels.get(index)).invokeInterface(List.class, "get", Object.class, Integer.TYPE).checkCast(ParameterizedType.type(List.class, Block.class)).putField(joinChannelFields.get(index));
        }
        constructor.ret();
    }

    private void generateGetChannelCountMethod(ClassDefinition classDefinition, List<FieldDefinition> channelFields) {
        classDefinition.declareMethod(new CompilerContext(this.bootstrapMethod), Access.a(Access.PUBLIC), "getChannelCount", ParameterizedType.type(Integer.TYPE), new NamedParameterDefinition[0]).getBody().push(channelFields.size()).retInt();
    }

    private void generateAppendToMethod(ClassDefinition classDefinition, List<FieldDefinition> channelFields) {
        com.facebook.presto.byteCode.Block appendToBody = classDefinition.declareMethod(new CompilerContext(this.bootstrapMethod), Access.a(Access.PUBLIC), "appendTo", ParameterizedType.type(Void.TYPE), NamedParameterDefinition.arg("blockIndex", Integer.TYPE), NamedParameterDefinition.arg("blockPosition", Integer.TYPE), NamedParameterDefinition.arg("pageBuilder", PageBuilder.class), NamedParameterDefinition.arg("outputChannelOffset", Integer.TYPE)).getBody();
        for (int index = 0; index < channelFields.size(); ++index) {
            appendToBody.pushThis().getField(channelFields.get(index)).getVariable("blockIndex").invokeInterface(List.class, "get", Object.class, Integer.TYPE).checkCast(Block.class).getVariable("blockPosition").getVariable("pageBuilder").getVariable("outputChannelOffset").push(index).append(OpCodes.IADD).invokeVirtual(PageBuilder.class, "getBlockBuilder", BlockBuilder.class, Integer.TYPE).invokeInterface(Block.class, "appendTo", Void.TYPE, Integer.TYPE, BlockBuilder.class);
        }
        appendToBody.ret();
    }

    private void generateHashPositionMethod(ClassDefinition classDefinition, List<FieldDefinition> joinChannelFields) {
        MethodDefinition hashPositionMethod = classDefinition.declareMethod(new CompilerContext(this.bootstrapMethod), Access.a(Access.PUBLIC), "hashPosition", ParameterizedType.type(Integer.TYPE), NamedParameterDefinition.arg("blockIndex", Integer.TYPE), NamedParameterDefinition.arg("blockPosition", Integer.TYPE));
        LocalVariableDefinition resultVariable = hashPositionMethod.getCompilerContext().declareVariable(Integer.TYPE, "result");
        hashPositionMethod.getBody().push(0).putVariable(resultVariable);
        for (FieldDefinition joinChannelField : joinChannelFields) {
            hashPositionMethod.getBody().getVariable(resultVariable).push(31).append(OpCodes.IMUL).pushThis().getField(joinChannelField).getVariable("blockIndex").invokeInterface(List.class, "get", Object.class, Integer.TYPE).checkCast(Block.class).getVariable("blockPosition").invokeInterface(Block.class, "hash", Integer.TYPE, Integer.TYPE).append(OpCodes.IADD).putVariable(resultVariable);
        }
        hashPositionMethod.getBody().getVariable(resultVariable).retInt();
    }

    private void generatePositionEqualsCursorsMethod(ClassDefinition classDefinition, List<FieldDefinition> joinChannelFields) {
        MethodDefinition hashPositionMethod = classDefinition.declareMethod(new CompilerContext(this.bootstrapMethod), Access.a(Access.PUBLIC), "positionEqualsCursors", ParameterizedType.type(Boolean.TYPE), NamedParameterDefinition.arg("blockIndex", Integer.TYPE), NamedParameterDefinition.arg("blockPosition", Integer.TYPE), NamedParameterDefinition.arg("cursors", BlockCursor[].class));
        for (int index = 0; index < joinChannelFields.size(); ++index) {
            LabelNode checkNextField = new LabelNode("checkNextField");
            hashPositionMethod.getBody().pushThis().getField(joinChannelFields.get(index)).getVariable("blockIndex").invokeInterface(List.class, "get", Object.class, Integer.TYPE).checkCast(Block.class).getVariable("blockPosition").getVariable("cursors").push(index).getObjectArrayElement().invokeInterface(Block.class, "equalTo", Boolean.TYPE, Integer.TYPE, BlockCursor.class).ifTrueGoto(checkNextField).push(false).retBoolean().visitLabel(checkNextField);
        }
        hashPositionMethod.getBody().push(true).retInt();
    }

    private void generatePositionEqualsPositionMethod(ClassDefinition classDefinition, List<FieldDefinition> joinChannelFields) {
        MethodDefinition hashPositionMethod = classDefinition.declareMethod(new CompilerContext(this.bootstrapMethod), Access.a(Access.PUBLIC), "positionEqualsPosition", ParameterizedType.type(Boolean.TYPE), NamedParameterDefinition.arg("leftBlockIndex", Integer.TYPE), NamedParameterDefinition.arg("leftBlockPosition", Integer.TYPE), NamedParameterDefinition.arg("rightBlockIndex", Integer.TYPE), NamedParameterDefinition.arg("rightBlockPosition", Integer.TYPE));
        for (FieldDefinition joinChannelField : joinChannelFields) {
            LabelNode checkNextField = new LabelNode("checkNextField");
            hashPositionMethod.getBody().pushThis().getField(joinChannelField).getVariable("leftBlockIndex").invokeInterface(List.class, "get", Object.class, Integer.TYPE).checkCast(Block.class).getVariable("leftBlockPosition").pushThis().getField(joinChannelField).getVariable("rightBlockIndex").invokeInterface(List.class, "get", Object.class, Integer.TYPE).checkCast(Block.class).getVariable("rightBlockPosition").invokeInterface(Block.class, "equalTo", Boolean.TYPE, Integer.TYPE, Block.class, Integer.TYPE).ifTrueGoto(checkNextField).push(false).retBoolean().visitLabel(checkNextField);
        }
        hashPositionMethod.getBody().push(true).retInt();
    }

    private static <T> Class<? extends T> defineClass(ClassDefinition classDefinition, Class<T> superType, DynamicClassLoader classLoader) {
        Class<?> clazz = JoinCompiler.defineClasses((List<ClassDefinition>)ImmutableList.of((Object)classDefinition), classLoader).values().iterator().next();
        return clazz.asSubclass(superType);
    }

    private static Map<String, Class<?>> defineClasses(List<ClassDefinition> classDefinitions, DynamicClassLoader classLoader) {
        ClassInfoLoader classInfoLoader = ClassInfoLoader.createClassInfoLoader(classDefinitions, classLoader);
        LinkedHashMap<String, byte[]> byteCodes = new LinkedHashMap<String, byte[]>();
        for (ClassDefinition classDefinition : classDefinitions) {
            SmartClassWriter cw = new SmartClassWriter(classInfoLoader);
            classDefinition.visit((ClassVisitor)cw);
            byte[] byteCode = cw.toByteArray();
            byteCodes.put(classDefinition.getType().getJavaClassName(), byteCode);
        }
        String dumpClassPath = DUMP_CLASS_FILES_TO.get();
        if (dumpClassPath != null) {
            for (Map.Entry entry : byteCodes.entrySet()) {
                File file = new File(dumpClassPath, ParameterizedType.typeFromJavaClassName((String)entry.getKey()).getClassName() + ".class");
                try {
                    log.debug("ClassFile: " + file.getAbsolutePath());
                    Files.createParentDirs((File)file);
                    Files.write((byte[])((byte[])entry.getValue()), (File)file);
                }
                catch (IOException e) {
                    log.error((Throwable)e, "Failed to write generated class file to: %s" + file.getAbsolutePath());
                }
            }
        }
        return classLoader.defineClasses(byteCodes);
    }

    private static final class LookupSourceCacheKey {
        private final List<Type> types;
        private final List<Integer> joinChannels;

        private LookupSourceCacheKey(List<? extends Type> types, List<Integer> joinChannels) {
            this.types = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(types, (Object)"types is null")));
            this.joinChannels = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(joinChannels, (Object)"joinChannels is null")));
        }

        private List<Type> getTypes() {
            return this.types;
        }

        private List<Integer> getJoinChannels() {
            return this.joinChannels;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.types, this.joinChannels});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof LookupSourceCacheKey)) {
                return false;
            }
            LookupSourceCacheKey other = (LookupSourceCacheKey)obj;
            return Objects.equal(this.types, other.types) && Objects.equal(this.joinChannels, other.joinChannels);
        }
    }

    public static class PagesHashStrategyFactory {
        private final Constructor<? extends PagesHashStrategy> constructor;

        public PagesHashStrategyFactory(Class<? extends PagesHashStrategy> pagesHashStrategyClass) {
            try {
                this.constructor = pagesHashStrategyClass.getConstructor(List.class);
            }
            catch (NoSuchMethodException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }

        public PagesHashStrategy createPagesHashStrategy(List<List<Block>> channels) {
            try {
                return this.constructor.newInstance(channels);
            }
            catch (Exception e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
    }

    public static class LookupSourceFactory {
        private final Constructor<? extends LookupSource> constructor;
        private final PagesHashStrategyFactory pagesHashStrategyFactory;

        public LookupSourceFactory(Class<? extends LookupSource> lookupSourceClass, PagesHashStrategyFactory pagesHashStrategyFactory) {
            this.pagesHashStrategyFactory = pagesHashStrategyFactory;
            try {
                this.constructor = lookupSourceClass.getConstructor(LongArrayList.class, PagesHashStrategy.class, OperatorContext.class);
            }
            catch (NoSuchMethodException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }

        public LookupSource createLookupSource(LongArrayList addresses, List<List<Block>> channels, OperatorContext operatorContext) {
            PagesHashStrategy pagesHashStrategy = this.pagesHashStrategyFactory.createPagesHashStrategy(channels);
            try {
                return this.constructor.newInstance(addresses, pagesHashStrategy, operatorContext);
            }
            catch (Exception e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
    }
}

