/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.gen;

import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.DefaultTraversalVisitor;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Node;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

public class ExpressionKey {
    private final Expression expression;
    private final List<Type> types;

    public ExpressionKey(Expression expression, final IdentityHashMap<Expression, Type> expressionTypes) {
        this.expression = (Expression)Preconditions.checkNotNull((Object)expression, (Object)"expression is null");
        Preconditions.checkNotNull(expressionTypes, (Object)"expressionTypes is null");
        final ImmutableList.Builder types = ImmutableList.builder();
        Type type = (Type)Preconditions.checkNotNull((Object)expressionTypes.get(expression), (String)"Expression types does not contain an entry for %s", (Object[])new Object[]{expression});
        types.add((Object)type);
        expression.accept((AstVisitor)new DefaultTraversalVisitor<Void, Void>(){

            public Void process(Node node, @Nullable Void context) {
                Expression expression = (Expression)node;
                Type type = (Type)expressionTypes.get(expression);
                Preconditions.checkState((expressionTypes.get(expression) != null ? 1 : 0) != 0, (String)"Expression types does not contain an entry for %s", (Object[])new Object[]{expression});
                types.add((Object)type);
                super.process(node, (Object)context);
                return null;
            }
        }, null);
        this.types = types.build();
    }

    public int hashCode() {
        return Objects.hash(this.expression, this.types);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ExpressionKey other = (ExpressionKey)obj;
        return Objects.equals(this.expression, other.expression) && Objects.equals(this.types, other.types);
    }

    public String toString() {
        return com.google.common.base.Objects.toStringHelper((Object)this).add("expression", (Object)this.expression).toString();
    }
}

