/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.gen;

import com.facebook.presto.byteCode.Access;
import com.facebook.presto.byteCode.Block;
import com.facebook.presto.byteCode.ByteCodeNode;
import com.facebook.presto.byteCode.ClassDefinition;
import com.facebook.presto.byteCode.ClassInfoLoader;
import com.facebook.presto.byteCode.CompilerContext;
import com.facebook.presto.byteCode.DynamicClassLoader;
import com.facebook.presto.byteCode.FieldDefinition;
import com.facebook.presto.byteCode.LocalVariableDefinition;
import com.facebook.presto.byteCode.MethodDefinition;
import com.facebook.presto.byteCode.NamedParameterDefinition;
import com.facebook.presto.byteCode.OpCodes;
import com.facebook.presto.byteCode.ParameterizedType;
import com.facebook.presto.byteCode.SmartClassWriter;
import com.facebook.presto.byteCode.control.ForLoop;
import com.facebook.presto.byteCode.control.IfStatement;
import com.facebook.presto.byteCode.instruction.LabelNode;
import com.facebook.presto.metadata.ColumnHandle;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.operator.AbstractFilterAndProjectOperator;
import com.facebook.presto.operator.AbstractScanFilterAndProjectOperator;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.Page;
import com.facebook.presto.operator.PageBuilder;
import com.facebook.presto.operator.SourceOperator;
import com.facebook.presto.operator.SourceOperatorFactory;
import com.facebook.presto.operator.aggregation.IsolatedClass;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.RecordCursor;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockCursor;
import com.facebook.presto.spi.type.TimeZoneKey;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.split.DataStreamProvider;
import com.facebook.presto.sql.gen.Bootstrap;
import com.facebook.presto.sql.gen.BootstrapFunctionBinder;
import com.facebook.presto.sql.gen.ByteCodeExpressionVisitor;
import com.facebook.presto.sql.gen.CompilerOperations;
import com.facebook.presto.sql.gen.ExpressionKey;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.InputReference;
import com.facebook.presto.sql.tree.Node;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.io.Files;
import io.airlift.log.Logger;
import io.airlift.slice.Slice;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Inject;
import org.objectweb.asm.ClassVisitor;
import org.weakref.jmx.Managed;

public class ExpressionCompiler {
    private static final Logger log = Logger.get(ExpressionCompiler.class);
    private static final AtomicLong CLASS_ID = new AtomicLong();
    private static final boolean DUMP_BYTE_CODE_TREE = false;
    private static final boolean DUMP_BYTE_CODE_RAW = false;
    private static final boolean RUN_ASM_VERIFIER = false;
    private static final AtomicReference<String> DUMP_CLASS_FILES_TO = new AtomicReference();
    private final Metadata metadata;
    private final LoadingCache<OperatorCacheKey, FilterAndProjectOperatorFactoryFactory> operatorFactories = CacheBuilder.newBuilder().maximumSize(1000L).build((CacheLoader)new CacheLoader<OperatorCacheKey, FilterAndProjectOperatorFactoryFactory>(){

        public FilterAndProjectOperatorFactoryFactory load(OperatorCacheKey key) throws Exception {
            return ExpressionCompiler.this.internalCompileFilterAndProjectOperator(key.getFilter(), key.getProjections(), key.getExpressionTypes(), key.getTimeZoneKey());
        }
    });
    private final LoadingCache<OperatorCacheKey, ScanFilterAndProjectOperatorFactoryFactory> sourceOperatorFactories = CacheBuilder.newBuilder().maximumSize(1000L).build((CacheLoader)new CacheLoader<OperatorCacheKey, ScanFilterAndProjectOperatorFactoryFactory>(){

        public ScanFilterAndProjectOperatorFactoryFactory load(OperatorCacheKey key) throws Exception {
            return ExpressionCompiler.this.internalCompileScanFilterAndProjectOperator(key.getSourceId(), key.getFilter(), key.getProjections(), key.getExpressionTypes(), key.getTimeZoneKey());
        }
    });
    private final AtomicLong generatedClasses = new AtomicLong();

    @Inject
    public ExpressionCompiler(Metadata metadata) {
        this.metadata = metadata;
    }

    @Managed
    public long getGeneratedClasses() {
        return this.generatedClasses.get();
    }

    @Managed
    public long getCachedFilterAndProjectOperators() {
        return this.operatorFactories.size();
    }

    @Managed
    public long getCachedScanFilterAndProjectOperators() {
        return this.sourceOperatorFactories.size();
    }

    public OperatorFactory compileFilterAndProjectOperator(int operatorId, Expression filter, List<Expression> projections, IdentityHashMap<Expression, Type> expressionTypes, TimeZoneKey timeZoneKey) {
        return ((FilterAndProjectOperatorFactoryFactory)this.operatorFactories.getUnchecked((Object)new OperatorCacheKey(filter, projections, expressionTypes, null, timeZoneKey))).create(operatorId);
    }

    private DynamicClassLoader createClassLoader() {
        return new DynamicClassLoader(this.getClass().getClassLoader());
    }

    @VisibleForTesting
    public FilterAndProjectOperatorFactoryFactory internalCompileFilterAndProjectOperator(Expression filter, List<Expression> projections, IdentityHashMap<Expression, Type> expressionTypes, TimeZoneKey timeZoneKey) {
        Constructor constructor;
        DynamicClassLoader classLoader = this.createClassLoader();
        TypedOperatorClass typedOperatorClass = this.compileFilterAndProjectOperator(filter, projections, expressionTypes, classLoader, timeZoneKey);
        try {
            constructor = typedOperatorClass.getOperatorClass().getConstructor(OperatorContext.class, Iterable.class);
        }
        catch (NoSuchMethodException e) {
            throw Throwables.propagate((Throwable)e);
        }
        FilterAndProjectOperatorFactoryFactory operatorFactoryFactory = new FilterAndProjectOperatorFactoryFactory(constructor, typedOperatorClass.getTypes());
        return operatorFactoryFactory;
    }

    private TypedOperatorClass compileFilterAndProjectOperator(Expression filter, List<Expression> projections, IdentityHashMap<Expression, Type> expressionTypes, DynamicClassLoader classLoader, TimeZoneKey timeZoneKey) {
        BootstrapEntry bootstrap = BootstrapEntry.makeBootstrap(classLoader, this.metadata);
        ClassDefinition classDefinition = new ClassDefinition(new CompilerContext(bootstrap.getBootstrapMethod()), Access.a(Access.PUBLIC, Access.FINAL), ParameterizedType.typeFromPathName("FilterAndProjectOperator_" + CLASS_ID.incrementAndGet()), ParameterizedType.type(AbstractFilterAndProjectOperator.class), new ParameterizedType[0]);
        FieldDefinition sessionField = classDefinition.declareField(Access.a(Access.PRIVATE, Access.FINAL), "session", ConnectorSession.class);
        classDefinition.declareConstructor(new CompilerContext(bootstrap.getBootstrapMethod()), Access.a(Access.PUBLIC), NamedParameterDefinition.arg("operatorContext", OperatorContext.class), NamedParameterDefinition.arg("types", ParameterizedType.type(Iterable.class, Type.class))).getBody().comment("super(operatorContext, types);").pushThis().getVariable("operatorContext").getVariable("types").invokeConstructor(AbstractFilterAndProjectOperator.class, OperatorContext.class, Iterable.class).comment("this.session = operatorContext.getSession();").pushThis().getVariable("operatorContext").invokeVirtual(OperatorContext.class, "getSession", ConnectorSession.class, new Class[0]).putField(sessionField).ret();
        this.generateFilterAndProjectRowOriented(bootstrap, classDefinition, projections, expressionTypes);
        this.generateFilterMethod(bootstrap, classDefinition, filter, expressionTypes, true, timeZoneKey);
        this.generateFilterMethod(bootstrap, classDefinition, filter, expressionTypes, false, timeZoneKey);
        ArrayList<Type> types = new ArrayList<Type>();
        int projectionIndex = 0;
        for (Expression projection : projections) {
            this.generateProjectMethod(bootstrap, classDefinition, "project_" + projectionIndex, projection, expressionTypes, true, timeZoneKey);
            this.generateProjectMethod(bootstrap, classDefinition, "project_" + projectionIndex, projection, expressionTypes, false, timeZoneKey);
            types.add(expressionTypes.get(projection));
            ++projectionIndex;
        }
        classDefinition.declareMethod(new CompilerContext(bootstrap.getBootstrapMethod()), Access.a(Access.PUBLIC), "toString", ParameterizedType.type(String.class), new NamedParameterDefinition[0]).getBody().push(Objects.toStringHelper((String)classDefinition.getType().getJavaClassName()).add("filter", (Object)filter).add("projections", projections).toString()).retObject();
        Class<Operator> filterAndProjectClass = this.defineClass(classDefinition, Operator.class, classLoader);
        return new TypedOperatorClass(filterAndProjectClass, types);
    }

    public SourceOperatorFactory compileScanFilterAndProjectOperator(int operatorId, PlanNodeId sourceId, DataStreamProvider dataStreamProvider, List<ColumnHandle> columns, Expression filter, List<Expression> projections, IdentityHashMap<Expression, Type> expressionTypes, TimeZoneKey timeZoneKey) {
        OperatorCacheKey cacheKey = new OperatorCacheKey(filter, projections, expressionTypes, sourceId, timeZoneKey);
        return ((ScanFilterAndProjectOperatorFactoryFactory)this.sourceOperatorFactories.getUnchecked((Object)cacheKey)).create(operatorId, dataStreamProvider, columns);
    }

    @VisibleForTesting
    public ScanFilterAndProjectOperatorFactoryFactory internalCompileScanFilterAndProjectOperator(PlanNodeId sourceId, Expression filter, List<Expression> projections, IdentityHashMap<Expression, Type> expressionTypes, TimeZoneKey timeZoneKey) {
        Constructor<SourceOperator> constructor;
        DynamicClassLoader classLoader = this.createClassLoader();
        TypedOperatorClass typedOperatorClass = this.compileScanFilterAndProjectOperator(filter, projections, expressionTypes, classLoader, timeZoneKey);
        try {
            constructor = typedOperatorClass.getOperatorClass().asSubclass(SourceOperator.class).getConstructor(OperatorContext.class, PlanNodeId.class, DataStreamProvider.class, Iterable.class, Iterable.class);
        }
        catch (NoSuchMethodException e) {
            throw Throwables.propagate((Throwable)e);
        }
        ScanFilterAndProjectOperatorFactoryFactory operatorFactoryFactory = new ScanFilterAndProjectOperatorFactoryFactory(constructor, sourceId, typedOperatorClass.getTypes());
        return operatorFactoryFactory;
    }

    private TypedOperatorClass compileScanFilterAndProjectOperator(Expression filter, List<Expression> projections, IdentityHashMap<Expression, Type> expressionTypes, DynamicClassLoader classLoader, TimeZoneKey timeZoneKey) {
        BootstrapEntry bootstrap = BootstrapEntry.makeBootstrap(classLoader, this.metadata);
        ClassDefinition classDefinition = new ClassDefinition(new CompilerContext(bootstrap.getBootstrapMethod()), Access.a(Access.PUBLIC, Access.FINAL), ParameterizedType.typeFromPathName("ScanFilterAndProjectOperator_" + CLASS_ID.incrementAndGet()), ParameterizedType.type(AbstractScanFilterAndProjectOperator.class), new ParameterizedType[0]);
        FieldDefinition sessionField = classDefinition.declareField(Access.a(Access.PRIVATE, Access.FINAL), "session", ConnectorSession.class);
        classDefinition.declareConstructor(new CompilerContext(bootstrap.getBootstrapMethod()), Access.a(Access.PUBLIC), NamedParameterDefinition.arg("operatorContext", OperatorContext.class), NamedParameterDefinition.arg("sourceId", PlanNodeId.class), NamedParameterDefinition.arg("dataStreamProvider", DataStreamProvider.class), NamedParameterDefinition.arg("columns", ParameterizedType.type(Iterable.class, ColumnHandle.class)), NamedParameterDefinition.arg("types", ParameterizedType.type(Iterable.class, Type.class))).getBody().comment("super(operatorContext, sourceId, dataStreamProvider, columns, types);").pushThis().getVariable("operatorContext").getVariable("sourceId").getVariable("dataStreamProvider").getVariable("columns").getVariable("types").invokeConstructor(AbstractScanFilterAndProjectOperator.class, OperatorContext.class, PlanNodeId.class, DataStreamProvider.class, Iterable.class, Iterable.class).comment("this.session = operatorContext.getSession();").pushThis().getVariable("operatorContext").invokeVirtual(OperatorContext.class, "getSession", ConnectorSession.class, new Class[0]).putField(sessionField).ret();
        this.generateFilterAndProjectRowOriented(bootstrap, classDefinition, projections, expressionTypes);
        this.generateFilterAndProjectCursorMethod(bootstrap, classDefinition, projections);
        this.generateFilterMethod(bootstrap, classDefinition, filter, expressionTypes, true, timeZoneKey);
        this.generateFilterMethod(bootstrap, classDefinition, filter, expressionTypes, false, timeZoneKey);
        ArrayList<Type> types = new ArrayList<Type>();
        int projectionIndex = 0;
        for (Expression projection : projections) {
            this.generateProjectMethod(bootstrap, classDefinition, "project_" + projectionIndex, projection, expressionTypes, true, timeZoneKey);
            this.generateProjectMethod(bootstrap, classDefinition, "project_" + projectionIndex, projection, expressionTypes, false, timeZoneKey);
            types.add(expressionTypes.get(projection));
            ++projectionIndex;
        }
        classDefinition.declareMethod(new CompilerContext(bootstrap.getBootstrapMethod()), Access.a(Access.PUBLIC), "toString", ParameterizedType.type(String.class), new NamedParameterDefinition[0]).getBody().push(Objects.toStringHelper((String)classDefinition.getType().getJavaClassName()).add("filter", (Object)filter).add("projections", projections).toString()).retObject();
        Class<SourceOperator> filterAndProjectClass = this.defineClass(classDefinition, SourceOperator.class, classLoader);
        return new TypedOperatorClass(filterAndProjectClass, types);
    }

    private void generateFilterAndProjectRowOriented(BootstrapEntry bootstrap, ClassDefinition classDefinition, List<Expression> projections, IdentityHashMap<Expression, Type> expressionTypes) {
        MethodDefinition filterAndProjectMethod = classDefinition.declareMethod(new CompilerContext(bootstrap.getBootstrapMethod()), Access.a(Access.PUBLIC), "filterAndProjectRowOriented", ParameterizedType.type(Void.TYPE), NamedParameterDefinition.arg("page", Page.class), NamedParameterDefinition.arg("pageBuilder", PageBuilder.class));
        CompilerContext compilerContext = filterAndProjectMethod.getCompilerContext();
        LocalVariableDefinition positionVariable = compilerContext.declareVariable(Integer.TYPE, "position");
        LocalVariableDefinition rowsVariable = compilerContext.declareVariable(Integer.TYPE, "rows");
        filterAndProjectMethod.getBody().comment("int rows = page.getPositionCount();").getVariable("page").invokeVirtual(Page.class, "getPositionCount", Integer.TYPE, new Class[0]).putVariable(rowsVariable);
        ArrayList<LocalVariableDefinition> cursorVariables = new ArrayList<LocalVariableDefinition>();
        List<Integer> inputChannels = ExpressionCompiler.getInputChannels(expressionTypes.keySet());
        for (int channel : inputChannels) {
            LocalVariableDefinition cursorVariable = compilerContext.declareVariable(BlockCursor.class, "cursor_" + channel);
            cursorVariables.add(cursorVariable);
            filterAndProjectMethod.getBody().comment("BlockCursor %s = page.getBlock(%s).cursor();", cursorVariable.getName(), channel).getVariable("page").push(channel).invokeVirtual(Page.class, "getBlock", com.facebook.presto.spi.block.Block.class, Integer.TYPE).invokeInterface(com.facebook.presto.spi.block.Block.class, "cursor", BlockCursor.class, new Class[0]).putVariable(cursorVariable);
        }
        ForLoop.ForLoopBuilder forLoop = ForLoop.forLoopBuilder(compilerContext).comment("for (position = 0; position < rows; position++)", new Object[0]).initialize(new Block(compilerContext).putVariable(positionVariable, 0)).condition(new Block(compilerContext).getVariable(positionVariable).getVariable(rowsVariable).invokeStatic(CompilerOperations.class, "lessThan", Boolean.TYPE, Integer.TYPE, Integer.TYPE)).update(new Block(compilerContext).incrementVariable(positionVariable, (byte)1));
        Block forLoopBody = new Block(compilerContext);
        for (LocalVariableDefinition cursorVariable : cursorVariables) {
            forLoopBody.comment("checkState(%s.advanceNextPosition());", cursorVariable.getName()).getVariable(cursorVariable).invokeInterface(BlockCursor.class, "advanceNextPosition", Boolean.TYPE, new Class[0]).invokeStatic(Preconditions.class, "checkState", Void.TYPE, Boolean.TYPE);
        }
        IfStatement.IfStatementBuilder ifStatement = new IfStatement.IfStatementBuilder(compilerContext).comment("if (filter(cursors...)", new Object[0]);
        Block condition = new Block(compilerContext);
        condition.pushThis();
        for (int channel : inputChannels) {
            condition.getVariable("cursor_" + channel);
        }
        condition.invokeVirtual(classDefinition.getType(), "filter", ParameterizedType.type(Boolean.TYPE), Collections.nCopies(inputChannels.size(), ParameterizedType.type(BlockCursor.class)));
        ifStatement.condition(condition);
        Block trueBlock = new Block(compilerContext);
        if (projections.isEmpty()) {
            trueBlock.comment("pageBuilder.declarePosition()").getVariable("pageBuilder").invokeVirtual(PageBuilder.class, "declarePosition", Void.TYPE, new Class[0]);
        } else {
            for (int projectionIndex = 0; projectionIndex < projections.size(); ++projectionIndex) {
                trueBlock.comment("project_%s(cursors..., pageBuilder.getBlockBuilder(%s))", projectionIndex, projectionIndex);
                trueBlock.pushThis();
                for (int channel : inputChannels) {
                    trueBlock.getVariable("cursor_" + channel);
                }
                trueBlock.getVariable("pageBuilder").push(projectionIndex).invokeVirtual(PageBuilder.class, "getBlockBuilder", BlockBuilder.class, Integer.TYPE);
                trueBlock.invokeVirtual(classDefinition.getType(), "project_" + projectionIndex, ParameterizedType.type(Void.TYPE), (Iterable<ParameterizedType>)ImmutableList.builder().addAll(Collections.nCopies(inputChannels.size(), ParameterizedType.type(BlockCursor.class))).add((Object)ParameterizedType.type(BlockBuilder.class)).build());
            }
        }
        ifStatement.ifTrue(trueBlock);
        forLoopBody.append(ifStatement.build());
        filterAndProjectMethod.getBody().append(forLoop.body(forLoopBody).build());
        for (LocalVariableDefinition cursorVariable : cursorVariables) {
            filterAndProjectMethod.getBody().comment("checkState(not(%s.advanceNextPosition))", cursorVariable.getName()).getVariable(cursorVariable).invokeInterface(BlockCursor.class, "advanceNextPosition", Boolean.TYPE, new Class[0]).invokeStatic(CompilerOperations.class, "not", Boolean.TYPE, Boolean.TYPE).invokeStatic(Preconditions.class, "checkState", Void.TYPE, Boolean.TYPE);
        }
        filterAndProjectMethod.getBody().ret();
    }

    private void generateFilterAndProjectCursorMethod(BootstrapEntry bootstrap, ClassDefinition classDefinition, List<Expression> projections) {
        MethodDefinition filterAndProjectMethod = classDefinition.declareMethod(new CompilerContext(bootstrap.getBootstrapMethod()), Access.a(Access.PUBLIC), "filterAndProjectRowOriented", ParameterizedType.type(Integer.TYPE), NamedParameterDefinition.arg("cursor", RecordCursor.class), NamedParameterDefinition.arg("pageBuilder", PageBuilder.class));
        CompilerContext compilerContext = filterAndProjectMethod.getCompilerContext();
        LocalVariableDefinition completedPositionsVariable = compilerContext.declareVariable(Integer.TYPE, "completedPositions");
        filterAndProjectMethod.getBody().comment("int completedPositions = 0;").putVariable(completedPositionsVariable, 0);
        LabelNode done = new LabelNode("done");
        ForLoop.ForLoopBuilder forLoop = ForLoop.forLoopBuilder(compilerContext).initialize(OpCodes.NOP).condition(new Block(compilerContext).comment("completedPositions < 16384").getVariable(completedPositionsVariable).push(16384).invokeStatic(CompilerOperations.class, "lessThan", Boolean.TYPE, Integer.TYPE, Integer.TYPE)).update(new Block(compilerContext).comment("completedPositions++").incrementVariable(completedPositionsVariable, (byte)1));
        Block forLoopBody = new Block(compilerContext);
        forLoop.body(forLoopBody);
        forLoopBody.comment("if (pageBuilder.isFull()) break;").append(new Block(compilerContext).getVariable("pageBuilder").invokeVirtual(PageBuilder.class, "isFull", Boolean.TYPE, new Class[0]).ifTrueGoto(done));
        forLoopBody.comment("if (!cursor.advanceNextPosition()) break;").append(new Block(compilerContext).getVariable("cursor").invokeInterface(RecordCursor.class, "advanceNextPosition", Boolean.TYPE, new Class[0]).ifFalseGoto(done));
        IfStatement.IfStatementBuilder ifStatement = new IfStatement.IfStatementBuilder(compilerContext);
        ifStatement.condition(new Block(compilerContext).pushThis().getVariable("cursor").invokeVirtual(classDefinition.getType(), "filter", ParameterizedType.type(Boolean.TYPE), ParameterizedType.type(RecordCursor.class)));
        Block trueBlock = new Block(compilerContext);
        ifStatement.ifTrue(trueBlock);
        if (projections.isEmpty()) {
            trueBlock.getVariable("pageBuilder").invokeVirtual(PageBuilder.class, "declarePosition", Void.TYPE, new Class[0]);
        } else {
            for (int projectionIndex = 0; projectionIndex < projections.size(); ++projectionIndex) {
                trueBlock.pushThis();
                trueBlock.getVariable("cursor");
                trueBlock.getVariable("pageBuilder").push(projectionIndex).invokeVirtual(PageBuilder.class, "getBlockBuilder", BlockBuilder.class, Integer.TYPE);
                trueBlock.invokeVirtual(classDefinition.getType(), "project_" + projectionIndex, ParameterizedType.type(Void.TYPE), ParameterizedType.type(RecordCursor.class), ParameterizedType.type(BlockBuilder.class));
            }
        }
        forLoopBody.append(ifStatement.build());
        filterAndProjectMethod.getBody().append(forLoop.build()).visitLabel(done).comment("return completedPositions;").getVariable("completedPositions").retInt();
    }

    private void generateFilterMethod(BootstrapEntry bootstrap, ClassDefinition classDefinition, Expression filter, IdentityHashMap<Expression, Type> expressionTypes, boolean sourceIsCursor, TimeZoneKey timeZoneKey) {
        MethodDefinition filterMethod = sourceIsCursor ? classDefinition.declareMethod(new CompilerContext(bootstrap.getBootstrapMethod()), Access.a(Access.PUBLIC), "filter", ParameterizedType.type(Boolean.TYPE), NamedParameterDefinition.arg("cursor", RecordCursor.class)) : classDefinition.declareMethod(new CompilerContext(bootstrap.getBootstrapMethod()), Access.a(Access.PUBLIC), "filter", ParameterizedType.type(Boolean.TYPE), this.toBlockCursorParameters(ExpressionCompiler.getInputChannels(expressionTypes.keySet())));
        filterMethod.comment("Filter: %s", filter.toString());
        filterMethod.getCompilerContext().declareVariable(ParameterizedType.type(Boolean.TYPE), "wasNull");
        Block getSessionByteCode = new Block(filterMethod.getCompilerContext()).pushThis().getField(classDefinition.getType(), "session", ParameterizedType.type(ConnectorSession.class));
        ByteCodeExpressionVisitor visitor = new ByteCodeExpressionVisitor(this.metadata, bootstrap.getFunctionBinder(), expressionTypes, getSessionByteCode, sourceIsCursor, timeZoneKey);
        ByteCodeNode body = (ByteCodeNode)visitor.process((Node)filter, filterMethod.getCompilerContext());
        LabelNode end = new LabelNode("end");
        filterMethod.getBody().comment("boolean wasNull = false;").putVariable("wasNull", false).append(body).getVariable("wasNull").ifFalseGoto(end).pop(Boolean.TYPE).push(false).visitLabel(end).retBoolean();
    }

    private Class<?> generateProjectMethod(BootstrapEntry bootstrap, ClassDefinition classDefinition, String methodName, Expression projection, IdentityHashMap<Expression, Type> expressionTypes, boolean sourceIsCursor, TimeZoneKey timeZoneKey) {
        MethodDefinition projectionMethod;
        if (sourceIsCursor) {
            projectionMethod = classDefinition.declareMethod(new CompilerContext(bootstrap.getBootstrapMethod()), Access.a(Access.PUBLIC), methodName, ParameterizedType.type(Void.TYPE), NamedParameterDefinition.arg("cursor", RecordCursor.class), NamedParameterDefinition.arg("output", BlockBuilder.class));
        } else {
            ImmutableList.Builder parameters = ImmutableList.builder();
            parameters.addAll(this.toBlockCursorParameters(ExpressionCompiler.getInputChannels(expressionTypes.keySet())));
            parameters.add((Object)NamedParameterDefinition.arg("output", BlockBuilder.class));
            projectionMethod = classDefinition.declareMethod(new CompilerContext(bootstrap.getBootstrapMethod()), Access.a(Access.PUBLIC), methodName, ParameterizedType.type(Void.TYPE), (Iterable<NamedParameterDefinition>)parameters.build());
        }
        projectionMethod.comment("Projection: %s", projection.toString());
        CompilerContext context = projectionMethod.getCompilerContext();
        context.declareVariable(ParameterizedType.type(Boolean.TYPE), "wasNull");
        Block getSessionByteCode = new Block(context).pushThis().getField(classDefinition.getType(), "session", ParameterizedType.type(ConnectorSession.class));
        ByteCodeExpressionVisitor visitor = new ByteCodeExpressionVisitor(this.metadata, bootstrap.getFunctionBinder(), expressionTypes, getSessionByteCode, sourceIsCursor, timeZoneKey);
        ByteCodeNode body = (ByteCodeNode)visitor.process((Node)projection, context);
        projectionMethod.getBody().comment("boolean wasNull = false;").putVariable("wasNull", false).getVariable("output").append(body);
        Type projectionType = expressionTypes.get(projection);
        Block notNullBlock = new Block(context);
        if (projectionType.getJavaType() == Boolean.TYPE) {
            notNullBlock.comment("output.append(<booleanStackValue>);").invokeInterface(BlockBuilder.class, "appendBoolean", BlockBuilder.class, Boolean.TYPE).pop();
        } else if (projectionType.getJavaType() == Long.TYPE) {
            notNullBlock.comment("output.append(<longStackValue>);").invokeInterface(BlockBuilder.class, "appendLong", BlockBuilder.class, Long.TYPE).pop();
        } else if (projectionType.getJavaType() == Double.TYPE) {
            notNullBlock.comment("output.append(<doubleStackValue>);").invokeInterface(BlockBuilder.class, "appendDouble", BlockBuilder.class, Double.TYPE).pop();
        } else if (projectionType.getJavaType() == Slice.class) {
            notNullBlock.comment("output.append(<sliceStackValue>);").invokeInterface(BlockBuilder.class, "appendSlice", BlockBuilder.class, Slice.class).pop();
        } else {
            throw new UnsupportedOperationException("Type " + projectionType + " can not be output yet");
        }
        Block nullBlock = new Block(context).comment("output.appendNull();").pop(projectionType.getJavaType()).invokeInterface(BlockBuilder.class, "appendNull", BlockBuilder.class, new Class[0]).pop();
        projectionMethod.getBody().comment("if the result was null, appendNull; otherwise append the value").append(new IfStatement(context, new Block(context).getVariable("wasNull"), nullBlock, notNullBlock)).ret();
        return projectionType.getJavaType();
    }

    private static List<Integer> getInputChannels(Set<Expression> expressions) {
        TreeSet<Integer> channels = new TreeSet<Integer>();
        for (Expression expression : expressions) {
            if (!(expression instanceof InputReference)) continue;
            channels.add(((InputReference)expression).getInput().getChannel());
        }
        return ImmutableList.copyOf(channels);
    }

    private List<NamedParameterDefinition> toBlockCursorParameters(List<Integer> inputChannels) {
        ImmutableList.Builder parameters = ImmutableList.builder();
        for (int channel : inputChannels) {
            parameters.add((Object)NamedParameterDefinition.arg("channel_" + channel, BlockCursor.class));
        }
        return parameters.build();
    }

    private <T> Class<? extends T> defineClass(ClassDefinition classDefinition, Class<T> superType, DynamicClassLoader classLoader) {
        Class<?> clazz = this.defineClasses((List<ClassDefinition>)ImmutableList.of((Object)classDefinition), classLoader).values().iterator().next();
        return clazz.asSubclass(superType);
    }

    private Map<String, Class<?>> defineClasses(List<ClassDefinition> classDefinitions, DynamicClassLoader classLoader) {
        ClassInfoLoader classInfoLoader = ClassInfoLoader.createClassInfoLoader(classDefinitions, classLoader);
        LinkedHashMap<String, byte[]> byteCodes = new LinkedHashMap<String, byte[]>();
        for (ClassDefinition classDefinition : classDefinitions) {
            SmartClassWriter cw = new SmartClassWriter(classInfoLoader);
            classDefinition.visit((ClassVisitor)cw);
            byte[] byteCode = cw.toByteArray();
            byteCodes.put(classDefinition.getType().getJavaClassName(), byteCode);
        }
        String dumpClassPath = DUMP_CLASS_FILES_TO.get();
        if (dumpClassPath != null) {
            for (Map.Entry entry : byteCodes.entrySet()) {
                File file = new File(dumpClassPath, ParameterizedType.typeFromJavaClassName((String)entry.getKey()).getClassName() + ".class");
                try {
                    log.debug("ClassFile: " + file.getAbsolutePath());
                    Files.createParentDirs((File)file);
                    Files.write((byte[])((byte[])entry.getValue()), (File)file);
                }
                catch (IOException e) {
                    log.error((Throwable)e, "Failed to write generated class file to: %s" + file.getAbsolutePath());
                }
            }
        }
        Map<String, Class<?>> classes = classLoader.defineClasses(byteCodes);
        this.generatedClasses.addAndGet(classes.size());
        return classes;
    }

    private static class ScanFilterAndProjectOperatorFactory
    implements SourceOperatorFactory {
        private final Constructor<? extends SourceOperator> constructor;
        private final int operatorId;
        private final PlanNodeId sourceId;
        private final DataStreamProvider dataStreamProvider;
        private final List<ColumnHandle> columns;
        private final List<Type> types;
        private boolean closed;

        public ScanFilterAndProjectOperatorFactory(Constructor<? extends SourceOperator> constructor, int operatorId, PlanNodeId sourceId, DataStreamProvider dataStreamProvider, List<ColumnHandle> columns, List<Type> types) {
            this.constructor = (Constructor)Preconditions.checkNotNull(constructor, (Object)"constructor is null");
            this.operatorId = operatorId;
            this.sourceId = (PlanNodeId)Preconditions.checkNotNull((Object)sourceId, (Object)"sourceId is null");
            this.dataStreamProvider = (DataStreamProvider)Preconditions.checkNotNull((Object)dataStreamProvider, (Object)"dataStreamProvider is null");
            this.columns = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(columns, (Object)"columns is null")));
            this.types = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(types, (Object)"types is null")));
        }

        @Override
        public PlanNodeId getSourceId() {
            return this.sourceId;
        }

        @Override
        public List<Type> getTypes() {
            return this.types;
        }

        @Override
        public SourceOperator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, this.constructor.getDeclaringClass().getSimpleName());
            try {
                return this.constructor.newInstance(operatorContext, this.sourceId, this.dataStreamProvider, this.columns, this.types);
            }
            catch (InvocationTargetException e) {
                throw Throwables.propagate((Throwable)e.getCause());
            }
            catch (ReflectiveOperationException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }

        @Override
        public void close() {
            this.closed = true;
        }
    }

    private static class ScanFilterAndProjectOperatorFactoryFactory {
        private final Constructor<? extends SourceOperator> constructor;
        private final PlanNodeId sourceId;
        private final List<Type> types;

        public ScanFilterAndProjectOperatorFactoryFactory(Constructor<? extends SourceOperator> constructor, PlanNodeId sourceId, List<Type> types) {
            this.sourceId = (PlanNodeId)Preconditions.checkNotNull((Object)sourceId, (Object)"sourceId is null");
            this.constructor = (Constructor)Preconditions.checkNotNull(constructor, (Object)"constructor is null");
            this.types = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(types, (Object)"types is null")));
        }

        public SourceOperatorFactory create(int operatorId, DataStreamProvider dataStreamProvider, List<ColumnHandle> columns) {
            return new ScanFilterAndProjectOperatorFactory(this.constructor, operatorId, this.sourceId, dataStreamProvider, columns, this.types);
        }
    }

    private static class FilterAndProjectOperatorFactory
    implements OperatorFactory {
        private final Constructor<? extends Operator> constructor;
        private final int operatorId;
        private final List<Type> types;
        private boolean closed;

        public FilterAndProjectOperatorFactory(Constructor<? extends Operator> constructor, int operatorId, List<Type> types) {
            this.constructor = (Constructor)Preconditions.checkNotNull(constructor, (Object)"constructor is null");
            this.operatorId = operatorId;
            this.types = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(types, (Object)"types is null")));
        }

        @Override
        public List<Type> getTypes() {
            return this.types;
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, this.constructor.getDeclaringClass().getSimpleName());
            try {
                return this.constructor.newInstance(operatorContext, this.types);
            }
            catch (InvocationTargetException e) {
                throw Throwables.propagate((Throwable)e.getCause());
            }
            catch (ReflectiveOperationException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }

        @Override
        public void close() {
            this.closed = true;
        }
    }

    private static class FilterAndProjectOperatorFactoryFactory {
        private final Constructor<? extends Operator> constructor;
        private final List<Type> types;

        public FilterAndProjectOperatorFactoryFactory(Constructor<? extends Operator> constructor, List<Type> types) {
            this.constructor = (Constructor)Preconditions.checkNotNull(constructor, (Object)"constructor is null");
            this.types = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(types, (Object)"types is null")));
        }

        public OperatorFactory create(int operatorId) {
            return new FilterAndProjectOperatorFactory(this.constructor, operatorId, this.types);
        }
    }

    private static final class OperatorCacheKey {
        private final Expression filter;
        private final List<Expression> projections;
        private final IdentityHashMap<Expression, Type> expressionTypes;
        private final PlanNodeId sourceId;
        private final TimeZoneKey timeZoneKey;
        private final List<ExpressionKey> expressionKeys;

        private OperatorCacheKey(Expression filter, List<Expression> projections, IdentityHashMap<Expression, Type> expressionTypes, PlanNodeId sourceId, TimeZoneKey timeZoneKey) {
            this.filter = filter;
            this.projections = ImmutableList.copyOf(projections);
            this.expressionTypes = expressionTypes;
            this.sourceId = sourceId;
            this.timeZoneKey = timeZoneKey;
            ImmutableList.Builder expressionKeys = ImmutableList.builder();
            expressionKeys.add((Object)new ExpressionKey(filter, expressionTypes));
            for (Expression projection : projections) {
                expressionKeys.add((Object)new ExpressionKey(projection, expressionTypes));
            }
            this.expressionKeys = expressionKeys.build();
        }

        private Expression getFilter() {
            return this.filter;
        }

        private List<Expression> getProjections() {
            return this.projections;
        }

        private IdentityHashMap<Expression, Type> getExpressionTypes() {
            return this.expressionTypes;
        }

        private PlanNodeId getSourceId() {
            return this.sourceId;
        }

        public TimeZoneKey getTimeZoneKey() {
            return this.timeZoneKey;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.expressionKeys, this.sourceId, this.timeZoneKey});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            OperatorCacheKey other = (OperatorCacheKey)obj;
            return Objects.equal(this.expressionKeys, other.expressionKeys) && Objects.equal((Object)this.sourceId, (Object)other.sourceId) && Objects.equal((Object)this.timeZoneKey, (Object)other.timeZoneKey);
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).add("filter", (Object)this.filter).add("projections", this.projections).add("expressionTypes", this.expressionTypes).add("sourceId", (Object)this.sourceId).add("timeZoneKey", (Object)this.timeZoneKey).toString();
        }
    }

    private static class TypedOperatorClass {
        private final Class<? extends Operator> operatorClass;
        private final List<Type> types;

        private TypedOperatorClass(Class<? extends Operator> operatorClass, List<Type> types) {
            this.operatorClass = operatorClass;
            this.types = types;
        }

        private Class<? extends Operator> getOperatorClass() {
            return this.operatorClass;
        }

        private List<Type> getTypes() {
            return this.types;
        }
    }

    private static class BootstrapEntry {
        private final BootstrapFunctionBinder functionBinder;
        private final Method bootstrapMethod;

        public static BootstrapEntry makeBootstrap(DynamicClassLoader classLoader, Metadata metadata) {
            Method bootstrapMethod;
            Class<Bootstrap> clazz = IsolatedClass.isolateClass(classLoader, Object.class, Bootstrap.class, new Class[0]);
            BootstrapFunctionBinder binder = new BootstrapFunctionBinder(metadata);
            try {
                bootstrapMethod = clazz.getMethod("bootstrap", MethodHandles.Lookup.class, String.class, MethodType.class, Long.TYPE);
                clazz.getMethod("setFunctionBinder", BootstrapFunctionBinder.class).invoke(null, binder);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw Throwables.propagate((Throwable)e);
            }
            return new BootstrapEntry(binder, bootstrapMethod);
        }

        private BootstrapEntry(BootstrapFunctionBinder functionBinder, Method bootstrapMethod) {
            Preconditions.checkNotNull((Object)functionBinder, (Object)"functionBinder is null");
            Preconditions.checkNotNull((Object)bootstrapMethod, (Object)"bootstrapMethod is null");
            this.functionBinder = functionBinder;
            this.bootstrapMethod = bootstrapMethod;
        }

        public BootstrapFunctionBinder getFunctionBinder() {
            return this.functionBinder;
        }

        public Method getBootstrapMethod() {
            return this.bootstrapMethod;
        }
    }
}

