/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.gen;

import com.facebook.presto.byteCode.ByteCodeNode;
import com.facebook.presto.byteCode.instruction.Constant;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.sql.gen.FunctionBinder;
import com.facebook.presto.sql.gen.FunctionBinding;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.lang.invoke.ConstantCallSite;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.util.List;

public class DefaultFunctionBinder
implements FunctionBinder {
    private final MethodHandle methodHandle;
    private final boolean nullable;

    public DefaultFunctionBinder(MethodHandle methodHandle, boolean nullable) {
        this.methodHandle = methodHandle;
        this.nullable = nullable;
    }

    @Override
    public FunctionBinding bindFunction(long bindingId, String name, ByteCodeNode getSessionByteCode, List<ByteCodeNode> arguments) {
        return DefaultFunctionBinder.bindConstantArguments(bindingId, name, getSessionByteCode, arguments, this.methodHandle, this.nullable);
    }

    public static FunctionBinding bindConstantArguments(long bindingId, String name, ByteCodeNode getSessionByteCode, List<ByteCodeNode> arguments, MethodHandle methodHandle, boolean nullable) {
        ImmutableList.Builder unboundArguments = ImmutableList.builder();
        int argIndex = 0;
        if (methodHandle.type().parameterCount() > 0 && methodHandle.type().parameterType(0) == ConnectorSession.class) {
            unboundArguments.add((Object)getSessionByteCode);
            ++argIndex;
        }
        for (ByteCodeNode argument : arguments) {
            ByteCodeNode node = argument;
            if (node instanceof Constant) {
                Object value = ((Constant)node).getValue();
                if (methodHandle.type().parameterType(argIndex) == Boolean.TYPE) {
                    Preconditions.checkArgument((boolean)(value instanceof Integer), (Object)"boolean should be represented as an integer");
                    value = (Integer)value != 0;
                }
                methodHandle = MethodHandles.insertArguments(methodHandle, argIndex, value);
                continue;
            }
            unboundArguments.add((Object)argument);
            ++argIndex;
        }
        ConstantCallSite callSite = new ConstantCallSite(methodHandle);
        return new FunctionBinding(bindingId, name, callSite, (List<ByteCodeNode>)unboundArguments.build(), nullable);
    }
}

