/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.gen;

import com.facebook.presto.byteCode.ByteCodeNode;
import com.facebook.presto.metadata.FunctionInfo;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.OperatorType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.gen.FunctionBinder;
import com.facebook.presto.sql.gen.FunctionBinding;
import com.facebook.presto.sql.tree.QualifiedName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodType;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;

public class BootstrapFunctionBinder {
    private static final AtomicLong NEXT_BINDING_ID = new AtomicLong();
    private final Metadata metadata;
    private final ConcurrentMap<Long, CallSite> bindings = new ConcurrentHashMap<Long, CallSite>();

    public BootstrapFunctionBinder(Metadata metadata) {
        this.metadata = (Metadata)Preconditions.checkNotNull((Object)metadata, (Object)"metadata is null");
    }

    public FunctionBinding bindFunction(QualifiedName name, ByteCodeNode getSessionByteCode, List<ByteCodeNode> arguments, List<Type> argumentTypes) {
        FunctionInfo function = this.metadata.resolveFunction(name, argumentTypes, false);
        Preconditions.checkArgument((function != null ? 1 : 0) != 0, (String)"Unknown function %s%s", (Object[])new Object[]{name, argumentTypes});
        return this.bindFunction(name.toString(), getSessionByteCode, arguments, function.getFunctionBinder());
    }

    public FunctionBinding bindFunction(String name, ByteCodeNode getSessionByteCode, List<ByteCodeNode> arguments, FunctionBinder defaultFunctionBinder) {
        FunctionBinding functionBinding = defaultFunctionBinder.bindFunction(NEXT_BINDING_ID.getAndIncrement(), name, getSessionByteCode, arguments);
        this.bindings.put(functionBinding.getBindingId(), functionBinding.getCallSite());
        return functionBinding;
    }

    public FunctionBinding bindOperator(OperatorType operatorType, ByteCodeNode getSessionByteCode, List<ByteCodeNode> arguments, List<Type> argumentTypes) {
        FunctionInfo operatorInfo = this.metadata.resolveOperator(operatorType, argumentTypes);
        return this.bindOperator(operatorInfo, getSessionByteCode, arguments);
    }

    public FunctionBinding bindCastOperator(ByteCodeNode getSessionByteCode, ByteCodeNode sourceValue, Type sourceType, Type targetType) {
        FunctionInfo operatorInfo = this.metadata.getExactOperator(OperatorType.CAST, targetType, (List<? extends Type>)ImmutableList.of((Object)sourceType));
        return this.bindOperator(operatorInfo, getSessionByteCode, (List<ByteCodeNode>)ImmutableList.of((Object)sourceValue));
    }

    private FunctionBinding bindOperator(FunctionInfo operatorInfo, ByteCodeNode getSessionByteCode, List<ByteCodeNode> arguments) {
        return this.bindFunction(operatorInfo.getSignature().getName(), getSessionByteCode, arguments, operatorInfo.getFunctionBinder());
    }

    public CallSite bootstrap(String name, MethodType type, long bindingId) {
        CallSite callSite = (CallSite)this.bindings.get(bindingId);
        Preconditions.checkArgument((callSite != null ? 1 : 0) != 0, (String)"Binding %s for function %s%s not found", (Object[])new Object[]{bindingId, name, type.parameterList()});
        return callSite;
    }
}

