/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.split;

import com.facebook.presto.execution.ConnectorAwareSplitSource;
import com.facebook.presto.execution.SplitSource;
import com.facebook.presto.metadata.ColumnHandle;
import com.facebook.presto.metadata.Partition;
import com.facebook.presto.metadata.PartitionResult;
import com.facebook.presto.metadata.TableHandle;
import com.facebook.presto.metadata.Util;
import com.facebook.presto.spi.ConnectorPartitionResult;
import com.facebook.presto.spi.ConnectorSplitManager;
import com.facebook.presto.spi.ConnectorSplitSource;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.TupleDomain;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class SplitManager {
    private final ConcurrentMap<String, ConnectorSplitManager> splitManagers = new ConcurrentHashMap<String, ConnectorSplitManager>();

    public void addConnectorSplitManager(String connectorId, ConnectorSplitManager connectorSplitManager) {
        Preconditions.checkState((this.splitManagers.putIfAbsent(connectorId, connectorSplitManager) == null ? 1 : 0) != 0, (String)"SplitManager for connector '%s' is already registered", (Object[])new Object[]{connectorId});
    }

    public PartitionResult getPartitions(TableHandle table, Optional<TupleDomain<ColumnHandle>> tupleDomain) {
        ConnectorPartitionResult result = this.getConnectorSplitManager(table).getPartitions(table.getConnectorHandle(), Util.toConnectorDomain((TupleDomain<ColumnHandle>)((TupleDomain)tupleDomain.or((Object)TupleDomain.all()))));
        return new PartitionResult(table.getConnectorId(), result);
    }

    public SplitSource getPartitionSplits(TableHandle handle, List<Partition> partitions) {
        ConnectorTableHandle table = handle.getConnectorHandle();
        ConnectorSplitSource source = this.getConnectorSplitManager(handle).getPartitionSplits(table, Lists.transform(partitions, Partition.connectorPartitionGetter()));
        return new ConnectorAwareSplitSource(handle.getConnectorId(), source);
    }

    private ConnectorSplitManager getConnectorSplitManager(TableHandle handle) {
        ConnectorSplitManager result = (ConnectorSplitManager)this.splitManagers.get(handle.getConnectorId());
        Preconditions.checkArgument((result != null ? 1 : 0) != 0, (String)"No split manager for connector '%s'", (Object[])new Object[]{handle.getConnectorId()});
        return result;
    }
}

