/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.serde;

import com.facebook.presto.block.dictionary.DictionaryBlockEncoding;
import com.facebook.presto.serde.DictionaryBuilder;
import com.facebook.presto.serde.Encoder;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.block.BlockCursor;
import com.facebook.presto.spi.block.BlockEncoding;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.Preconditions;

public class DictionaryEncoder
implements Encoder {
    private final Encoder idWriter;
    private Type type;
    private DictionaryBuilder dictionaryBuilder;
    private boolean finished;

    public DictionaryEncoder(Encoder idWriter) {
        this.idWriter = (Encoder)Preconditions.checkNotNull((Object)idWriter, (Object)"idWriter is null");
    }

    @Override
    public Encoder append(Block block) {
        Preconditions.checkNotNull((Object)block, (Object)"block is null");
        Preconditions.checkState((!this.finished ? 1 : 0) != 0, (Object)"already finished");
        if (this.type == null) {
            this.type = block.getType();
            this.dictionaryBuilder = new DictionaryBuilder(this.type);
        }
        BlockCursor cursor = block.cursor();
        BlockBuilder idBlockBuilder = BigintType.BIGINT.createBlockBuilder(new BlockBuilderStatus());
        while (cursor.advanceNextPosition()) {
            int key = this.dictionaryBuilder.putIfAbsent(cursor);
            idBlockBuilder.appendLong((long)key);
        }
        this.idWriter.append(idBlockBuilder.build());
        return this;
    }

    @Override
    public BlockEncoding finish() {
        Preconditions.checkState((this.type != null ? 1 : 0) != 0, (Object)"nothing appended");
        Preconditions.checkState((!this.finished ? 1 : 0) != 0, (Object)"already finished");
        this.finished = true;
        return new DictionaryBlockEncoding(this.dictionaryBuilder.build(), this.idWriter.finish());
    }
}

