/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.serde;

import com.facebook.presto.serde.BlocksFileEncoding;
import com.facebook.presto.serde.BlocksFileStats;
import com.facebook.presto.serde.DictionaryBuilder;
import com.facebook.presto.serde.Encoder;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockCursor;
import com.facebook.presto.spi.block.BlockEncoding;
import com.facebook.presto.spi.block.BlockEncodingSerde;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.io.OutputSupplier;
import io.airlift.slice.OutputStreamSliceOutput;
import io.airlift.slice.SliceOutput;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;

public class BlocksFileWriter
implements Closeable {
    private final BlockEncodingSerde blockEncodingSerde;
    private final BlocksFileEncoding encoding;
    private final OutputSupplier<? extends OutputStream> outputSupplier;
    private final StatsBuilder statsBuilder = new StatsBuilder();
    private Encoder encoder;
    private SliceOutput sliceOutput;
    private boolean closed;

    public BlocksFileWriter(BlockEncodingSerde blockEncodingSerde, BlocksFileEncoding encoding, OutputSupplier<? extends OutputStream> outputSupplier) {
        this.blockEncodingSerde = (BlockEncodingSerde)Preconditions.checkNotNull((Object)blockEncodingSerde, (Object)"blockEncodingManager is null");
        this.encoding = (BlocksFileEncoding)((Object)Preconditions.checkNotNull((Object)((Object)encoding), (Object)"encoding is null"));
        this.outputSupplier = (OutputSupplier)Preconditions.checkNotNull(outputSupplier, (Object)"outputSupplier is null");
    }

    public BlocksFileWriter append(Block block) {
        Preconditions.checkNotNull((Object)block, (Object)"block is null");
        if (this.encoder == null) {
            this.open();
        }
        this.statsBuilder.process(block);
        this.encoder.append(block);
        return this;
    }

    private void open() {
        try {
            OutputStream outputStream = (OutputStream)this.outputSupplier.getOutput();
            this.sliceOutput = outputStream instanceof SliceOutput ? (SliceOutput)outputStream : new OutputStreamSliceOutput(outputStream);
            this.encoder = this.encoding.createBlocksWriter(this.sliceOutput);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this.encoder == null) {
            this.createEmptyFile();
            return;
        }
        BlockEncoding blockEncoding = this.encoder.finish();
        int startingIndex = this.sliceOutput.size();
        this.blockEncodingSerde.writeBlockEncoding(this.sliceOutput, blockEncoding);
        BlocksFileStats.serialize(this.statsBuilder.build(), this.sliceOutput);
        int footerSize = this.sliceOutput.size() - startingIndex;
        Preconditions.checkState((footerSize > 0 ? 1 : 0) != 0);
        this.sliceOutput.writeInt(footerSize);
        try {
            this.sliceOutput.close();
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private void createEmptyFile() {
        try {
            ((OutputStream)this.outputSupplier.getOutput()).close();
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private static class StatsBuilder {
        private static final int MAX_UNIQUE_COUNT = 1000;
        private long rowCount;
        private long runsCount;
        private Block lastValue;
        private DictionaryBuilder dictionaryBuilder;

        private StatsBuilder() {
        }

        public void process(Block block) {
            Preconditions.checkNotNull((Object)block, (Object)"block is null");
            if (this.dictionaryBuilder == null) {
                this.dictionaryBuilder = new DictionaryBuilder(block.getType());
            }
            BlockCursor cursor = block.cursor();
            while (cursor.advanceNextPosition()) {
                Block value = cursor.getSingleValueBlock();
                if (this.lastValue == null) {
                    this.lastValue = value;
                } else if (!value.equalTo(0, this.lastValue, 0)) {
                    ++this.runsCount;
                    this.lastValue = value;
                }
                if (this.dictionaryBuilder.size() < 1000) {
                    this.dictionaryBuilder.putIfAbsent(cursor);
                }
                ++this.rowCount;
            }
        }

        public BlocksFileStats build() {
            return new BlocksFileStats(this.rowCount, this.runsCount + 1L, this.rowCount / (this.runsCount + 1L), this.dictionaryBuilder.size() >= 1000 ? Integer.MAX_VALUE : this.dictionaryBuilder.size());
        }
    }
}

