/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.operator.Description;
import com.facebook.presto.operator.scalar.QuarterOfYearDateTimeField;
import com.facebook.presto.operator.scalar.ScalarFunction;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.DateTimeEncoding;
import com.facebook.presto.spi.type.DateType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.IntervalDayTimeType;
import com.facebook.presto.spi.type.IntervalYearMonthType;
import com.facebook.presto.spi.type.TimeType;
import com.facebook.presto.spi.type.TimeWithTimeZoneType;
import com.facebook.presto.spi.type.TimeZoneKey;
import com.facebook.presto.spi.type.TimestampType;
import com.facebook.presto.spi.type.TimestampWithTimeZoneType;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.type.DateTimeOperators;
import com.facebook.presto.type.SqlType;
import com.facebook.presto.util.DateTimeZoneIndex;
import com.facebook.presto.util.ThreadLocalCache;
import com.google.common.base.Charsets;
import com.google.common.primitives.Ints;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.nio.charset.Charset;
import java.util.Locale;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeZone;
import org.joda.time.chrono.ISOChronology;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormatterBuilder;

public final class DateTimeFunctions {
    private static final ThreadLocalCache<Slice, DateTimeFormatter> DATETIME_FORMATTER_CACHE = new ThreadLocalCache<Slice, DateTimeFormatter>(100){

        @Override
        protected DateTimeFormatter load(Slice format) {
            return DateTimeFunctions.createDateTimeFormatter(format);
        }
    };
    private static final ISOChronology UTC_CHRONOLOGY = ISOChronology.getInstance((DateTimeZone)DateTimeZone.UTC);
    private static final DateTimeField SECOND_OF_MINUTE = UTC_CHRONOLOGY.secondOfMinute();
    private static final DateTimeField DAY_OF_WEEK = UTC_CHRONOLOGY.dayOfWeek();
    private static final DateTimeField DAY_OF_MONTH = UTC_CHRONOLOGY.dayOfMonth();
    private static final DateTimeField DAY_OF_YEAR = UTC_CHRONOLOGY.dayOfYear();
    private static final DateTimeField WEEK_OF_YEAR = UTC_CHRONOLOGY.weekOfWeekyear();
    private static final DateTimeField MONTH_OF_YEAR = UTC_CHRONOLOGY.monthOfYear();
    private static final DateTimeField QUARTER = QuarterOfYearDateTimeField.QUARTER_OF_YEAR.getField((Chronology)UTC_CHRONOLOGY);
    private static final DateTimeField YEAR = UTC_CHRONOLOGY.year();
    private static final int MILLISECONDS_IN_SECOND = 1000;
    private static final int MILLISECONDS_IN_MINUTE = 60000;
    private static final int MILLISECONDS_IN_HOUR = 3600000;
    private static final int MILLISECONDS_IN_DAY = 86400000;

    private DateTimeFunctions() {
    }

    @Description(value="current date")
    @ScalarFunction
    @SqlType(value=DateType.class)
    public static long currentDate(ConnectorSession session) {
        return UTC_CHRONOLOGY.dayOfMonth().roundFloor(session.getStartTime());
    }

    @Description(value="current time with time zone")
    @ScalarFunction
    @SqlType(value=TimeWithTimeZoneType.class)
    public static long currentTime(ConnectorSession session) {
        long millis = DateTimeZoneIndex.getChronology(session.getTimeZoneKey()).millisOfDay().get(session.getStartTime());
        return DateTimeEncoding.packDateTimeWithZone((long)millis, (TimeZoneKey)session.getTimeZoneKey());
    }

    @Description(value="current time without time zone")
    @ScalarFunction(value="localtime")
    @SqlType(value=TimeType.class)
    public static long localTime(ConnectorSession session) {
        return DateTimeZoneIndex.getChronology(session.getTimeZoneKey()).millisOfDay().get(session.getStartTime());
    }

    @Description(value="current timestamp with time zone")
    @ScalarFunction(value="current_timestamp", alias={"now"})
    @SqlType(value=TimestampWithTimeZoneType.class)
    public static long currentTimestamp(ConnectorSession session) {
        return DateTimeEncoding.packDateTimeWithZone((long)session.getStartTime(), (TimeZoneKey)session.getTimeZoneKey());
    }

    @Description(value="current timestamp without time zone")
    @ScalarFunction(value="localtimestamp")
    @SqlType(value=TimestampType.class)
    public static long localTimestamp(ConnectorSession session) {
        return session.getStartTime();
    }

    @ScalarFunction(value="from_unixtime")
    @SqlType(value=TimestampType.class)
    public static long fromUnixTime(@SqlType(value=DoubleType.class) double unixTime) {
        return Math.round(unixTime * 1000.0);
    }

    @ScalarFunction(value="from_unixtime")
    @SqlType(value=TimestampWithTimeZoneType.class)
    public static long fromUnixTime(@SqlType(value=DoubleType.class) double unixTime, @SqlType(value=BigintType.class) long hoursOffset, @SqlType(value=BigintType.class) long minutesOffset) {
        return DateTimeEncoding.packDateTimeWithZone((long)Math.round(unixTime * 1000.0), (int)((int)(hoursOffset * 60L + minutesOffset)));
    }

    @ScalarFunction(value="to_unixtime")
    @SqlType(value=DoubleType.class)
    public static double toUnixTime(@SqlType(value=TimestampType.class) long timestamp) {
        return (double)timestamp / 1000.0;
    }

    @ScalarFunction(value="to_unixtime")
    @SqlType(value=DoubleType.class)
    public static double toUnixTimeFromTimestampWithTimeZone(@SqlType(value=TimestampWithTimeZoneType.class) long timestampWithTimeZone) {
        return (double)DateTimeEncoding.unpackMillisUtc((long)timestampWithTimeZone) / 1000.0;
    }

    @ScalarFunction(value="at_time_zone", hidden=true)
    @SqlType(value=TimeWithTimeZoneType.class)
    public static long timeAtTimeZone(@SqlType(value=TimeWithTimeZoneType.class) long timeWithTimeZone, @SqlType(value=VarcharType.class) Slice zoneId) {
        return DateTimeEncoding.packDateTimeWithZone((long)DateTimeEncoding.unpackMillisUtc((long)timeWithTimeZone), (String)zoneId.toStringUtf8());
    }

    @ScalarFunction(value="at_time_zone", hidden=true)
    @SqlType(value=TimeWithTimeZoneType.class)
    public static long timeAtTimeZone(@SqlType(value=TimeWithTimeZoneType.class) long timeWithTimeZone, @SqlType(value=IntervalDayTimeType.class) long zoneOffset) {
        if (zoneOffset % 60000L != 0L) {
            throw new IllegalArgumentException("Invalid time zone offset interval: interval contains seconds");
        }
        int zoneOffsetMinutes = (int)(zoneOffset / 60000L);
        return DateTimeEncoding.packDateTimeWithZone((long)DateTimeEncoding.unpackMillisUtc((long)timeWithTimeZone), (TimeZoneKey)TimeZoneKey.getTimeZoneKeyForOffset((long)zoneOffsetMinutes));
    }

    @ScalarFunction(value="at_time_zone", hidden=true)
    @SqlType(value=TimestampWithTimeZoneType.class)
    public static long timestampAtTimeZone(@SqlType(value=TimestampWithTimeZoneType.class) long timestampWithTimeZone, @SqlType(value=VarcharType.class) Slice zoneId) {
        return DateTimeEncoding.packDateTimeWithZone((long)DateTimeEncoding.unpackMillisUtc((long)timestampWithTimeZone), (String)zoneId.toStringUtf8());
    }

    @ScalarFunction(value="at_time_zone", hidden=true)
    @SqlType(value=TimestampWithTimeZoneType.class)
    public static long timestampAtTimeZone(@SqlType(value=TimestampWithTimeZoneType.class) long timestampWithTimeZone, @SqlType(value=IntervalDayTimeType.class) long zoneOffset) {
        if (zoneOffset % 60000L != 0L) {
            throw new IllegalArgumentException("Invalid time zone offset interval: interval contains seconds");
        }
        int zoneOffsetMinutes = (int)(zoneOffset / 60000L);
        return DateTimeEncoding.packDateTimeWithZone((long)DateTimeEncoding.unpackMillisUtc((long)timestampWithTimeZone), (TimeZoneKey)TimeZoneKey.getTimeZoneKeyForOffset((long)zoneOffsetMinutes));
    }

    @Description(value="truncate to the specified precision in the session timezone")
    @ScalarFunction(value="date_trunc")
    @SqlType(value=DateType.class)
    public static long truncateDate(ConnectorSession session, @SqlType(value=VarcharType.class) Slice unit, @SqlType(value=DateType.class) long time) {
        return DateTimeFunctions.getDateField(UTC_CHRONOLOGY, unit).roundFloor(time);
    }

    @Description(value="truncate to the specified precision in the session timezone")
    @ScalarFunction(value="date_trunc")
    @SqlType(value=TimeType.class)
    public static long truncateTime(ConnectorSession session, @SqlType(value=VarcharType.class) Slice unit, @SqlType(value=TimeType.class) long time) {
        return DateTimeFunctions.getTimeField(DateTimeZoneIndex.getChronology(session.getTimeZoneKey()), unit).roundFloor(time);
    }

    @Description(value="truncate to the specified precision")
    @ScalarFunction(value="date_trunc")
    @SqlType(value=TimeWithTimeZoneType.class)
    public static long truncateTimeWithTimeZone(@SqlType(value=VarcharType.class) Slice unit, @SqlType(value=TimeWithTimeZoneType.class) long timeWithTimeZone) {
        long millis = DateTimeFunctions.getTimeField(DateTimeZoneIndex.unpackChronology(timeWithTimeZone), unit).roundFloor(DateTimeEncoding.unpackMillisUtc((long)timeWithTimeZone));
        return DateTimeEncoding.updateMillisUtc((long)millis, (long)timeWithTimeZone);
    }

    @Description(value="truncate to the specified precision in the session timezone")
    @ScalarFunction(value="date_trunc")
    @SqlType(value=TimestampType.class)
    public static long truncateTimestamp(ConnectorSession session, @SqlType(value=VarcharType.class) Slice unit, @SqlType(value=TimestampType.class) long timestamp) {
        return DateTimeFunctions.getTimestampField(DateTimeZoneIndex.getChronology(session.getTimeZoneKey()), unit).roundFloor(timestamp);
    }

    @Description(value="truncate to the specified precision")
    @ScalarFunction(value="date_trunc")
    @SqlType(value=TimestampWithTimeZoneType.class)
    public static long truncateTimestampWithTimezone(@SqlType(value=VarcharType.class) Slice unit, @SqlType(value=TimestampWithTimeZoneType.class) long timestampWithTimeZone) {
        long millis = DateTimeFunctions.getTimestampField(DateTimeZoneIndex.unpackChronology(timestampWithTimeZone), unit).roundFloor(DateTimeEncoding.unpackMillisUtc((long)timestampWithTimeZone));
        return DateTimeEncoding.updateMillisUtc((long)millis, (long)timestampWithTimeZone);
    }

    @Description(value="add the specified amount of date to the given date")
    @ScalarFunction(value="date_add")
    @SqlType(value=DateType.class)
    public static long addFieldValueDate(ConnectorSession session, @SqlType(value=VarcharType.class) Slice unit, @SqlType(value=BigintType.class) long value, @SqlType(value=DateType.class) long date) {
        return DateTimeFunctions.getDateField(UTC_CHRONOLOGY, unit).add(date, Ints.checkedCast((long)value));
    }

    @Description(value="add the specified amount of time to the given time")
    @ScalarFunction(value="date_add")
    @SqlType(value=TimeType.class)
    public static long addFieldValueTime(ConnectorSession session, @SqlType(value=VarcharType.class) Slice unit, @SqlType(value=BigintType.class) long value, @SqlType(value=TimeType.class) long time) {
        ISOChronology chronology = DateTimeZoneIndex.getChronology(session.getTimeZoneKey());
        return DateTimeOperators.modulo24Hour(chronology, DateTimeFunctions.getTimeField(chronology, unit).add(time, Ints.checkedCast((long)value)));
    }

    @Description(value="add the specified amount of time to the given time")
    @ScalarFunction(value="date_add")
    @SqlType(value=TimeWithTimeZoneType.class)
    public static long addFieldValueTimeWithTimeZone(@SqlType(value=VarcharType.class) Slice unit, @SqlType(value=BigintType.class) long value, @SqlType(value=TimeWithTimeZoneType.class) long timeWithTimeZone) {
        ISOChronology chronology = DateTimeZoneIndex.unpackChronology(timeWithTimeZone);
        long millis = DateTimeOperators.modulo24Hour(chronology, DateTimeFunctions.getTimeField(chronology, unit).add(DateTimeEncoding.unpackMillisUtc((long)timeWithTimeZone), Ints.checkedCast((long)value)));
        return DateTimeEncoding.updateMillisUtc((long)millis, (long)timeWithTimeZone);
    }

    @Description(value="add the specified amount of time to the given timestamp")
    @ScalarFunction(value="date_add")
    @SqlType(value=TimestampType.class)
    public static long addFieldValueTimestamp(ConnectorSession session, @SqlType(value=VarcharType.class) Slice unit, @SqlType(value=BigintType.class) long value, @SqlType(value=TimestampType.class) long timestamp) {
        return DateTimeFunctions.getTimestampField(DateTimeZoneIndex.getChronology(session.getTimeZoneKey()), unit).add(timestamp, Ints.checkedCast((long)value));
    }

    @Description(value="add the specified amount of time to the given timestamp")
    @ScalarFunction(value="date_add")
    @SqlType(value=TimestampWithTimeZoneType.class)
    public static long addFieldValueTimestampWithTimeZone(@SqlType(value=VarcharType.class) Slice unit, @SqlType(value=BigintType.class) long value, @SqlType(value=TimestampWithTimeZoneType.class) long timestampWithTimeZone) {
        long millis = DateTimeFunctions.getTimestampField(DateTimeZoneIndex.unpackChronology(timestampWithTimeZone), unit).add(DateTimeEncoding.unpackMillisUtc((long)timestampWithTimeZone), Ints.checkedCast((long)value));
        return DateTimeEncoding.updateMillisUtc((long)millis, (long)timestampWithTimeZone);
    }

    @Description(value="difference of the given dates in the given unit")
    @ScalarFunction(value="date_diff")
    @SqlType(value=BigintType.class)
    public static long diffDate(ConnectorSession session, @SqlType(value=VarcharType.class) Slice unit, @SqlType(value=DateType.class) long date1, @SqlType(value=DateType.class) long date2) {
        return DateTimeFunctions.getDateField(UTC_CHRONOLOGY, unit).getDifference(date2, date1);
    }

    @Description(value="difference of the given times in the given unit")
    @ScalarFunction(value="date_diff")
    @SqlType(value=BigintType.class)
    public static long diffTime(ConnectorSession session, @SqlType(value=VarcharType.class) Slice unit, @SqlType(value=TimeType.class) long time1, @SqlType(value=TimeType.class) long time2) {
        ISOChronology chronology = DateTimeZoneIndex.getChronology(session.getTimeZoneKey());
        return DateTimeFunctions.getTimeField(chronology, unit).getDifference(time2, time1);
    }

    @Description(value="difference of the given times in the given unit")
    @ScalarFunction(value="date_diff")
    @SqlType(value=BigintType.class)
    public static long diffTimeWithTimeZone(@SqlType(value=VarcharType.class) Slice unit, @SqlType(value=TimeWithTimeZoneType.class) long timeWithTimeZone1, @SqlType(value=TimeWithTimeZoneType.class) long timeWithTimeZone2) {
        return DateTimeFunctions.getTimeField(DateTimeZoneIndex.unpackChronology(timeWithTimeZone1), unit).getDifference(DateTimeEncoding.unpackMillisUtc((long)timeWithTimeZone2), DateTimeEncoding.unpackMillisUtc((long)timeWithTimeZone1));
    }

    @Description(value="difference of the given times in the given unit")
    @ScalarFunction(value="date_diff")
    @SqlType(value=BigintType.class)
    public static long diffTimestamp(ConnectorSession session, @SqlType(value=VarcharType.class) Slice unit, @SqlType(value=TimestampType.class) long timestamp1, @SqlType(value=TimestampType.class) long timestamp2) {
        return DateTimeFunctions.getTimestampField(DateTimeZoneIndex.getChronology(session.getTimeZoneKey()), unit).getDifference(timestamp2, timestamp1);
    }

    @Description(value="difference of the given times in the given unit")
    @ScalarFunction(value="date_diff")
    @SqlType(value=BigintType.class)
    public static long diffTimestampWithTimeZone(@SqlType(value=VarcharType.class) Slice unit, @SqlType(value=TimestampWithTimeZoneType.class) long timestampWithTimeZone1, @SqlType(value=TimestampWithTimeZoneType.class) long timestampWithTimeZone2) {
        return DateTimeFunctions.getTimestampField(DateTimeZoneIndex.unpackChronology(timestampWithTimeZone1), unit).getDifference(DateTimeEncoding.unpackMillisUtc((long)timestampWithTimeZone2), DateTimeEncoding.unpackMillisUtc((long)timestampWithTimeZone1));
    }

    private static DateTimeField getDateField(ISOChronology chronology, Slice unit) {
        String unitString;
        switch (unitString = unit.toString(Charsets.UTF_8).toLowerCase()) {
            case "day": {
                return chronology.dayOfMonth();
            }
            case "week": {
                return chronology.weekOfWeekyear();
            }
            case "month": {
                return chronology.monthOfYear();
            }
            case "quarter": {
                return QuarterOfYearDateTimeField.QUARTER_OF_YEAR.getField((Chronology)chronology);
            }
            case "year": {
                return chronology.year();
            }
        }
        throw new IllegalArgumentException("'" + unitString + "' is not a valid DATE field");
    }

    private static DateTimeField getTimeField(ISOChronology chronology, Slice unit) {
        String unitString;
        switch (unitString = unit.toString(Charsets.UTF_8).toLowerCase()) {
            case "second": {
                return chronology.secondOfMinute();
            }
            case "minute": {
                return chronology.minuteOfHour();
            }
            case "hour": {
                return chronology.hourOfDay();
            }
        }
        throw new IllegalArgumentException("'" + unitString + "' is not a valid Time field");
    }

    private static DateTimeField getTimestampField(ISOChronology chronology, Slice unit) {
        String unitString;
        switch (unitString = unit.toString(Charsets.UTF_8).toLowerCase()) {
            case "second": {
                return chronology.secondOfMinute();
            }
            case "minute": {
                return chronology.minuteOfHour();
            }
            case "hour": {
                return chronology.hourOfDay();
            }
            case "day": {
                return chronology.dayOfMonth();
            }
            case "week": {
                return chronology.weekOfWeekyear();
            }
            case "month": {
                return chronology.monthOfYear();
            }
            case "quarter": {
                return QuarterOfYearDateTimeField.QUARTER_OF_YEAR.getField((Chronology)chronology);
            }
            case "year": {
                return chronology.year();
            }
        }
        throw new IllegalArgumentException("'" + unitString + "' is not a valid Timestamp field");
    }

    @Description(value="parses the specified date/time by the given format")
    @ScalarFunction
    @SqlType(value=TimestampWithTimeZoneType.class)
    public static long parseDatetime(ConnectorSession session, @SqlType(value=VarcharType.class) Slice datetime, @SqlType(value=VarcharType.class) Slice formatString) {
        String pattern = formatString.toString(Charsets.UTF_8);
        DateTimeFormatter formatter = DateTimeFormat.forPattern((String)pattern).withChronology((Chronology)DateTimeZoneIndex.getChronology(session.getTimeZoneKey())).withOffsetParsed().withLocale(session.getLocale());
        String datetimeString = datetime.toString(Charsets.UTF_8);
        return DateTimeZoneIndex.packDateTimeWithZone(DateTimeFunctions.parseDateTimeHelper(formatter, datetimeString));
    }

    private static DateTime parseDateTimeHelper(DateTimeFormatter formatter, String datetimeString) {
        try {
            return formatter.parseDateTime(datetimeString);
        }
        catch (IllegalArgumentException e) {
            throw new PrestoException(StandardErrorCode.INVALID_FUNCTION_ARGUMENT.toErrorCode(), (Throwable)e);
        }
    }

    @Description(value="formats the given time by the given format")
    @ScalarFunction
    @SqlType(value=VarcharType.class)
    public static Slice formatDatetime(ConnectorSession session, @SqlType(value=TimestampType.class) long timestamp, @SqlType(value=VarcharType.class) Slice formatString) {
        return DateTimeFunctions.formatDatetime(DateTimeZoneIndex.getChronology(session.getTimeZoneKey()), session.getLocale(), timestamp, formatString);
    }

    @Description(value="formats the given time by the given format")
    @ScalarFunction(value="format_datetime")
    @SqlType(value=VarcharType.class)
    public static Slice formatDatetimeWithTimeZone(ConnectorSession session, @SqlType(value=TimestampWithTimeZoneType.class) long timestampWithTimeZone, @SqlType(value=VarcharType.class) Slice formatString) {
        return DateTimeFunctions.formatDatetime(DateTimeZoneIndex.unpackChronology(timestampWithTimeZone), session.getLocale(), DateTimeEncoding.unpackMillisUtc((long)timestampWithTimeZone), formatString);
    }

    private static Slice formatDatetime(ISOChronology chronology, Locale locale, long timestamp, Slice formatString) {
        String pattern = formatString.toString(Charsets.UTF_8);
        DateTimeFormatter formatter = DateTimeFormat.forPattern((String)pattern).withChronology((Chronology)chronology).withLocale(locale);
        String datetimeString = formatter.print(timestamp);
        return Slices.wrappedBuffer((byte[])datetimeString.getBytes(Charsets.UTF_8));
    }

    @ScalarFunction
    @SqlType(value=VarcharType.class)
    public static Slice dateFormat(ConnectorSession session, @SqlType(value=TimestampType.class) long timestamp, @SqlType(value=VarcharType.class) Slice formatString) {
        return DateTimeFunctions.dateFormat(DateTimeZoneIndex.getChronology(session.getTimeZoneKey()), session.getLocale(), timestamp, formatString);
    }

    @ScalarFunction(value="date_format")
    @SqlType(value=VarcharType.class)
    public static Slice dateFormatWithTimeZone(ConnectorSession session, @SqlType(value=TimestampWithTimeZoneType.class) long timestampWithTimeZone, @SqlType(value=VarcharType.class) Slice formatString) {
        return DateTimeFunctions.dateFormat(DateTimeZoneIndex.unpackChronology(timestampWithTimeZone), session.getLocale(), DateTimeEncoding.unpackMillisUtc((long)timestampWithTimeZone), formatString);
    }

    private static Slice dateFormat(ISOChronology chronology, Locale locale, long timestamp, Slice formatString) {
        DateTimeFormatter formatter = DATETIME_FORMATTER_CACHE.get(formatString).withChronology((Chronology)chronology).withLocale(locale);
        return Slices.copiedBuffer((String)formatter.print(timestamp), (Charset)Charsets.UTF_8);
    }

    @ScalarFunction
    @SqlType(value=TimestampType.class)
    public static long dateParse(ConnectorSession session, @SqlType(value=VarcharType.class) Slice dateTime, @SqlType(value=VarcharType.class) Slice formatString) {
        DateTimeFormatter formatter = DATETIME_FORMATTER_CACHE.get(formatString).withChronology((Chronology)DateTimeZoneIndex.getChronology(session.getTimeZoneKey())).withLocale(session.getLocale());
        try {
            return formatter.parseMillis(dateTime.toString(Charsets.UTF_8));
        }
        catch (IllegalArgumentException e) {
            throw new PrestoException(StandardErrorCode.INVALID_FUNCTION_ARGUMENT.toErrorCode(), (Throwable)e);
        }
    }

    @Description(value="second of the minute of the given timestamp")
    @ScalarFunction(value="second")
    @SqlType(value=BigintType.class)
    public static long secondFromTimestamp(@SqlType(value=TimestampType.class) long timestamp) {
        return SECOND_OF_MINUTE.get(timestamp);
    }

    @Description(value="second of the minute of the given timestamp")
    @ScalarFunction(value="second")
    @SqlType(value=BigintType.class)
    public static long secondFromTimestampWithTimeZone(@SqlType(value=TimestampWithTimeZoneType.class) long timestampWithTimeZone) {
        return SECOND_OF_MINUTE.get(DateTimeEncoding.unpackMillisUtc((long)timestampWithTimeZone));
    }

    @Description(value="second of the minute of the given time")
    @ScalarFunction(value="second")
    @SqlType(value=BigintType.class)
    public static long secondFromTime(@SqlType(value=TimeType.class) long time) {
        return SECOND_OF_MINUTE.get(time);
    }

    @Description(value="second of the minute of the given time")
    @ScalarFunction(value="second")
    @SqlType(value=BigintType.class)
    public static long secondFromTimeWithTimeZone(@SqlType(value=TimeWithTimeZoneType.class) long time) {
        return SECOND_OF_MINUTE.get(DateTimeEncoding.unpackMillisUtc((long)time));
    }

    @Description(value="second of the minute of the given interval")
    @ScalarFunction(value="second")
    @SqlType(value=BigintType.class)
    public static long secondFromInterval(@SqlType(value=IntervalDayTimeType.class) long milliseconds) {
        return milliseconds % 60000L / 1000L;
    }

    @Description(value="minute of the hour of the given timestamp")
    @ScalarFunction(value="minute")
    @SqlType(value=BigintType.class)
    public static long minuteFromTimestamp(ConnectorSession session, @SqlType(value=TimestampType.class) long timestamp) {
        return DateTimeZoneIndex.getChronology(session.getTimeZoneKey()).minuteOfHour().get(timestamp);
    }

    @Description(value="minute of the hour of the given timestamp")
    @ScalarFunction(value="minute")
    @SqlType(value=BigintType.class)
    public static long minuteFromTimestampWithTimeZone(@SqlType(value=TimestampWithTimeZoneType.class) long timestampWithTimeZone) {
        return DateTimeZoneIndex.unpackChronology(timestampWithTimeZone).minuteOfHour().get(DateTimeEncoding.unpackMillisUtc((long)timestampWithTimeZone));
    }

    @Description(value="minute of the hour of the given time")
    @ScalarFunction(value="minute")
    @SqlType(value=BigintType.class)
    public static long minuteFromTime(ConnectorSession session, @SqlType(value=TimeType.class) long time) {
        return DateTimeZoneIndex.getChronology(session.getTimeZoneKey()).minuteOfHour().get(time);
    }

    @Description(value="minute of the hour of the given time")
    @ScalarFunction(value="minute")
    @SqlType(value=BigintType.class)
    public static long minuteFromTimeWithTimeZone(@SqlType(value=TimeWithTimeZoneType.class) long timeWithTimeZone) {
        return DateTimeZoneIndex.unpackChronology(timeWithTimeZone).minuteOfHour().get(DateTimeEncoding.unpackMillisUtc((long)timeWithTimeZone));
    }

    @Description(value="minute of the hour of the given interval")
    @ScalarFunction(value="minute")
    @SqlType(value=BigintType.class)
    public static long minuteFromInterval(@SqlType(value=IntervalDayTimeType.class) long milliseconds) {
        return milliseconds % 3600000L / 60000L;
    }

    @Description(value="hour of the day of the given timestamp")
    @ScalarFunction(value="hour")
    @SqlType(value=BigintType.class)
    public static long hourFromTimestamp(ConnectorSession session, @SqlType(value=TimestampType.class) long timestamp) {
        return DateTimeZoneIndex.getChronology(session.getTimeZoneKey()).hourOfDay().get(timestamp);
    }

    @Description(value="hour of the day of the given timestamp")
    @ScalarFunction(value="hour")
    @SqlType(value=BigintType.class)
    public static long hourFromTimestampWithTimeZone(@SqlType(value=TimestampWithTimeZoneType.class) long timestampWithTimeZone) {
        return DateTimeZoneIndex.unpackChronology(timestampWithTimeZone).hourOfDay().get(DateTimeEncoding.unpackMillisUtc((long)timestampWithTimeZone));
    }

    @Description(value="hour of the day of the given time")
    @ScalarFunction(value="hour")
    @SqlType(value=BigintType.class)
    public static long hourFromTime(ConnectorSession session, @SqlType(value=TimeType.class) long time) {
        return DateTimeZoneIndex.getChronology(session.getTimeZoneKey()).hourOfDay().get(time);
    }

    @Description(value="hour of the day of the given time")
    @ScalarFunction(value="hour")
    @SqlType(value=BigintType.class)
    public static long hourFromTimeWithTimeZone(@SqlType(value=TimeWithTimeZoneType.class) long timeWithTimeZone) {
        return DateTimeZoneIndex.unpackChronology(timeWithTimeZone).hourOfDay().get(DateTimeEncoding.unpackMillisUtc((long)timeWithTimeZone));
    }

    @Description(value="hour of the day of the given interval")
    @ScalarFunction(value="hour")
    @SqlType(value=BigintType.class)
    public static long hourFromInterval(@SqlType(value=IntervalDayTimeType.class) long milliseconds) {
        return milliseconds % 86400000L / 3600000L;
    }

    @Description(value="day of the week of the given timestamp")
    @ScalarFunction(value="day_of_week", alias={"dow"})
    @SqlType(value=BigintType.class)
    public static long dayOfWeekFromTimestamp(ConnectorSession session, @SqlType(value=TimestampType.class) long timestamp) {
        return DateTimeZoneIndex.getChronology(session.getTimeZoneKey()).dayOfWeek().get(timestamp);
    }

    @Description(value="day of the week of the given timestamp")
    @ScalarFunction(value="day_of_week", alias={"dow"})
    @SqlType(value=BigintType.class)
    public static long dayOfWeekFromTimestampWithTimeZone(@SqlType(value=TimestampWithTimeZoneType.class) long timestampWithTimeZone) {
        return DateTimeZoneIndex.unpackChronology(timestampWithTimeZone).dayOfWeek().get(DateTimeEncoding.unpackMillisUtc((long)timestampWithTimeZone));
    }

    @Description(value="day of the week of the given date")
    @ScalarFunction(value="day_of_week", alias={"dow"})
    @SqlType(value=BigintType.class)
    public static long dayOfWeekFromDate(@SqlType(value=DateType.class) long date) {
        return DAY_OF_WEEK.get(date);
    }

    @Description(value="day of the month of the given timestamp")
    @ScalarFunction(value="day", alias={"day_of_month"})
    @SqlType(value=BigintType.class)
    public static long dayFromTimestamp(ConnectorSession session, @SqlType(value=TimestampType.class) long timestamp) {
        return DateTimeZoneIndex.getChronology(session.getTimeZoneKey()).dayOfMonth().get(timestamp);
    }

    @Description(value="day of the month of the given timestamp")
    @ScalarFunction(value="day", alias={"day_of_month"})
    @SqlType(value=BigintType.class)
    public static long dayFromTimestampWithTimeZone(@SqlType(value=TimestampWithTimeZoneType.class) long timestampWithTimeZone) {
        return DateTimeZoneIndex.unpackChronology(timestampWithTimeZone).dayOfMonth().get(DateTimeEncoding.unpackMillisUtc((long)timestampWithTimeZone));
    }

    @Description(value="day of the month of the given date")
    @ScalarFunction(value="day", alias={"day_of_month"})
    @SqlType(value=BigintType.class)
    public static long dayFromDate(@SqlType(value=DateType.class) long date) {
        return DAY_OF_MONTH.get(date);
    }

    @Description(value="day of the month of the given interval")
    @ScalarFunction(value="day", alias={"day_of_month"})
    @SqlType(value=BigintType.class)
    public static long dayFromInterval(@SqlType(value=IntervalDayTimeType.class) long milliseconds) {
        return milliseconds / 86400000L;
    }

    @Description(value="day of the year of the given timestamp")
    @ScalarFunction(value="day_of_year", alias={"doy"})
    @SqlType(value=BigintType.class)
    public static long dayOfYearFromTimestamp(ConnectorSession session, @SqlType(value=TimestampType.class) long timestamp) {
        return DateTimeZoneIndex.getChronology(session.getTimeZoneKey()).dayOfYear().get(timestamp);
    }

    @Description(value="day of the year of the given timestamp")
    @ScalarFunction(value="day_of_year", alias={"doy"})
    @SqlType(value=BigintType.class)
    public static long dayOfYearFromTimestampWithTimeZone(@SqlType(value=TimestampWithTimeZoneType.class) long timestampWithTimeZone) {
        return DateTimeZoneIndex.unpackChronology(timestampWithTimeZone).dayOfYear().get(DateTimeEncoding.unpackMillisUtc((long)timestampWithTimeZone));
    }

    @Description(value="day of the year of the given date")
    @ScalarFunction(value="day_of_year", alias={"doy"})
    @SqlType(value=BigintType.class)
    public static long dayOfYearFromDate(@SqlType(value=DateType.class) long date) {
        return DAY_OF_YEAR.get(date);
    }

    @Description(value="week of the year of the given timestamp")
    @ScalarFunction(value="week", alias={"week_of_year"})
    @SqlType(value=BigintType.class)
    public static long weekFromTimestamp(ConnectorSession session, @SqlType(value=TimestampType.class) long timestamp) {
        return DateTimeZoneIndex.getChronology(session.getTimeZoneKey()).weekOfWeekyear().get(timestamp);
    }

    @Description(value="week of the year of the given timestamp")
    @ScalarFunction(value="week", alias={"week_of_year"})
    @SqlType(value=BigintType.class)
    public static long weekFromTimestampWithTimeZone(@SqlType(value=TimestampWithTimeZoneType.class) long timestampWithTimeZone) {
        return DateTimeZoneIndex.unpackChronology(timestampWithTimeZone).weekOfWeekyear().get(DateTimeEncoding.unpackMillisUtc((long)timestampWithTimeZone));
    }

    @Description(value="week of the year of the given date")
    @ScalarFunction(value="week", alias={"week_of_year"})
    @SqlType(value=BigintType.class)
    public static long weekFromDate(@SqlType(value=DateType.class) long date) {
        return WEEK_OF_YEAR.get(date);
    }

    @Description(value="month of the year of the given timestamp")
    @ScalarFunction(value="month")
    @SqlType(value=BigintType.class)
    public static long monthFromTimestamp(ConnectorSession session, @SqlType(value=TimestampType.class) long timestamp) {
        return DateTimeZoneIndex.getChronology(session.getTimeZoneKey()).monthOfYear().get(timestamp);
    }

    @Description(value="month of the year of the given timestamp")
    @ScalarFunction(value="month")
    @SqlType(value=BigintType.class)
    public static long monthFromTimestampWithTimeZone(@SqlType(value=TimestampWithTimeZoneType.class) long timestampWithTimeZone) {
        return DateTimeZoneIndex.unpackChronology(timestampWithTimeZone).monthOfYear().get(DateTimeEncoding.unpackMillisUtc((long)timestampWithTimeZone));
    }

    @Description(value="month of the year of the given date")
    @ScalarFunction(value="month")
    @SqlType(value=BigintType.class)
    public static long monthFromDate(@SqlType(value=DateType.class) long date) {
        return MONTH_OF_YEAR.get(date);
    }

    @Description(value="month of the year of the given interval")
    @ScalarFunction(value="month")
    @SqlType(value=BigintType.class)
    public static long monthFromInterval(@SqlType(value=IntervalYearMonthType.class) long months) {
        return months % 12L;
    }

    @Description(value="quarter of the year of the given timestamp")
    @ScalarFunction(value="quarter")
    @SqlType(value=BigintType.class)
    public static long quarterFromTimestamp(ConnectorSession session, @SqlType(value=TimestampType.class) long timestamp) {
        return QuarterOfYearDateTimeField.QUARTER_OF_YEAR.getField((Chronology)DateTimeZoneIndex.getChronology(session.getTimeZoneKey())).get(timestamp);
    }

    @Description(value="quarter of the year of the given timestamp")
    @ScalarFunction(value="quarter")
    @SqlType(value=BigintType.class)
    public static long quarterFromTimestampWithTimeZone(@SqlType(value=TimestampWithTimeZoneType.class) long timestampWithTimeZone) {
        return QuarterOfYearDateTimeField.QUARTER_OF_YEAR.getField((Chronology)DateTimeZoneIndex.unpackChronology(timestampWithTimeZone)).get(DateTimeEncoding.unpackMillisUtc((long)timestampWithTimeZone));
    }

    @Description(value="quarter of the year of the given date")
    @ScalarFunction(value="quarter")
    @SqlType(value=BigintType.class)
    public static long quarterFromDate(@SqlType(value=DateType.class) long date) {
        return QUARTER.get(date);
    }

    @Description(value="year of the given timestamp")
    @ScalarFunction(value="year")
    @SqlType(value=BigintType.class)
    public static long yearFromTimestamp(ConnectorSession session, @SqlType(value=TimestampType.class) long timestamp) {
        return DateTimeZoneIndex.getChronology(session.getTimeZoneKey()).year().get(timestamp);
    }

    @Description(value="year of the given timestamp")
    @ScalarFunction(value="year")
    @SqlType(value=BigintType.class)
    public static long yearFromTimestampWithTimeZone(@SqlType(value=TimestampWithTimeZoneType.class) long timestampWithTimeZone) {
        return DateTimeZoneIndex.unpackChronology(timestampWithTimeZone).year().get(DateTimeEncoding.unpackMillisUtc((long)timestampWithTimeZone));
    }

    @Description(value="year of the given date")
    @ScalarFunction(value="year")
    @SqlType(value=BigintType.class)
    public static long yearFromDate(@SqlType(value=DateType.class) long date) {
        return YEAR.get(date);
    }

    @Description(value="year of the given interval")
    @ScalarFunction(value="year")
    @SqlType(value=BigintType.class)
    public static long yearFromInterval(@SqlType(value=IntervalYearMonthType.class) long months) {
        return months / 12L;
    }

    @Description(value="time zone minute of the given timestamp")
    @ScalarFunction(value="timezone_minute")
    @SqlType(value=BigintType.class)
    public static long timeZoneMinuteFromTimestampWithTimeZone(@SqlType(value=TimestampWithTimeZoneType.class) long timestampWithTimeZone) {
        return DateTimeZoneIndex.extractZoneOffsetMinutes(timestampWithTimeZone) % 60;
    }

    @Description(value="time zone hour of the given timestamp")
    @ScalarFunction(value="timezone_hour")
    @SqlType(value=BigintType.class)
    public static long timeZoneHourFromTimestampWithTimeZone(@SqlType(value=TimestampWithTimeZoneType.class) long timestampWithTimeZone) {
        return DateTimeZoneIndex.extractZoneOffsetMinutes(timestampWithTimeZone) / 60;
    }

    @Description(value="get the largest of the given values")
    @ScalarFunction(value="greatest")
    @SqlType(value=TimestampType.class)
    public static long greatestTimestamp(@SqlType(value=TimestampType.class) long value1, @SqlType(value=TimestampType.class) long value2) {
        return value1 > value2 ? value1 : value2;
    }

    @Description(value="get the smallest of the given values")
    @ScalarFunction(value="least")
    @SqlType(value=TimestampType.class)
    public static long leastTimestamp(@SqlType(value=TimestampType.class) long value1, @SqlType(value=TimestampType.class) long value2) {
        return value1 < value2 ? value1 : value2;
    }

    @Description(value="get the largest of the given values")
    @ScalarFunction(value="greatest")
    @SqlType(value=TimestampWithTimeZoneType.class)
    public static long greatestTimestampWithTimeZone(@SqlType(value=TimestampWithTimeZoneType.class) long value1, @SqlType(value=TimestampWithTimeZoneType.class) long value2) {
        return DateTimeEncoding.unpackMillisUtc((long)value1) > DateTimeEncoding.unpackMillisUtc((long)value2) ? value1 : value2;
    }

    @Description(value="get the smallest of the given values")
    @ScalarFunction(value="least")
    @SqlType(value=TimestampWithTimeZoneType.class)
    public static long leastTimestampWithTimeZone(@SqlType(value=TimestampWithTimeZoneType.class) long value1, @SqlType(value=TimestampWithTimeZoneType.class) long value2) {
        return DateTimeEncoding.unpackMillisUtc((long)value1) < DateTimeEncoding.unpackMillisUtc((long)value2) ? value1 : value2;
    }

    @Description(value="get the largest of the given values")
    @ScalarFunction(value="greatest")
    @SqlType(value=DateType.class)
    public static long greatestDate(@SqlType(value=DateType.class) long value1, @SqlType(value=DateType.class) long value2) {
        return value1 > value2 ? value1 : value2;
    }

    @Description(value="get the smallest of the given values")
    @ScalarFunction(value="least")
    @SqlType(value=DateType.class)
    public static long leastDate(@SqlType(value=DateType.class) long value1, @SqlType(value=DateType.class) long value2) {
        return value1 < value2 ? value1 : value2;
    }

    public static DateTimeFormatter createDateTimeFormatter(Slice format) {
        DateTimeFormatterBuilder builder = new DateTimeFormatterBuilder();
        String formatString = format.toString(Charsets.UTF_8);
        boolean escaped = false;
        for (int i = 0; i < format.length(); ++i) {
            char character = formatString.charAt(i);
            if (escaped) {
                switch (character) {
                    case 'a': {
                        builder.appendDayOfWeekShortText();
                        break;
                    }
                    case 'b': {
                        builder.appendMonthOfYearShortText();
                        break;
                    }
                    case 'c': {
                        builder.appendMonthOfYear(1);
                        break;
                    }
                    case 'd': {
                        builder.appendDayOfMonth(2);
                        break;
                    }
                    case 'e': {
                        builder.appendDayOfMonth(1);
                        break;
                    }
                    case 'f': {
                        builder.appendMillisOfSecond(6);
                        break;
                    }
                    case 'H': {
                        builder.appendHourOfDay(2);
                        break;
                    }
                    case 'I': 
                    case 'h': {
                        builder.appendClockhourOfHalfday(2);
                        break;
                    }
                    case 'i': {
                        builder.appendMinuteOfHour(2);
                        break;
                    }
                    case 'j': {
                        builder.appendDayOfYear(3);
                        break;
                    }
                    case 'k': {
                        builder.appendClockhourOfDay(1);
                        break;
                    }
                    case 'l': {
                        builder.appendClockhourOfHalfday(1);
                        break;
                    }
                    case 'M': {
                        builder.appendMonthOfYearText();
                        break;
                    }
                    case 'm': {
                        builder.appendMonthOfYear(2);
                        break;
                    }
                    case 'p': {
                        builder.appendHalfdayOfDayText();
                        break;
                    }
                    case 'r': {
                        builder.appendClockhourOfHalfday(2).appendLiteral(':').appendMinuteOfHour(2).appendLiteral(':').appendSecondOfMinute(2).appendLiteral(' ').appendHalfdayOfDayText();
                        break;
                    }
                    case 'S': 
                    case 's': {
                        builder.appendSecondOfMinute(2);
                        break;
                    }
                    case 'T': {
                        builder.appendHourOfDay(2).appendLiteral(':').appendMinuteOfHour(2).appendLiteral(':').appendSecondOfMinute(2);
                        break;
                    }
                    case 'v': {
                        builder.appendWeekOfWeekyear(2);
                        break;
                    }
                    case 'x': {
                        builder.appendWeekyear(4, 4);
                        break;
                    }
                    case 'W': {
                        builder.appendDayOfWeekText();
                        break;
                    }
                    case 'w': {
                        builder.appendDayOfWeek(1);
                        break;
                    }
                    case 'Y': {
                        builder.appendYear(4, 4);
                        break;
                    }
                    case 'y': {
                        builder.appendYearOfCentury(2, 2);
                        break;
                    }
                    case 'D': 
                    case 'U': 
                    case 'V': 
                    case 'X': 
                    case 'u': {
                        throw new PrestoException(StandardErrorCode.INVALID_FUNCTION_ARGUMENT.toErrorCode(), String.format("%%%s not supported in date format string", Character.valueOf(character)));
                    }
                    case '%': {
                        builder.appendLiteral('%');
                        break;
                    }
                    default: {
                        builder.appendLiteral(character);
                    }
                }
                escaped = false;
                continue;
            }
            if (character == '%') {
                escaped = true;
                continue;
            }
            builder.appendLiteral(character);
        }
        try {
            return builder.toFormatter();
        }
        catch (UnsupportedOperationException e) {
            throw new PrestoException(StandardErrorCode.INVALID_FUNCTION_ARGUMENT.toErrorCode(), (Throwable)e);
        }
    }
}

