/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.index;

import com.facebook.presto.operator.GroupByHash;
import com.facebook.presto.operator.index.IndexSnapshot;
import com.facebook.presto.operator.index.UpdateRequest;
import com.facebook.presto.spi.RecordCursor;
import com.facebook.presto.spi.RecordSet;
import com.facebook.presto.spi.block.BlockCursor;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class UnloadedIndexKeyRecordSet
implements RecordSet {
    private final List<Type> types;
    private final List<PageAndPositions> pageAndPositions;

    public UnloadedIndexKeyRecordSet(IndexSnapshot existingSnapshot, List<Type> types, List<UpdateRequest> requests) {
        Preconditions.checkNotNull((Object)existingSnapshot, (Object)"existingSnapshot is null");
        this.types = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(types, (Object)"types is null")));
        Preconditions.checkNotNull(requests, (Object)"requests is null");
        int[] allChannels = new int[types.size()];
        for (int i = 0; i < allChannels.length; ++i) {
            allChannels[i] = i;
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        long nextDistinctId = 0L;
        GroupByHash groupByHash = new GroupByHash(types, allChannels, 10000);
        for (UpdateRequest request : requests) {
            IntArrayList positions = new IntArrayList();
            BlockCursor[] cursors = request.duplicateCursors();
            int positionCount = cursors[0].getRemainingPositions() + 1;
            for (int index = 0; index < positionCount; ++index) {
                if (index > 0) {
                    for (BlockCursor cursor : cursors) {
                        Preconditions.checkState((boolean)cursor.advanceNextPosition());
                    }
                }
                if (UnloadedIndexKeyRecordSet.containsNullValue(cursors) || (long)groupByHash.putIfAbsent(cursors) != nextDistinctId) continue;
                ++nextDistinctId;
                if (existingSnapshot.getJoinPosition(cursors) != -2L) continue;
                positions.add(cursors[0].getPosition());
            }
            if (positions.isEmpty()) continue;
            builder.add((Object)new PageAndPositions(request, (IntList)positions));
        }
        this.pageAndPositions = builder.build();
    }

    public List<Type> getColumnTypes() {
        return this.types;
    }

    public UnloadedIndexKeyRecordCursor cursor() {
        return new UnloadedIndexKeyRecordCursor(this.types, this.pageAndPositions);
    }

    private static boolean containsNullValue(BlockCursor ... cursors) {
        for (BlockCursor cursor : cursors) {
            if (!cursor.isNull()) continue;
            return true;
        }
        return false;
    }

    private static class PageAndPositions {
        private final UpdateRequest updateRequest;
        private final IntList positions;

        private PageAndPositions(UpdateRequest updateRequest, IntList positions) {
            this.updateRequest = (UpdateRequest)Preconditions.checkNotNull((Object)updateRequest, (Object)"updateRequest is null");
            this.positions = (IntList)Preconditions.checkNotNull((Object)positions, (Object)"positions is null");
        }

        private UpdateRequest getUpdateRequest() {
            return this.updateRequest;
        }

        private IntList getPositions() {
            return this.positions;
        }
    }

    public static class UnloadedIndexKeyRecordCursor
    implements RecordCursor {
        private final List<Type> types;
        private final Iterator<PageAndPositions> pageAndPositionsIterator;
        private BlockCursor[] cursors;
        private IntListIterator positionIterator;

        public UnloadedIndexKeyRecordCursor(List<Type> types, List<PageAndPositions> pageAndPositions) {
            this.types = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(types, (Object)"types is null")));
            this.pageAndPositionsIterator = ((List)Preconditions.checkNotNull(pageAndPositions, (Object)"pageAndPositions is null")).iterator();
            this.cursors = new BlockCursor[types.size()];
        }

        public long getTotalBytes() {
            return 0L;
        }

        public long getCompletedBytes() {
            return 0L;
        }

        public long getReadTimeNanos() {
            return 0L;
        }

        public Type getType(int field) {
            return this.types.get(field);
        }

        public boolean advanceNextPosition() {
            while (this.positionIterator == null || !this.positionIterator.hasNext()) {
                if (!this.pageAndPositionsIterator.hasNext()) {
                    return false;
                }
                PageAndPositions pageAndPositions = this.pageAndPositionsIterator.next();
                this.cursors = pageAndPositions.getUpdateRequest().duplicateCursors();
                Preconditions.checkState((this.types.size() == this.cursors.length ? 1 : 0) != 0);
                this.positionIterator = pageAndPositions.getPositions().iterator();
            }
            int position = this.positionIterator.nextInt();
            for (BlockCursor cursor : this.cursors) {
                Preconditions.checkState((boolean)cursor.advanceToPosition(position));
            }
            return true;
        }

        public BlockCursor[] asBlockCursors() {
            return this.cursors;
        }

        public boolean getBoolean(int field) {
            return this.cursors[field].getBoolean();
        }

        public long getLong(int field) {
            return this.cursors[field].getLong();
        }

        public double getDouble(int field) {
            return this.cursors[field].getDouble();
        }

        public Slice getSlice(int field) {
            return this.cursors[field].getSlice();
        }

        public boolean isNull(int field) {
            return this.cursors[field].isNull();
        }

        public void close() {
        }
    }
}

