/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.index;

import com.facebook.presto.operator.LookupSource;
import com.facebook.presto.operator.PageBuilder;
import com.facebook.presto.spi.block.BlockCursor;
import com.google.common.base.Preconditions;
import javax.annotation.concurrent.Immutable;

@Immutable
public class IndexSnapshot {
    public static final long UNLOADED_INDEX_KEY = -2L;
    public static final long NO_MORE_POSITIONS = -1L;
    private final LookupSource values;
    private final LookupSource missingKeys;

    public IndexSnapshot(LookupSource values, LookupSource missingKeys) {
        this.values = (LookupSource)Preconditions.checkNotNull((Object)values, (Object)"values is null");
        this.missingKeys = (LookupSource)Preconditions.checkNotNull((Object)missingKeys, (Object)"missingKeys is null");
    }

    public long getJoinPosition(BlockCursor ... cursors) {
        long joinPosition = this.values.getJoinPosition(cursors);
        if (joinPosition < 0L) {
            if (this.missingKeys.getJoinPosition(cursors) < 0L) {
                return -2L;
            }
            return -1L;
        }
        return joinPosition;
    }

    public long getNextJoinPosition(long currentPosition) {
        return this.values.getNextJoinPosition(currentPosition);
    }

    public void appendTo(long position, PageBuilder pageBuilder, int outputChannelOffset) {
        this.values.appendTo(position, pageBuilder, outputChannelOffset);
    }
}

