/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.index;

import com.facebook.presto.operator.DriverFactory;
import com.facebook.presto.operator.LookupSource;
import com.facebook.presto.operator.LookupSourceSupplier;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.index.IndexLoader;
import com.facebook.presto.operator.index.IndexLookupSource;
import com.facebook.presto.operator.index.PagesIndexBuilderOperator;
import com.facebook.presto.spi.type.Type;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;

public class IndexLookupSourceSupplier
implements LookupSourceSupplier {
    private final IndexLoader indexLoader;

    public IndexLookupSourceSupplier(List<Integer> indexChannels, List<Type> types, int snapshotOperatorId, DriverFactory indexBuildDriverFactory, PagesIndexBuilderOperator.PagesIndexBuilderOperatorFactory pagesIndexOutput) {
        this.indexLoader = new IndexLoader(indexChannels, types, snapshotOperatorId, indexBuildDriverFactory, pagesIndexOutput, 100000);
    }

    @Override
    public List<Type> getTypes() {
        return this.indexLoader.getOutputTypes();
    }

    @Override
    public ListenableFuture<LookupSource> getLookupSource(OperatorContext operatorContext) {
        this.indexLoader.setContext(operatorContext.getDriverContext().getPipelineContext().getTaskContext());
        return Futures.immediateFuture((Object)new IndexLookupSource(this.indexLoader));
    }
}

