/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.state;

import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.google.common.base.Throwables;
import io.airlift.slice.Slice;
import java.lang.reflect.Method;
import javax.annotation.Nullable;

public final class StateCompilerUtils {
    private StateCompilerUtils() {
    }

    public static Method getBlockGetter(Class<?> type) {
        try {
            if (type == Long.TYPE) {
                return StateCompilerUtils.class.getMethod("getLongBlock", Block.class, Integer.TYPE);
            }
            if (type == Double.TYPE) {
                return StateCompilerUtils.class.getMethod("getDoubleBlock", Block.class, Integer.TYPE);
            }
            if (type == Boolean.TYPE) {
                return StateCompilerUtils.class.getMethod("getBooleanBlock", Block.class, Integer.TYPE);
            }
            if (type == Byte.TYPE) {
                return StateCompilerUtils.class.getMethod("getByteBlock", Block.class, Integer.TYPE);
            }
            if (type == Slice.class) {
                return StateCompilerUtils.class.getMethod("getSliceBlock", Block.class, Integer.TYPE);
            }
            throw new IllegalArgumentException("Unsupported type: " + type.getSimpleName());
        }
        catch (NoSuchMethodException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static Method getBlockBuilderAppend(Class<?> type) {
        try {
            if (type == Long.TYPE) {
                return StateCompilerUtils.class.getMethod("appendLongBlockBuilder", BlockBuilder.class, Long.TYPE);
            }
            if (type == Double.TYPE) {
                return StateCompilerUtils.class.getMethod("appendDoubleBlockBuilder", BlockBuilder.class, Double.TYPE);
            }
            if (type == Boolean.TYPE) {
                return StateCompilerUtils.class.getMethod("appendBooleanBlockBuilder", BlockBuilder.class, Boolean.TYPE);
            }
            if (type == Byte.TYPE) {
                return StateCompilerUtils.class.getMethod("appendByteBlockBuilder", BlockBuilder.class, Byte.TYPE);
            }
            if (type == Slice.class) {
                return StateCompilerUtils.class.getMethod("appendSliceBlockBuilder", BlockBuilder.class, Slice.class);
            }
            throw new IllegalArgumentException("Unsupported type: " + type.getSimpleName());
        }
        catch (NoSuchMethodException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static Method getSliceSetter(Class<?> type) {
        try {
            if (type == Long.TYPE) {
                return StateCompilerUtils.class.getMethod("setLongSlice", Slice.class, Integer.TYPE, Long.TYPE);
            }
            if (type == Double.TYPE) {
                return StateCompilerUtils.class.getMethod("setDoubleSlice", Slice.class, Integer.TYPE, Double.TYPE);
            }
            if (type == Boolean.TYPE) {
                return StateCompilerUtils.class.getMethod("setBooleanSlice", Slice.class, Integer.TYPE, Boolean.TYPE);
            }
            if (type == Byte.TYPE) {
                return StateCompilerUtils.class.getMethod("setByteSlice", Slice.class, Integer.TYPE, Byte.TYPE);
            }
            throw new IllegalArgumentException("Unsupported type: " + type.getSimpleName());
        }
        catch (NoSuchMethodException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static Method getSliceGetter(Class<?> type) {
        try {
            if (type == Long.TYPE) {
                return StateCompilerUtils.class.getMethod("getLongSlice", Slice.class, Integer.TYPE);
            }
            if (type == Double.TYPE) {
                return StateCompilerUtils.class.getMethod("getDoubleSlice", Slice.class, Integer.TYPE);
            }
            if (type == Boolean.TYPE) {
                return StateCompilerUtils.class.getMethod("getBooleanSlice", Slice.class, Integer.TYPE);
            }
            if (type == Byte.TYPE) {
                return StateCompilerUtils.class.getMethod("getByteSlice", Slice.class, Integer.TYPE);
            }
            throw new IllegalArgumentException("Unsupported type: " + type.getSimpleName());
        }
        catch (NoSuchMethodException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static long getLongBlock(Block block, int index) {
        return block.getLong(index);
    }

    public static byte getByteBlock(Block block, int index) {
        return (byte)block.getLong(index);
    }

    public static double getDoubleBlock(Block block, int index) {
        return block.getDouble(index);
    }

    public static boolean getBooleanBlock(Block block, int index) {
        return block.getBoolean(index);
    }

    public static Slice getSliceBlock(Block block, int index) {
        if (block.isNull(index)) {
            return null;
        }
        return block.getSlice(index);
    }

    public static void appendLongBlockBuilder(BlockBuilder builder, long value) {
        builder.appendLong(value);
    }

    public static void appendDoubleBlockBuilder(BlockBuilder builder, double value) {
        builder.appendDouble(value);
    }

    public static void appendBooleanBlockBuilder(BlockBuilder builder, boolean value) {
        builder.appendBoolean(value);
    }

    public static void appendByteBlockBuilder(BlockBuilder builder, byte value) {
        builder.appendLong((long)value);
    }

    public static void appendSliceBlockBuilder(BlockBuilder builder, @Nullable Slice value) {
        if (value == null) {
            builder.appendNull();
        } else {
            builder.appendSlice(value);
        }
    }

    public static void setLongSlice(Slice slice, int offset, long value) {
        slice.setLong(offset, value);
    }

    public static void setDoubleSlice(Slice slice, int offset, double value) {
        slice.setDouble(offset, value);
    }

    public static void setBooleanSlice(Slice slice, int offset, boolean value) {
        slice.setByte(offset, value ? 1 : 0);
    }

    public static void setByteSlice(Slice slice, int offset, byte value) {
        slice.setByte(offset, (int)value);
    }

    public static long getLongSlice(Slice slice, int offset) {
        return slice.getLong(offset);
    }

    public static double getDoubleSlice(Slice slice, int offset) {
        return slice.getDouble(offset);
    }

    public static boolean getBooleanSlice(Slice slice, int offset) {
        return slice.getByte(offset) == 1;
    }

    public static byte getByteSlice(Slice slice, int offset) {
        return slice.getByte(offset);
    }
}

