/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.operator.GroupByIdBlock;
import com.facebook.presto.operator.Page;
import com.facebook.presto.operator.aggregation.Accumulator;
import com.facebook.presto.operator.aggregation.AggregationFunction;
import com.facebook.presto.operator.aggregation.GroupedAccumulator;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.block.BlockCursor;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nullable;

public abstract class SimpleAggregationFunction
implements AggregationFunction {
    private final Type finalType;
    private final Type intermediateType;
    private final ImmutableList<Type> parameterTypes;

    public SimpleAggregationFunction(Type finalType, Type intermediateType, Type parameterType) {
        this.finalType = finalType;
        this.intermediateType = intermediateType;
        this.parameterTypes = ImmutableList.of((Object)parameterType);
    }

    @Override
    public final List<Type> getParameterTypes() {
        return this.parameterTypes;
    }

    @Override
    public final Type getFinalType() {
        return this.finalType;
    }

    @Override
    public final Type getIntermediateType() {
        return this.intermediateType;
    }

    @Override
    public boolean isDecomposable() {
        return true;
    }

    @Override
    public final GroupedAccumulator createGroupedAggregation(Optional<Integer> maskChannel, Optional<Integer> sampleWeightChannel, double confidence, int ... argumentChannels) {
        Preconditions.checkArgument((argumentChannels.length == 1 ? 1 : 0) != 0, (String)"Expected one argument channel, but got %s", (Object[])new Object[]{argumentChannels.length});
        return this.createGroupedAccumulator(maskChannel, sampleWeightChannel, confidence, argumentChannels[0]);
    }

    @Override
    public final GroupedAccumulator createGroupedIntermediateAggregation(double confidence) {
        return this.createGroupedAccumulator((Optional<Integer>)Optional.absent(), (Optional<Integer>)Optional.absent(), confidence, -1);
    }

    public static long computeSampleWeight(@Nullable BlockCursor masks, @Nullable BlockCursor sampleWeights) {
        long sampleWeight = masks != null ? (masks.getBoolean() ? 1L : 0L) : (sampleWeights != null ? sampleWeights.getLong() : 1L);
        return sampleWeight;
    }

    protected abstract GroupedAccumulator createGroupedAccumulator(Optional<Integer> var1, Optional<Integer> var2, double var3, int var5);

    @Override
    public final Accumulator createAggregation(Optional<Integer> maskChannel, Optional<Integer> sampleWeight, double confidence, int ... argumentChannels) {
        Preconditions.checkArgument((argumentChannels.length == 1 ? 1 : 0) != 0, (String)"Expected one argument channel, but got %s", (Object[])new Object[]{argumentChannels.length});
        return this.createAccumulator(maskChannel, sampleWeight, confidence, argumentChannels[0]);
    }

    @Override
    public final Accumulator createIntermediateAggregation(double confidence) {
        return this.createAccumulator((Optional<Integer>)Optional.absent(), (Optional<Integer>)Optional.absent(), confidence, -1);
    }

    protected abstract Accumulator createAccumulator(Optional<Integer> var1, Optional<Integer> var2, double var3, int var5);

    public static abstract class SimpleAccumulator
    implements Accumulator {
        private final int valueChannel;
        private final Type finalType;
        private final Type intermediateType;
        private final Optional<Integer> maskChannel;
        private final Optional<Integer> sampleWeightChannel;

        public SimpleAccumulator(int valueChannel, Type finalType, Type intermediateType, Optional<Integer> maskChannel, Optional<Integer> sampleWeightChannel) {
            this.valueChannel = valueChannel;
            this.finalType = finalType;
            this.intermediateType = intermediateType;
            this.maskChannel = maskChannel;
            this.sampleWeightChannel = sampleWeightChannel;
        }

        @Override
        public long getEstimatedSize() {
            return 0L;
        }

        @Override
        public final Type getFinalType() {
            return this.finalType;
        }

        @Override
        public final Type getIntermediateType() {
            return this.intermediateType;
        }

        @Override
        public final void addInput(Page page) {
            Preconditions.checkArgument((this.valueChannel != -1 ? 1 : 0) != 0, (Object)"Raw input is not allowed for a final aggregation");
            this.processInput(page.getBlock(this.valueChannel), (Optional<Block>)this.maskChannel.transform(page.blockGetter()), (Optional<Block>)this.sampleWeightChannel.transform(page.blockGetter()));
        }

        protected abstract void processInput(Block var1, Optional<Block> var2, Optional<Block> var3);

        @Override
        public final void addIntermediate(Block block) {
            Preconditions.checkArgument((this.valueChannel == -1 ? 1 : 0) != 0, (Object)"Intermediate input is only allowed for a final aggregation");
            this.processIntermediate(block);
        }

        protected void processIntermediate(Block block) {
            this.processInput(block, (Optional<Block>)Optional.absent(), (Optional<Block>)Optional.absent());
        }

        @Override
        public final Block evaluateIntermediate() {
            BlockBuilder out = this.intermediateType.createBlockBuilder(new BlockBuilderStatus());
            this.evaluateIntermediate(out);
            return out.build();
        }

        @Override
        public final Block evaluateFinal() {
            BlockBuilder out = this.finalType.createBlockBuilder(new BlockBuilderStatus());
            this.evaluateFinal(out);
            return out.build();
        }

        protected void evaluateIntermediate(BlockBuilder out) {
            this.evaluateFinal(out);
        }

        protected abstract void evaluateFinal(BlockBuilder var1);
    }

    public static abstract class SimpleGroupedAccumulator
    implements GroupedAccumulator {
        private final int valueChannel;
        private final Type finalType;
        private final Type intermediateType;
        private final Optional<Integer> maskChannel;
        private final Optional<Integer> sampleWeightChannel;

        public SimpleGroupedAccumulator(int valueChannel, Type finalType, Type intermediateType, Optional<Integer> maskChannel, Optional<Integer> sampleWeightChannel) {
            this.valueChannel = valueChannel;
            this.finalType = finalType;
            this.intermediateType = intermediateType;
            this.maskChannel = maskChannel;
            this.sampleWeightChannel = sampleWeightChannel;
        }

        @Override
        public long getEstimatedSize() {
            return 0L;
        }

        @Override
        public final Type getFinalType() {
            return this.finalType;
        }

        @Override
        public final Type getIntermediateType() {
            return this.intermediateType;
        }

        @Override
        public final void addInput(GroupByIdBlock groupIdsBlock, Page page) {
            Preconditions.checkArgument((this.valueChannel != -1 ? 1 : 0) != 0, (Object)"Raw input is not allowed for a final aggregation");
            this.processInput(groupIdsBlock, page.getBlock(this.valueChannel), (Optional<Block>)this.maskChannel.transform(page.blockGetter()), (Optional<Block>)this.sampleWeightChannel.transform(page.blockGetter()));
        }

        protected abstract void processInput(GroupByIdBlock var1, Block var2, Optional<Block> var3, Optional<Block> var4);

        @Override
        public final void addIntermediate(GroupByIdBlock groupIdsBlock, Block block) {
            Preconditions.checkArgument((this.valueChannel == -1 ? 1 : 0) != 0, (Object)"Intermediate input is only allowed for a final aggregation");
            this.processIntermediate(groupIdsBlock, block);
        }

        protected void processIntermediate(GroupByIdBlock groupIdsBlock, Block valuesBlock) {
            this.processInput(groupIdsBlock, valuesBlock, (Optional<Block>)Optional.absent(), (Optional<Block>)Optional.absent());
        }

        @Override
        public void evaluateIntermediate(int groupId, BlockBuilder output) {
            this.evaluateFinal(groupId, output);
        }

        @Override
        public abstract void evaluateFinal(int var1, BlockBuilder var2);
    }
}

